/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.scanner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.common.java.IParametedType;

public class ImplementationCollector {
    List<TypeDefinition> typeDefinitions;
    Set<IType> decorators = new HashSet<IType>();
    Set<IType> interceptors = new HashSet<IType>();

    public ImplementationCollector(List<TypeDefinition> typeDefinitions) {
        this.typeDefinitions = typeDefinitions;
        try {
            this.process();
        }
        catch (JavaModelException e) {
            CDICorePlugin.getDefault().logError(e);
        }
    }

    void process() throws JavaModelException {
        for (TypeDefinition typeDef : this.typeDefinitions) {
            IType type = typeDef.getType();
            if (type == null || !type.exists() || type.isInterface() || !this.mayBeRelevant(type)) continue;
            for (IParametedType t : typeDef.getInheritedTypes()) {
                List ps;
                IType q = t.getType();
                if (q == null) continue;
                String cn = q.getFullyQualifiedName();
                boolean isDecorator = "javax.enterprise.inject.spi.Decorator".equals(cn);
                boolean isInterceptor = "javax.enterprise.inject.spi.Interceptor".equals(cn);
                if (!isDecorator && !isInterceptor || (ps = t.getParameters()) == null) continue;
                for (IParametedType p : ps) {
                    IType pt = p.getType();
                    if (pt == null) continue;
                    if (isDecorator) {
                        this.decorators.add(pt);
                    }
                    if (!isInterceptor) continue;
                    this.interceptors.add(pt);
                }
            }
        }
    }

    boolean mayBeRelevant(IType type) throws JavaModelException {
        String[] is = type.getSuperInterfaceNames();
        if (is != null) {
            String[] stringArray = is;
            int n = is.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.indexOf("Decorator") >= 0) {
                    return true;
                }
                if (s.indexOf("Interceptor") >= 0) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isDecorator(IType type) {
        return this.decorators.contains(type);
    }

    public boolean isInterceptor(IType type) {
        return this.interceptors.contains(type);
    }
}

