/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.refactoring;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDICoreMessages;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.internal.core.refactoring.AbstractCDIProcessor;
import org.jboss.tools.common.refactoring.FileChangeFactory;

public abstract class CDIRefactoringProcessor
extends AbstractCDIProcessor {
    protected IFile file;
    protected TextFileChange change;
    protected IClassBean bean;

    public CDIRefactoringProcessor(IFile file, String label) {
        super(label);
        this.file = file;
    }

    public CDIRefactoringProcessor(String label) {
        super(label);
    }

    protected void createRootChange() {
        this.rootChange = new CompositeChange(this.getLabel());
        this.change = FileChangeFactory.getFileChange((IFile)this.file);
        MultiTextEdit root = new MultiTextEdit();
        this.change.setEdit((TextEdit)root);
        this.rootChange.add((Change)this.change);
    }

    private IClassBean findClassBean() {
        CDICoreNature cdiNature = CDICorePlugin.getCDI(this.file.getProject(), true);
        if (cdiNature == null) {
            return null;
        }
        ICDIProject cdiProject = cdiNature.getDelegate();
        if (cdiProject == null) {
            return null;
        }
        for (IBean bean : cdiProject.getBeans(this.file.getFullPath())) {
            if (!(bean instanceof IClassBean)) continue;
            return (IClassBean)bean;
        }
        return null;
    }

    public Object[] getElements() {
        return new Object[]{this.file};
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.status = new RefactoringStatus();
        if (this.isFileCorrect(this.file)) {
            this.bean = this.findClassBean();
        } else {
            this.status.addFatalError(CDICoreMessages.CDI_RENAME_PROCESSOR_ERROR_BEAN_NOT_FOUND);
        }
        return this.status;
    }
}

