/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IProducerMethod;
import org.jboss.tools.cdi.core.IScope;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.core.IStereotype;
import org.jboss.tools.cdi.core.IStereotypeDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.BeanMethod;
import org.jboss.tools.cdi.internal.core.impl.InjectionPointParameter;
import org.jboss.tools.cdi.internal.core.impl.Parameter;
import org.jboss.tools.cdi.internal.core.impl.definition.MethodDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.ParameterDefinition;
import org.jboss.tools.common.java.IAnnotationDeclaration;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.java.ITypeDeclaration;
import org.jboss.tools.common.java.ParametedType;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.util.BeanUtil;

public class ProducerMethod
extends BeanMethod
implements IProducerMethod {
    protected AnnotationDeclaration produces;
    ProducerMethod specialized = null;
    Map<String, ProducerMethod> specializingProducerMethods = null;

    @Override
    public void setDefinition(MethodDefinition definition) {
        super.setDefinition(definition);
        this.produces = definition.getProducesAnnotation();
    }

    @Override
    protected Parameter newParameter(ParameterDefinition p) {
        return new InjectionPointParameter();
    }

    @Override
    public Collection<ITypeDeclaration> getAllTypeDeclarations() {
        ArrayList<ITypeDeclaration> result = new ArrayList<ITypeDeclaration>(1);
        if (this.typeDeclaration != null) {
            result.add((ITypeDeclaration)this.typeDeclaration);
        }
        return result;
    }

    @Override
    public IAnnotationDeclaration getAlternativeDeclaration() {
        return this.getDefinition().getAlternativeAnnotation();
    }

    @Override
    public IType getBeanClass() {
        return this.getClassBean().getBeanClass();
    }

    @Override
    public Collection<IInjectionPoint> getInjectionPoints() {
        ArrayList<IInjectionPoint> result = new ArrayList<IInjectionPoint>();
        for (IParameter p : this.parameters) {
            if (!(p instanceof IInjectionPoint)) continue;
            result.add((IInjectionPoint)((Object)p));
        }
        return result;
    }

    @Override
    public Collection<IParametedType> getLegalTypes() {
        HashSet<IParametedType> result = new HashSet<IParametedType>();
        AnnotationDeclaration d = this.getDefinition().getTypedAnnotation();
        Collection<IParametedType> all = this.getAllTypes();
        if (d != null) {
            result.addAll(this.getRestrictedTypeDeclarations(all));
            ParametedType object = this.getObjectType((IMember)this.getBeanClass());
            if (object != null) {
                result.add((IParametedType)object);
            }
            return result;
        }
        return all;
    }

    @Override
    public Collection<IParametedType> getAllTypes() {
        if (this.typeDeclaration != null) {
            return this.typeDeclaration.getAllTypes();
        }
        return new ArrayList<IParametedType>(0);
    }

    @Override
    public Collection<ITypeDeclaration> getRestrictedTypeDeclaratios() {
        return this.getRestrictedTypeDeclarations(this.getAllTypes());
    }

    @Override
    public String getName() {
        String name;
        ProducerMethod specialized = this.getSpecializedBean();
        if (specialized != null && (name = specialized.getName()) != null) {
            return name;
        }
        AnnotationDeclaration named = this.findNamedAnnotation();
        if (named == null) {
            return null;
        }
        Object value = named.getMemberValue(null, true);
        if (value != null && value.toString().trim().length() > 0) {
            return value.toString().trim();
        }
        String name2 = this.getMethod().getElementName();
        if (BeanUtil.isGetter((IMethod)this.getMethod())) {
            return BeanUtil.getPropertyName((String)name2);
        }
        return name2;
    }

    @Override
    public ITextSourceReference getNameLocation(boolean stereotypeLocation) {
        return stereotypeLocation ? CDIUtil.getNamedDeclaration(this) : this.findNamedAnnotation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecializedBean(ProducerMethod other) {
        this.specialized = other;
        if (other != null) {
            ProducerMethod producerMethod = other;
            synchronized (producerMethod) {
                if (other.specializingProducerMethods == null) {
                    other.specializingProducerMethods = new HashMap<String, ProducerMethod>();
                }
                other.specializingProducerMethods.put(this.getBeanClass().getFullyQualifiedName(), this);
            }
        }
    }

    @Override
    public ProducerMethod getSpecializedBean() {
        if (this.getDefinition().getSpecializesAnnotation() == null) {
            return null;
        }
        return this.specialized;
    }

    @Override
    public IAnnotationDeclaration getSpecializesAnnotationDeclaration() {
        return this.getDefinition().getSpecializesAnnotation();
    }

    @Override
    public boolean isDependent() {
        IScope scope = this.getScope();
        return scope != null && "javax.enterprise.context.Dependent".equals(scope.getSourceType().getFullyQualifiedName());
    }

    synchronized boolean hasEnabledSpecializingProducerMethod() {
        if (this.specializingProducerMethods != null) {
            for (ProducerMethod sb : this.specializingProducerMethods.values()) {
                if (!sb.hasEnabledSpecializingProducerMethod() && !sb.isEnabled()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEnabled() {
        if (this.classBean != null && !this.classBean.isEnabled()) {
            return false;
        }
        if (this.hasEnabledSpecializingProducerMethod()) {
            return false;
        }
        if (this.isAlternative()) {
            if (this.classBean != null && !this.getCDIProject().getAlternatives(this.classBean.getBeanClass().getFullyQualifiedName()).isEmpty()) {
                return true;
            }
            for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
                IStereotype s = d.getStereotype();
                if (s == null || !s.isAlternative() || this.getCDIProject().getAlternatives(s.getSourceType().getFullyQualifiedName()).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isSpecializing() {
        return this.getDefinition().getSpecializesAnnotation() != null;
    }

    @Override
    public IScope getScope() {
        Collection<IScopeDeclaration> ds = this.getScopeDeclarations();
        if (!ds.isEmpty()) {
            return ds.iterator().next().getScope();
        }
        IScope defaultScope = null;
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            IScope sc = s.getScope();
            if (sc == null) continue;
            if (defaultScope == null) {
                defaultScope = sc;
                continue;
            }
            if (defaultScope == sc) continue;
            return null;
        }
        return defaultScope != null ? defaultScope : this.getCDIProject().getScope("javax.enterprise.context.Dependent");
    }

    @Override
    public IAnnotationDeclaration getProducesAnnotation() {
        return this.produces;
    }

    @Override
    public boolean isSelectedAlternative() {
        if (this.getCDIProject().isTypeAlternative(this.getBeanClass().getFullyQualifiedName())) {
            return true;
        }
        for (IStereotypeDeclaration d : this.getStereotypeDeclarations()) {
            IStereotype s = d.getStereotype();
            if (s == null || !s.isAlternative() || !this.getCDIProject().isStereotypeAlternative(s.getSourceType().getFullyQualifiedName())) continue;
            return true;
        }
        return false;
    }
}

