/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.internal.core.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.CDIUtil;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMember;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.core.IClassBean;
import org.jboss.tools.cdi.internal.core.el.BeanRelevanceCheck;
import org.jboss.tools.cdi.internal.core.impl.CDIProjectAsYouType;
import org.jboss.tools.common.el.core.ca.AbstractELCompletionEngine;
import org.jboss.tools.common.el.core.model.ELInvocationExpression;
import org.jboss.tools.common.el.core.parser.ELParserFactory;
import org.jboss.tools.common.el.core.parser.ELParserUtil;
import org.jboss.tools.common.el.core.resolver.ELContext;
import org.jboss.tools.common.el.core.resolver.IRelevanceCheck;
import org.jboss.tools.common.el.core.resolver.TypeInfoCollector;
import org.jboss.tools.common.text.TextProposal;

public class CdiElResolver
extends AbstractELCompletionEngine<IBean> {
    private static ELParserFactory factory = ELParserUtil.getJbossFactory();

    public ImageDescriptor getELProposalImageForMember(TypeInfoCollector.MemberInfo memberInfo) {
        return memberInfo instanceof TypeInfoCollector.FieldInfo ? CDIImages.BEAN_FIELD_IMAGE : CDIImages.BEAN_METHOD_IMAGE;
    }

    protected ImageDescriptor getELProposalImage(TypeInfoCollector.MemberPresentation memberPresentation) {
        return memberPresentation.isProperty() ? CDIImages.BEAN_FIELD_IMAGE : CDIImages.BEAN_METHOD_IMAGE;
    }

    protected void setImage(TextProposal kbProposal, IBean var) {
        kbProposal.setImageDescriptor(CDIImages.getImageDescriptorByElement(var));
    }

    protected void log(Exception e) {
        CDICorePlugin.getDefault().logError(e);
    }

    protected TypeInfoCollector.MemberInfo getMemberInfoByVariable(IBean bean, ELContext context, boolean onlyEqualNames, int offset) {
        IType member = null;
        if (bean instanceof IClassBean) {
            member = bean.getBeanClass();
        } else if (bean instanceof IBeanMember) {
            IBeanMember beanMember = (IBeanMember)((Object)bean);
            member = beanMember.getSourceMember();
        } else {
            member = bean.getBeanClass();
        }
        return TypeInfoCollector.createMemberInfo((IMember)member);
    }

    public List<IBean> resolveVariables(IFile file, ELContext context, ELInvocationExpression expr, boolean isFinal, boolean onlyEqualNames, int offset) {
        ICDIProject cdiProject;
        CDICoreNature nature;
        ArrayList<IBean> beans = new ArrayList<IBean>();
        IProject project = file.getProject();
        if (project == null) {
            return beans;
        }
        String varName = expr.toString();
        Collection<IBean> resolvedBeans = null;
        if (varName != null && (nature = CDIUtil.getCDINatureWithProgress(project)) != null && (cdiProject = nature.getDelegate()) != null) {
            if (context != null && context.isDirty() && ("java".equalsIgnoreCase(file.getFileExtension()) || "beans.xml".equalsIgnoreCase(file.getName()))) {
                cdiProject = new CDIProjectAsYouType(cdiProject, file);
            }
            if (onlyEqualNames) {
                resolvedBeans = cdiProject.getBeans(varName, true);
                if (resolvedBeans.isEmpty()) {
                    resolvedBeans = cdiProject.getBeans(varName, false);
                }
                beans.addAll(resolvedBeans);
            } else {
                resolvedBeans = cdiProject.getNamedBeans(true);
                if (resolvedBeans.isEmpty()) {
                    resolvedBeans = cdiProject.getBeans(varName, false);
                }
                for (IBean bean : resolvedBeans) {
                    if (!bean.getName().startsWith(varName)) continue;
                    beans.add(bean);
                }
                resolvedBeans.clear();
                resolvedBeans.addAll(beans);
            }
        }
        if (resolvedBeans != null && !resolvedBeans.isEmpty()) {
            ArrayList<IBean> newResolvedVars = new ArrayList<IBean>();
            for (IBean var : resolvedBeans) {
                if (!isFinal) {
                    if (!varName.equals(var.getName())) continue;
                    newResolvedVars.add(var);
                    continue;
                }
                newResolvedVars.add(var);
            }
            return newResolvedVars;
        }
        return beans;
    }

    public ELParserFactory getParserFactory() {
        return factory;
    }

    protected boolean isStaticMethodsCollectingEnabled() {
        return true;
    }

    public IRelevanceCheck createRelevanceCheck(IJavaElement element) {
        return new BeanRelevanceCheck(element);
    }
}

