/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core.util;

import org.eclipse.core.runtime.IPath;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IBeanMember;
import org.jboss.tools.cdi.core.ICDIElement;
import org.jboss.tools.cdi.core.IInjectionPoint;
import org.jboss.tools.cdi.core.IInjectionPointField;
import org.jboss.tools.cdi.core.IInjectionPointParameter;
import org.jboss.tools.cdi.core.IParameter;
import org.jboss.tools.cdi.core.IProducer;
import org.jboss.tools.cdi.internal.core.impl.AbstractBeanElement;
import org.jboss.tools.cdi.internal.core.impl.DisposerMethod;
import org.jboss.tools.cdi.internal.core.impl.EventBean;
import org.jboss.tools.cdi.internal.core.impl.InitializerMethod;
import org.jboss.tools.cdi.internal.core.impl.ObserverMethod;
import org.jboss.tools.cdi.internal.core.impl.ProducerField;
import org.jboss.tools.cdi.internal.core.impl.ProducerMethod;

public class BeanPresentationUtil {
    public static final String SEPARATOR = " - ";
    public static final String DOT = ".";

    public static String getBeanKind(IBean bean) {
        if (bean.isAlternative()) {
            return "@Alternative";
        }
        if (bean.isAnnotationPresent("javax.decorator.Decorator")) {
            return "@Decorator";
        }
        if (bean.isAnnotationPresent("javax.interceptor.Interceptor")) {
            return "@Interceptor";
        }
        if (bean instanceof IProducer) {
            return "@Produces";
        }
        if (bean instanceof EventBean) {
            return "Event";
        }
        return null;
    }

    public static String getBeanLocation(IBean bean, boolean includeElementName) {
        StringBuilder sb = new StringBuilder();
        sb.append(SEPARATOR);
        Object origin = null;
        if (bean instanceof AbstractBeanElement) {
            AbstractBeanElement e = (AbstractBeanElement)((Object)bean);
            origin = e.getDefinition().getOriginalDefinition();
        }
        if (origin != null) {
            sb.append(origin.toString());
        } else {
            String pkg = bean.getBeanClass().getPackageFragment().getElementName();
            if (pkg.length() > 0) {
                sb.append(pkg);
            }
            if (includeElementName) {
                if (pkg.length() > 0) {
                    sb.append(DOT);
                }
                sb.append(bean.getElementName());
            }
            sb.append(SEPARATOR);
            IPath path = bean.getBeanClass().getPackageFragment().getParent().getPath();
            sb.append(path.toString());
        }
        return sb.toString();
    }

    public static String getCDIElementKind(ICDIElement element) {
        if (element instanceof IBean) {
            return BeanPresentationUtil.getBeanKind((IBean)element);
        }
        if (element instanceof IInjectionPointField) {
            return "Injection Point Field";
        }
        if (element instanceof IInjectionPointParameter) {
            return "Injection Point Parameter";
        }
        if (element instanceof DisposerMethod) {
            return "Disposer Method";
        }
        if (element instanceof InitializerMethod) {
            return "Initializer Method";
        }
        if (element instanceof ObserverMethod) {
            return "Observer Method";
        }
        if (element instanceof ProducerMethod) {
            return "Producer Method";
        }
        if (element instanceof ProducerField) {
            return "Producer Field";
        }
        if (element instanceof IParameter) {
            return "Parameter";
        }
        return null;
    }

    public static String getCDIElementLocation(ICDIElement element, boolean includeElementName) {
        if (element instanceof IBean) {
            return BeanPresentationUtil.getBeanLocation((IBean)element, includeElementName);
        }
        if (element instanceof IInjectionPoint) {
            return BeanPresentationUtil.getBeanLocation(((IInjectionPoint)element).getBean(), includeElementName);
        }
        if (element instanceof IBeanMember) {
            return BeanPresentationUtil.getBeanLocation(((IBeanMember)element).getClassBean(), includeElementName);
        }
        return null;
    }
}

