/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.extension.CDIExtensionFactory;
import org.jboss.tools.cdi.core.extension.ICDIExtension;
import org.jboss.tools.cdi.core.extension.feature.IAmbiguousBeanResolverFeature;
import org.jboss.tools.cdi.core.extension.feature.IBuildParticipantFeature;
import org.jboss.tools.cdi.core.extension.feature.ICDIFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedMemberFeature;
import org.jboss.tools.cdi.core.extension.feature.IProcessAnnotatedTypeFeature;
import org.jboss.tools.cdi.core.extension.feature.IValidatorFeature;

public class CDIExtensionManager {
    CDICoreNature n;
    Map<String, Set<String>> runtimes = new HashMap<String, Set<String>>();
    Set<String> allRuntimes = new HashSet<String>();
    Map<String, ICDIExtension> instances = new HashMap<String, ICDIExtension>();
    Map<String, ICDIExtension> instancesByRuntime = new HashMap<String, ICDIExtension>();
    Map<Class<?>, Set<ICDIExtension>> featureToExtensions = new HashMap();
    Map<Class<? extends ICDIFeature>, Set<?>> featureStorage = new HashMap();
    static Set<ICDIExtension> EMPTY = new HashSet<ICDIExtension>();

    public void setProject(CDICoreNature n) {
        this.n = n;
    }

    public boolean isCDIExtensionAvailable(String runtimeClassName) {
        return this.allRuntimes.contains(runtimeClassName);
    }

    public void pathRemoved(String path) {
        Set<String> rs = this.runtimes.remove(path);
        if (rs == null) {
            return;
        }
        for (String runtime : rs) {
            this.deleteRuntime(runtime);
        }
    }

    public boolean setRuntimes(String path, Set<String> newRuntimes) {
        Set<String> oldRuntimes = this.runtimes.get(path);
        if (oldRuntimes == null) {
            if (newRuntimes.isEmpty()) {
                return false;
            }
            oldRuntimes = new HashSet<String>();
        }
        boolean result = false;
        for (String runtime : oldRuntimes) {
            if (newRuntimes.contains(runtime)) continue;
            this.deleteRuntime(runtime);
            result = true;
        }
        for (String runtime : newRuntimes) {
            if (oldRuntimes.contains(runtime)) continue;
            this.addRuntime(runtime);
            result = true;
        }
        if (newRuntimes.isEmpty()) {
            this.runtimes.remove(path);
        } else {
            this.runtimes.put(path, newRuntimes);
        }
        return result;
    }

    private void addRuntime(String runtime) {
        this.allRuntimes.add(runtime);
        CDIExtensionFactory factory = CDIExtensionFactory.getInstance();
        Set<String> clss = factory.getExtensionClassesByRuntime(runtime);
        if (clss != null) {
            for (String cls : clss) {
                ICDIExtension ext = factory.createExtensionInstance(cls);
                if (ext == null) continue;
                this.instances.put(cls, ext);
                this.instancesByRuntime.put(runtime, ext);
                for (Class<?> feature : CDIExtensionFactory.getInstance().getFeatures(ext)) {
                    Set<ICDIExtension> es = this.featureToExtensions.get(feature);
                    if (es == null) {
                        es = new HashSet<ICDIExtension>();
                        this.featureToExtensions.put(feature, es);
                    }
                    es.add(ext);
                }
                this.featureStorage.clear();
            }
        }
    }

    private void deleteRuntime(String runtime) {
        this.allRuntimes.remove(runtime);
        this.instancesByRuntime.remove(runtime);
        Set<String> clss = CDIExtensionFactory.getInstance().getExtensionClassesByRuntime(runtime);
        if (clss != null) {
            for (String cls : clss) {
                Class[] is;
                ICDIExtension ext = this.instances.remove(cls);
                if (ext == null) continue;
                Class[] classArray = is = this.featureToExtensions.keySet().toArray(new Class[0]);
                int n = is.length;
                int n2 = 0;
                while (n2 < n) {
                    Class feature = classArray[n2];
                    Set<ICDIExtension> es = this.featureToExtensions.get(feature);
                    if (es != null) {
                        es.remove(ext);
                        if (es.isEmpty()) {
                            this.featureToExtensions.remove(feature);
                        }
                    }
                    ++n2;
                }
            }
            if (!clss.isEmpty()) {
                this.featureStorage.clear();
            }
        }
    }

    public Set<ICDIExtension> getExtensions(Class<?> feature) {
        return this.featureToExtensions.containsKey(feature) ? this.featureToExtensions.get(feature) : EMPTY;
    }

    public ICDIExtension getExtensionByRuntime(String runtime) {
        return this.instancesByRuntime.get(runtime);
    }

    public Set<IProcessAnnotatedMemberFeature> getProcessAnnotatedMemberFeatures() {
        return this.getFeatures(IProcessAnnotatedMemberFeature.class);
    }

    public Set<IProcessAnnotatedTypeFeature> getProcessAnnotatedTypeFeatures() {
        return this.getFeatures(IProcessAnnotatedTypeFeature.class);
    }

    public Set<IBuildParticipantFeature> getBuildParticipantFeatures() {
        return this.getFeatures(IBuildParticipantFeature.class);
    }

    public Set<IAmbiguousBeanResolverFeature> getAmbiguousBeanResolverFeatures() {
        return this.getFeatures(IAmbiguousBeanResolverFeature.class);
    }

    public Set<IValidatorFeature> getValidatorFeatures() {
        return this.getFeatures(IValidatorFeature.class);
    }

    public <F extends ICDIFeature> Set<F> getFeatures(Class<F> cls) {
        Set<?> result = this.featureStorage.get(cls);
        if (result == null) {
            result = new HashSet();
            Set<ICDIExtension> extensions = this.getExtensions(cls);
            if (!extensions.isEmpty()) {
                for (ICDIExtension ext : extensions) {
                    ICDIFeature feature = (ICDIFeature)CDIExtensionFactory.adaptTo(ext, cls);
                    if (feature == null) continue;
                    result.add(feature);
                }
            }
            this.featureStorage.put(cls, result);
        }
        return result;
    }
}

