/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.ICDICache;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.internal.core.event.CDIProjectChangeEvent;
import org.jboss.tools.cdi.internal.core.event.ICDIProjectChangeListener;
import org.jboss.tools.cdi.internal.core.scanner.lib.BeanArchiveDetector;
import org.jboss.tools.common.log.BaseUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class CDICorePlugin
extends BaseUIPlugin {
    public static final String PLUGIN_ID = "org.jboss.tools.cdi.core";
    public static final String CA_CDI_EL_IMAGE_PATH = "images/ca/icons_CDI_EL.gif";
    private static CDICorePlugin plugin;
    IResourceChangeListener resourceChangeListener = new RCL();
    private static List<ICDIProjectChangeListener> listeners;
    boolean cacheIsLoaded = false;
    ICDICache cache;

    static {
        listeners = new ArrayList<ICDIProjectChangeListener>();
    }

    public CDICorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        ResourcesPlugin.getWorkspace().addSaveParticipant(PLUGIN_ID, new ISaveParticipant(){

            public void saving(ISaveContext context) throws CoreException {
                BeanArchiveDetector.getInstance().save();
            }

            public void rollback(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void doneSaving(ISaveContext context) {
            }
        });
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.stop(context);
    }

    public static CDICorePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return CDICorePlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static ICDIProject getCDIProject(IProject project, boolean resolve) {
        CDICoreNature nature = CDICorePlugin.getCDI(project, resolve);
        if (nature != null) {
            return nature.getDelegate();
        }
        return null;
    }

    private static CDICoreNature getCDINature(IProject project) {
        if (project == null || !project.exists() || !project.isOpen()) {
            return null;
        }
        try {
            if (!project.hasNature(CDICoreNature.NATURE_ID)) {
                return null;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        CDICoreNature n = null;
        try {
            n = (CDICoreNature)project.getNature(CDICoreNature.NATURE_ID);
        }
        catch (CoreException e) {
            CDICorePlugin.getDefault().logError(e);
        }
        return n;
    }

    public static CDICoreNature getCDI(IProject project, boolean resolve) {
        CDICoreNature n = CDICorePlugin.getCDINature(project);
        if (n != null) {
            if (resolve) {
                n.resolve();
            } else {
                n.loadProjectDependencies();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCDIProjectListener(ICDIProjectChangeListener listener) {
        List<ICDIProjectChangeListener> list = listeners;
        synchronized (list) {
            if (listeners.contains(listener)) {
                return;
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCDIProjectListener(ICDIProjectChangeListener listener) {
        List<ICDIProjectChangeListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fire(CDIProjectChangeEvent event) {
        ICDIProjectChangeListener[] ls = null;
        List<ICDIProjectChangeListener> list = listeners;
        synchronized (list) {
            ls = listeners.toArray(new ICDIProjectChangeListener[listeners.size()]);
        }
        ICDIProjectChangeListener[] iCDIProjectChangeListenerArray = ls;
        int n = ls.length;
        int n2 = 0;
        while (n2 < n) {
            ICDIProjectChangeListener l = iCDIProjectChangeListenerArray[n2];
            l.projectChanged(event);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICDICache getDBCache() {
        if (!this.cacheIsLoaded) {
            CDICorePlugin cDICorePlugin = this;
            synchronized (cDICorePlugin) {
                block15: {
                    if (!this.cacheIsLoaded) {
                        block14: {
                            try {
                                try {
                                    Bundle b = Platform.getBundle((String)"org.jboss.tools.cdi.db");
                                    if (b == null) break block14;
                                    try {
                                        Class c = b.loadClass("org.jboss.tools.cdi.db.CDIDataBase");
                                        if (c != null) {
                                            this.cache = (ICDICache)c.newInstance();
                                        }
                                    }
                                    catch (ClassNotFoundException e) {
                                        this.logError(e);
                                    }
                                    catch (InstantiationException e) {
                                        this.logError(e);
                                    }
                                    catch (IllegalAccessException e) {
                                        this.logError(e);
                                    }
                                }
                                catch (Throwable t) {
                                    this.logError(t);
                                    this.cacheIsLoaded = true;
                                    break block15;
                                }
                            }
                            catch (Throwable throwable) {
                                this.cacheIsLoaded = true;
                                throw throwable;
                            }
                        }
                        this.cacheIsLoaded = true;
                    }
                }
            }
        }
        return this.cache;
    }

    class RCL
    implements IResourceChangeListener {
        RCL() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4 || event.getType() == 2) {
                IProject p;
                CDICoreNature n;
                IResource r = event.getResource();
                if (r instanceof IProject && (n = CDICorePlugin.getCDINature(p = (IProject)r)) != null) {
                    n.dispose();
                }
            } else if (event.getType() == 1) {
                IResourceDelta[] cs;
                IResourceDelta[] iResourceDeltaArray = cs = event.getDelta().getAffectedChildren(4);
                int n = cs.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta c = iResourceDeltaArray[n2];
                    if ((c.getFlags() & 0x4000) != 0 && c.getResource() instanceof IProject) {
                        IProject p = (IProject)c.getResource();
                        CDICorePlugin.getCDI(p, true);
                    }
                    ++n2;
                }
            }
        }
    }
}

