/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.model.commands;

import org.eclipse.gef.commands.Command;
import org.jboss.tools.jsf.ui.editor.dnd.DndHelper;
import org.jboss.tools.jsf.ui.editor.edit.JSFEditPart;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.ILink;

public class ConnectionCommand
extends Command {
    protected JSFEditPart oldSource;
    protected String oldSourceTerminal;
    protected JSFEditPart oldTarget;
    protected String oldTargetTerminal;
    protected JSFEditPart source;
    protected String sourceTerminal;
    protected JSFEditPart target;
    protected String targetTerminal;
    protected ILink link;

    public ConnectionCommand() {
        super("connection command");
    }

    public boolean canExecute() {
        if (this.target == null) {
            return false;
        }
        if (this.target.getModel() == null) {
            return false;
        }
        return DndHelper.isDropEnabled(((IGroup)this.target.getModel()).getSource());
    }

    public void execute() {
        DndHelper.drop(((IGroup)this.target.getModel()).getSource());
    }

    public String getLabel() {
        return "connection command";
    }

    public JSFEditPart getSource() {
        return this.source;
    }

    public String getSourceTerminal() {
        return this.sourceTerminal;
    }

    public JSFEditPart getTarget() {
        return this.target;
    }

    public String getTargetTerminal() {
        return this.targetTerminal;
    }

    public ILink getLink() {
        return this.link;
    }

    public void setSource(JSFEditPart newSource) {
        this.source = newSource;
    }

    public void setSourceTerminal(String newSourceTerminal) {
        this.sourceTerminal = newSourceTerminal;
    }

    public void setTarget(JSFEditPart newTarget) {
        this.target = newTarget;
    }

    public void setTargetTerminal(String newTargetTerminal) {
        this.targetTerminal = newTargetTerminal;
    }

    public void setLink(ILink l) {
        this.link = l;
    }

    public boolean canUndo() {
        return false;
    }
}

