/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.ui.editor.edit;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.handles.ResizeHandle;
import org.eclipse.gef.requests.CreateRequest;
import org.jboss.tools.jsf.messages.JSFUIMessages;
import org.jboss.tools.jsf.ui.editor.edit.GroupEditPart;
import org.jboss.tools.jsf.ui.editor.figures.GroupFeedbackFigure;
import org.jboss.tools.jsf.ui.editor.figures.NodeFigure;
import org.jboss.tools.jsf.ui.editor.model.IGroup;
import org.jboss.tools.jsf.ui.editor.model.IJSFElement;
import org.jboss.tools.jsf.ui.editor.model.commands.SetConstraintCommand;

public class JSFXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    protected Command createAddCommand(EditPart childEditPart, Object constraint) {
        SetConstraintCommand setConstraint = new SetConstraintCommand();
        setConstraint.setLocation((Rectangle)constraint);
        setConstraint.setPart((IJSFElement)childEditPart.getModel());
        setConstraint.setLabel(JSFUIMessages.REPARENTING_JSFSUBPART);
        setConstraint.setDebugLabel("LogicXYEP setConstraint");
        return setConstraint;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        SetConstraintCommand locationCommand = new SetConstraintCommand();
        locationCommand.setShell(child.getViewer().getControl().getShell());
        locationCommand.setPart((IJSFElement)child.getModel());
        locationCommand.setLocation((Rectangle)constraint);
        return locationCommand;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new CustomPolicy();
    }

    protected Command getCreateCommand(CreateRequest request) {
        return null;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return null;
    }

    class CustomPolicy
    extends NonResizableEditPolicy {
        CustomPolicy() {
        }

        protected IFigure createDragSourceFeedbackFigure() {
            GroupEditPart part = (GroupEditPart)this.getHost();
            IFigure child = this.getCustomFeedbackFigure(part.getModel());
            this.addFeedback(child);
            Rectangle childBounds = part.getFigure().getBounds().getCopy();
            IFigure walker = part.getFigure().getParent();
            while (walker != ((GraphicalEditPart)part.getParent()).getFigure()) {
                walker.translateToParent((Translatable)childBounds);
                walker = walker.getParent();
            }
            child.setBounds(childBounds);
            return child;
        }

        protected IFigure getFeedbackLayer() {
            return this.getLayer("Scaled Feedback Layer");
        }

        protected IFigure getCustomFeedbackFigure(Object modelPart) {
            GroupFeedbackFigure figure;
            if (modelPart instanceof IGroup) {
                figure = new GroupFeedbackFigure();
            } else {
                figure = new RectangleFigure();
                ((RectangleFigure)figure).setXOR(true);
                ((RectangleFigure)figure).setFill(true);
                figure.setBackgroundColor(NodeFigure.ghostFillColor);
                figure.setForegroundColor(NodeFigure.whiteColor);
            }
            return figure;
        }

        protected List createSelectionHandles() {
            ArrayList<Handle> list = new ArrayList<Handle>();
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 20));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 12));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 9));
            list.add(this.createHandle((GraphicalEditPart)this.getHost(), 17));
            return list;
        }

        Handle createHandle(GraphicalEditPart owner, int direction) {
            ResizeHandle handle = new ResizeHandle(owner, direction);
            handle.setCursor(SharedCursors.SIZEALL);
            return handle;
        }
    }
}

