/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.providers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelListener;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.ui.PrefsInitializer;
import org.jboss.ide.eclipse.archives.ui.providers.ArchivesContentProviderDelegate;

public class ArchivesRootBridgeContentProvider
implements ITreeContentProvider,
PrefsInitializer.IArchivesPreferenceListener,
IArchiveModelListener {
    private ArchivesContentProviderDelegate delegate = new ArchivesContentProviderDelegate(2);
    private Viewer viewer;

    public ArchivesRootBridgeContentProvider() {
        ArchivesModel.instance().addModelListener((IArchiveModelListener)this);
        PrefsInitializer.addListener(this);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            if (((IProject)parentElement).isOpen()) {
                boolean nodeExists;
                IPath loc = ((IProject)parentElement).getLocation();
                boolean alwaysShow = PrefsInitializer.getBoolean("alwaysShowProjectExplorerNode");
                boolean fileExists = ArchivesModel.instance().canReregister(loc);
                boolean bl = nodeExists = ArchivesModel.instance().getRoot(loc) != null;
                if (alwaysShow || fileExists || nodeExists) {
                    return new Object[]{new ArchivesContentProviderDelegate.WrappedProject((IProject)parentElement, 2)};
                }
            }
            return new Object[0];
        }
        return this.delegate.getChildren(parentElement);
    }

    public Object getParent(Object element) {
        return this.delegate.getParent(element);
    }

    public boolean hasChildren(Object element) {
        return this.delegate.hasChildren(element);
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
        PrefsInitializer.removeListener(this);
        ArchivesModel.instance().removeModelListener((IArchiveModelListener)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        this.delegate.inputChanged(viewer, oldInput, newInput);
    }

    public void preferenceChanged(String key, boolean val) {
        this.viewer.refresh();
    }

    public void preferenceChanged(String key, String val) {
        this.viewer.refresh();
    }

    public void modelChanged(IArchiveNodeDelta delta) {
        int k = delta.getKind();
        if (k == 2048 || k == 4096) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ArchivesRootBridgeContentProvider.this.viewer.refresh();
                }
            });
        }
    }
}

