/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.xulrunner.editor;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.xulrunner.editor.IVpeResizeListener;
import org.jboss.tools.vpe.xulrunner.editor.IXulRunnerVpeResizer;
import org.jboss.tools.vpe.xulrunner.editor.VpeResizerMouseListener;
import org.jboss.tools.vpe.xulrunner.editor.VpeResizerMouseMotionListener;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerHint;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.jboss.tools.vpe.xulrunner.util.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;

public class XulRunnerVpeResizer
implements IXulRunnerVpeResizer {
    private static String RESIZING_INFO_FORMAT = "%s x %s";
    private static Point RESIZING_INFO_OFFSET = new Point(20, 20);
    private static final String RESIZER_MARKER_STRING_TOPLEFT = "nw";
    private static final String RESIZER_MARKER_STRING_TOP = "n";
    private static final String RESIZER_MARKER_STRING_TOPRIGHT = "ne";
    private static final String RESIZER_MARKER_STRING_LEFT = "w";
    private static final String RESIZER_MARKER_STRING_RIGHT = "e";
    private static final String RESIZER_MARKER_STRING_BOTTOMLEFT = "sw";
    private static final String RESIZER_MARKER_STRING_BOTTOM = "s";
    private static final String RESIZER_MARKER_STRING_BOTTOMRIGHT = "se";
    private static final int MAX_SIZE = 20000000;
    nsIDOMEventListener mouseListener;
    nsIDOMEventListener mouseMotionListener;
    private ArrayList<IVpeResizeListener> objectResizeEventListeners = new ArrayList();
    private boolean isResizing;
    private int originalX;
    private int originalY;
    private int usedResizeMarker;
    private int incrementFactorX;
    private int incrementFactorY;
    private int incrementFactorWidth;
    private int incrementFactorHeight;
    private nsIDOMElement resizingObject;
    private nsIDOMElement resizingShadow;
    private XulRunnerHint resizingInfo;
    private nsIDOMDocument domDocument;
    private nsIDOMElement activeHandle;
    private Rectangle elementBounds;
    private nsIDOMElement markerTopLeft = null;
    private nsIDOMElement markerTop = null;
    private nsIDOMElement markerTopRight = null;
    private nsIDOMElement markerLeft = null;
    private nsIDOMElement markerRight = null;
    private nsIDOMElement markerBottom = null;
    private nsIDOMElement markerBottomLeft = null;
    private nsIDOMElement markerBottomRight = null;

    @Override
    public void init(nsIDOMDocument domDocument) {
        this.domDocument = domDocument;
        this.mouseListener = new VpeResizerMouseListener(this);
    }

    @Override
    public void show(nsIDOMElement domElement, int resizers) {
        if (this.resizingObject != null) {
            this.hide();
        }
        this.resizingObject = domElement;
        this.elementBounds = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)domElement);
        if (this.elementBounds.width <= 0 || this.elementBounds.width > 20000000 || this.elementBounds.height <= 0 || this.elementBounds.height > 20000000) {
            return;
        }
        nsIDOMElement bodyElement = XulRunnerVpeUtils.getRootElement(this.domDocument);
        if (bodyElement == null) {
            return;
        }
        if ((resizers & 1) == 1) {
            this.markerTopLeft = this.createResizer(RESIZER_MARKER_STRING_TOPLEFT, (nsIDOMNode)bodyElement);
            if (this.markerTopLeft == null) {
                return;
            }
        }
        if ((resizers & 2) == 2) {
            this.markerTop = this.createResizer(RESIZER_MARKER_STRING_TOP, (nsIDOMNode)bodyElement);
            if (this.markerTop == null) {
                return;
            }
        }
        if ((resizers & 4) == 4) {
            this.markerTopRight = this.createResizer(RESIZER_MARKER_STRING_TOPRIGHT, (nsIDOMNode)bodyElement);
            if (this.markerTopRight == null) {
                return;
            }
        }
        if ((resizers & 8) == 8) {
            this.markerLeft = this.createResizer(RESIZER_MARKER_STRING_LEFT, (nsIDOMNode)bodyElement);
            if (this.markerLeft == null) {
                return;
            }
        }
        if ((resizers & 0x10) == 16) {
            this.markerRight = this.createResizer(RESIZER_MARKER_STRING_RIGHT, (nsIDOMNode)bodyElement);
            if (this.markerRight == null) {
                return;
            }
        }
        if ((resizers & 0x20) == 32) {
            this.markerBottomLeft = this.createResizer(RESIZER_MARKER_STRING_BOTTOMLEFT, (nsIDOMNode)bodyElement);
            if (this.markerBottomLeft == null) {
                return;
            }
        }
        if ((resizers & 0x40) == 64) {
            this.markerBottom = this.createResizer(RESIZER_MARKER_STRING_BOTTOM, (nsIDOMNode)bodyElement);
            if (this.markerBottom == null) {
                return;
            }
        }
        if ((resizers & 0x80) == 128) {
            this.markerBottomRight = this.createResizer(RESIZER_MARKER_STRING_BOTTOMRIGHT, (nsIDOMNode)bodyElement);
            if (this.markerBottomRight == null) {
                return;
            }
        }
        this.setAllResizersPosition();
        this.resizingShadow = this.createShadow((nsIDOMNode)bodyElement);
        XulRunnerVpeUtils.setElementPosition(this.resizingShadow, this.elementBounds.x, this.elementBounds.y);
        this.resizingInfo = new XulRunnerHint(this.domDocument);
    }

    @Override
    public void hide() {
        nsIDOMElement bodyElement;
        if (this.resizingInfo != null) {
            this.resizingInfo.dispose();
            this.resizingInfo = null;
        }
        if ((bodyElement = XulRunnerVpeUtils.getRootElement(this.domDocument)) == null) {
            return;
        }
        nsIDOMNode parentNode = XPCOM.queryInterface((nsISupports)bodyElement, nsIDOMNode.class);
        if (parentNode == null) {
            return;
        }
        if (this.markerTopLeft != null) {
            parentNode.removeChild((nsIDOMNode)this.markerTopLeft);
        }
        if (this.markerTop != null) {
            parentNode.removeChild((nsIDOMNode)this.markerTop);
        }
        if (this.markerTopRight != null) {
            parentNode.removeChild((nsIDOMNode)this.markerTopRight);
        }
        if (this.markerLeft != null) {
            parentNode.removeChild((nsIDOMNode)this.markerLeft);
        }
        if (this.markerRight != null) {
            parentNode.removeChild((nsIDOMNode)this.markerRight);
        }
        if (this.markerBottomLeft != null) {
            parentNode.removeChild((nsIDOMNode)this.markerBottomLeft);
        }
        if (this.markerBottom != null) {
            parentNode.removeChild((nsIDOMNode)this.markerBottom);
        }
        if (this.markerBottomRight != null) {
            parentNode.removeChild((nsIDOMNode)this.markerBottomRight);
        }
        if (this.resizingShadow != null) {
            parentNode.removeChild((nsIDOMNode)this.resizingShadow);
            this.resizingShadow = null;
        }
        this.markerBottom = null;
        this.markerTop = null;
        this.markerLeft = null;
        this.markerRight = null;
        this.markerBottomRight = null;
        this.markerBottomLeft = null;
        this.markerTopRight = null;
        this.markerTopLeft = null;
        this.resizingObject = null;
    }

    @Override
    public void mouseDown(int clientX, int clientY, nsIDOMElement domElement) {
        String anonclass;
        boolean isAnonElement;
        if (domElement != null && (isAnonElement = domElement.hasAttribute("_moz_anonclass")) && (anonclass = domElement.getAttribute("_moz_anonclass")) != null && anonclass.equals("mozResizer")) {
            this.originalX = clientX;
            this.originalY = clientY;
            this.startResizing(domElement);
        }
    }

    @Override
    public void mouseMove(nsIDOMEvent event) {
        if (this.isResizing) {
            nsIDOMMouseEvent mouseEvent = XPCOM.queryInterface((nsISupports)event, nsIDOMMouseEvent.class);
            int clientX = mouseEvent.getClientX();
            int clientY = mouseEvent.getClientY();
            int newX = this.getNewResizingX(clientX, clientY);
            int newY = this.getNewResizingY(clientX, clientY);
            int newWidth = this.getNewResizingWidth(clientX, clientY);
            int newHeight = this.getNewResizingHeight(clientX, clientY);
            Rectangle shadowBounds = new Rectangle(newX, newY, newWidth, newHeight);
            XulRunnerVpeUtils.setElementBounds(this.resizingShadow, shadowBounds);
            this.redrawResizingInfo(shadowBounds);
        }
    }

    private void redrawResizingInfo(Rectangle bounds) {
        Point position;
        switch (this.usedResizeMarker) {
            case 1: {
                position = new Point(bounds.x, bounds.y);
                break;
            }
            case 2: {
                position = new Point(bounds.x + bounds.width / 2, bounds.y);
                break;
            }
            case 4: {
                position = new Point(bounds.x + bounds.width, bounds.y);
                break;
            }
            case 8: {
                position = new Point(bounds.x, bounds.y + bounds.height / 2);
                break;
            }
            case 16: {
                position = new Point(bounds.x + bounds.width, bounds.y + bounds.height / 2);
                break;
            }
            case 32: {
                position = new Point(bounds.x, bounds.y + bounds.height);
                break;
            }
            case 64: {
                position = new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height);
                break;
            }
            case 128: {
                position = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
                break;
            }
            default: {
                position = new Point(0, 0);
            }
        }
        position.x += XulRunnerVpeResizer.RESIZING_INFO_OFFSET.x;
        position.y += XulRunnerVpeResizer.RESIZING_INFO_OFFSET.y;
        this.resizingInfo.setHint(String.format(RESIZING_INFO_FORMAT, bounds.width, bounds.height));
        this.resizingInfo.setPosition(position);
        this.resizingInfo.redraw();
    }

    @Override
    public void mouseUp(int aX, int aY, nsIDOMElement target) {
        if (this.isResizing) {
            this.isResizing = false;
            this.endResizing(aX, aY);
            nsIDOMEventTarget erP = this.getDOMEventTarget();
            if (erP != null) {
                erP.removeEventListener("mousemove", this.mouseMotionListener, true);
                erP.removeEventListener("mouseup", this.mouseListener, true);
                this.mouseMotionListener = null;
            }
        }
    }

    @Override
    public void addResizeListener(IVpeResizeListener listener) {
        if (this.objectResizeEventListeners.size() != 0 && this.objectResizeEventListeners.indexOf(listener) != -1) {
            return;
        }
        this.objectResizeEventListeners.add(listener);
    }

    @Override
    public void removeResizeListener(IVpeResizeListener listener) {
        if (this.objectResizeEventListeners.size() == 0 || this.objectResizeEventListeners.indexOf(listener) == -1) {
            return;
        }
        this.objectResizeEventListeners.remove(listener);
    }

    private nsIDOMElement createShadow(nsIDOMNode parentNode) {
        return XulRunnerVpeUtils.createAnonymousElement(this.domDocument, "span", parentNode, "mozResizingShadow", true);
    }

    private nsIDOMElement createResizingInfo(nsIDOMNode parentNode) {
        return XulRunnerVpeUtils.createAnonymousElement(this.domDocument, "span", parentNode, "mozResizingInfo", true);
    }

    private void startResizing(nsIDOMElement domElement) {
        this.isResizing = true;
        this.activeHandle = domElement;
        this.activeHandle.setAttribute("_moz_activated", "true");
        String locationStr = this.activeHandle.getAttribute("anonlocation");
        if (locationStr == null) {
            return;
        }
        if (locationStr.equals(RESIZER_MARKER_STRING_TOPLEFT)) {
            this.usedResizeMarker = 1;
            this.setResizeIncrements(1, 1, -1, -1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_TOP)) {
            this.usedResizeMarker = 2;
            this.setResizeIncrements(0, 1, 0, -1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_TOPRIGHT)) {
            this.usedResizeMarker = 4;
            this.setResizeIncrements(0, 1, 1, -1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_LEFT)) {
            this.usedResizeMarker = 8;
            this.setResizeIncrements(1, 0, -1, 0, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_RIGHT)) {
            this.usedResizeMarker = 16;
            this.setResizeIncrements(0, 0, 1, 0, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_BOTTOMLEFT)) {
            this.usedResizeMarker = 32;
            this.setResizeIncrements(1, 0, -1, 1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_BOTTOM)) {
            this.usedResizeMarker = 64;
            this.setResizeIncrements(0, 0, 0, 1, false);
        } else if (locationStr.equals(RESIZER_MARKER_STRING_BOTTOMRIGHT)) {
            this.usedResizeMarker = 128;
            this.setResizeIncrements(0, 0, 1, 1, false);
        }
        this.resizingShadow.removeAttribute("class");
        XulRunnerVpeUtils.setElementBounds(this.resizingShadow, this.elementBounds);
        this.redrawResizingInfo(this.elementBounds);
        if (this.mouseMotionListener != null) {
            return;
        }
        this.mouseMotionListener = new VpeResizerMouseMotionListener(this);
        if (this.mouseMotionListener == null) {
            return;
        }
        nsIDOMEventTarget eventTarget = this.getDOMEventTarget();
        if (eventTarget != null) {
            eventTarget.addEventListener("mousemove", this.mouseMotionListener, true);
            eventTarget.addEventListener("mouseup", this.mouseListener, true);
        }
    }

    private nsIDOMEventTarget getDOMEventTarget() {
        nsIDOMEventTarget eventTarget = XPCOM.queryInterface((nsISupports)this.domDocument, nsIDOMEventTarget.class);
        if (eventTarget == null) {
            throw new RuntimeException("nsIDOMEventTarget is null");
        }
        return eventTarget;
    }

    private int getNewResizingX(int aX, int aY) {
        int resized = this.elementBounds.x + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.X) * this.incrementFactorX;
        int max = this.elementBounds.x + this.elementBounds.width;
        return Math.min(resized, max);
    }

    private int getNewResizingY(int aX, int aY) {
        int resized = this.elementBounds.y + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.Y) * this.incrementFactorY;
        int max = this.elementBounds.y + this.elementBounds.height;
        return Math.min(resized, max);
    }

    private int getNewResizingWidth(int aX, int aY) {
        int resized = this.elementBounds.width + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.WIDTH) * this.incrementFactorWidth;
        return Math.max(resized, 1);
    }

    private int getNewResizingHeight(int aX, int aY) {
        int resized = this.elementBounds.height + this.getNewResizingIncrement(aX, aY, COEFFICIENT_TYPE.HEIGHT) * this.incrementFactorHeight;
        return Math.max(resized, 1);
    }

    private int getNewResizingIncrement(int aX, int aY, COEFFICIENT_TYPE coefficient_type) {
        int result = 0;
        switch (coefficient_type) {
            case X: 
            case WIDTH: {
                result = aX - this.originalX;
                break;
            }
            case Y: 
            case HEIGHT: {
                result = aY - this.originalY;
            }
        }
        return result;
    }

    private nsIDOMElement createResizer(String resizerMarkerString, nsIDOMNode parentNode) {
        nsIDOMElement aNewResizer = XulRunnerVpeUtils.createAnonymousElement(this.domDocument, "span", parentNode, "mozResizer", false);
        nsIDOMEventTarget evtTarget = XPCOM.queryInterface((nsISupports)aNewResizer, nsIDOMEventTarget.class);
        evtTarget.addEventListener("mousedown", this.mouseListener, true);
        aNewResizer.setAttribute("anonlocation", resizerMarkerString);
        return aNewResizer;
    }

    private void setAllResizersPosition() {
        int left = this.elementBounds.x;
        int top = this.elementBounds.y;
        int width = this.elementBounds.width;
        int height = this.elementBounds.height;
        int resizerWidth = 5;
        int resizerHeight = 5;
        int rw = (resizerWidth + 1) / 2;
        int rh = (resizerHeight + 1) / 2;
        if (this.markerTopLeft != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerTopLeft, left - resizerWidth - 2, top - resizerHeight - 2);
        }
        if (this.markerTop != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerTop, left + width / 2 - rw, top - resizerHeight - 2);
        }
        if (this.markerTopRight != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerTopRight, left + width, top - resizerHeight - 2);
        }
        if (this.markerLeft != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerLeft, left - resizerWidth - 2, top + height / 2 - rh);
        }
        if (this.markerRight != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerRight, left + width, top + height / 2 - rh);
        }
        if (this.markerBottomLeft != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerBottomLeft, left - resizerWidth - 2, top + height);
        }
        if (this.markerBottom != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerBottom, left + width / 2 - rw, top + height);
        }
        if (this.markerBottomRight != null) {
            XulRunnerVpeUtils.setElementPosition(this.markerBottomRight, left + width, top + height);
        }
    }

    private void setResizeIncrements(int aX, int aY, int aW, int aH, boolean aPreserveRatio) {
        this.incrementFactorX = aX;
        this.incrementFactorY = aY;
        this.incrementFactorWidth = aW;
        this.incrementFactorHeight = aH;
    }

    private void endResizing(int aClientX, int aClientY) {
        if (this.resizingShadow == null) {
            return;
        }
        this.resizingShadow.setAttribute("class", "hidden");
        if (this.resizingInfo == null) {
            return;
        }
        this.resizingInfo.dispose();
        if (this.activeHandle != null) {
            this.activeHandle.removeAttribute("_moz_activated");
            this.activeHandle = null;
        }
        int left = this.getNewResizingX(aClientX, aClientY);
        int top = this.getNewResizingY(aClientX, aClientY);
        int width = this.getNewResizingWidth(aClientX, aClientY);
        int height = this.getNewResizingHeight(aClientX, aClientY);
        if (this.objectResizeEventListeners.size() != 0) {
            for (IVpeResizeListener resizeListener : this.objectResizeEventListeners) {
                resizeListener.onEndResizing(this.usedResizeMarker, top, left, width, height, this.resizingObject);
            }
        }
        this.usedResizeMarker = 0;
    }

    @Override
    public void dispose() {
        nsIDOMEventTarget erP;
        if (this.mouseMotionListener != null && (erP = this.getDOMEventTarget()) != null) {
            erP.removeEventListener("mousemove", this.mouseMotionListener, true);
            erP.removeEventListener("mouseup", this.mouseListener, true);
            this.mouseMotionListener = null;
        }
    }

    static enum COEFFICIENT_TYPE {
        X,
        Y,
        WIDTH,
        HEIGHT;

    }
}

