/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.publishers.patterns;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.jboss.ide.eclipse.as.core.publishers.patterns.ModulePathFilterUtility;
import org.jboss.ide.eclipse.as.core.publishers.patterns.internal.PublishFilterDirectoryScanner;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;

public class ModuleDirectoryScannerPathFilter
implements IModulePathFilter {
    private static final String[] EMPTY_PATHS = new String[0];
    private PublishFilterDirectoryScanner scanner;
    private boolean scanned = false;
    private IModuleResource[] raw;
    private IModuleResource[] cleanedResources;

    public ModuleDirectoryScannerPathFilter(IModule module, String includes, String excludes) throws CoreException {
        this(module, ModuleDirectoryScannerPathFilter.explode(includes), ModuleDirectoryScannerPathFilter.explode(excludes));
    }

    private static String[] explode(String pattern) {
        if (pattern == null) {
            return EMPTY_PATHS;
        }
        return pattern.split(",");
    }

    public ModuleDirectoryScannerPathFilter(IModule module, String[] includes, String[] excludes) throws CoreException {
        this.raw = ModuleResourceUtil.getMembers((IModule)module);
        this.scanner = new PublishFilterDirectoryScanner(this.raw);
        this.scanner.setIncludes(includes);
        this.scanner.setExcludes(excludes);
    }

    public ModuleDirectoryScannerPathFilter(IModule module, PublishFilterDirectoryScanner scanner) throws CoreException {
        this.raw = ModuleResourceUtil.getMembers((IModule)module);
        this.scanner = scanner;
    }

    private synchronized void ensureScanned() {
        if (!this.scanned) {
            this.scanner.scan();
            this.scanned = true;
        }
    }

    public boolean shouldInclude(IModuleResource moduleResource) {
        this.ensureScanned();
        return this.scanner.isRequiredMember(moduleResource);
    }

    public IModuleResource[] getFilteredMembers() throws CoreException {
        this.ensureScanned();
        if (this.cleanedResources == null) {
            this.cleanedResources = new ModulePathFilterUtility(this).getCleanedMembers(this.raw);
        }
        return this.cleanedResources;
    }

    public IModuleResourceDelta[] getFilteredDelta(IModuleResourceDelta[] delta) throws CoreException {
        this.ensureScanned();
        return new ModulePathFilterUtility(this).getCleanedDelta(delta);
    }
}

