/*
 * Decompiled with CFR 0.152.
 */
package tern.eclipse.ide.tools.internal.ui.wizards.webbrowser;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import tern.eclipse.ide.core.TernCorePlugin;
import tern.eclipse.ide.tools.core.webbrowser.EditorOptions;
import tern.eclipse.ide.tools.internal.ui.TernToolsUIMessages;
import tern.eclipse.ide.tools.internal.ui.wizards.TernWizardPage;
import tern.eclipse.ide.ui.controls.TernModulesBlock;
import tern.metadata.TernModuleMetadata;
import tern.repository.ITernRepository;
import tern.server.ITernDef;
import tern.server.ITernModule;
import tern.server.ITernPlugin;
import tern.utils.TernModuleHelper;

public class TernModulesSelectionWizardPage
extends TernWizardPage<EditorOptions> {
    private static final String PAGE = "TernModulesSelectionWizardPage";
    private TernModulesBlock modulesBlock;

    protected TernModulesSelectionWizardPage() {
        super(PAGE);
        this.setTitle(TernToolsUIMessages.TernModulesSelectionWizardPage_title);
        this.setDescription(TernToolsUIMessages.TernModulesSelectionWizardPage_description);
    }

    @Override
    protected Composite createUI(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        IResource resource = super.getResource();
        IProject project = resource != null ? resource.getProject() : null;
        this.modulesBlock = new TernModulesBlock(project, null);
        Control control = this.modulesBlock.createControl(container);
        this.modulesBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TernModulesSelectionWizardPage.this.dialogChanged();
            }
        });
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        return container;
    }

    @Override
    protected void initialize() {
        this.modulesBlock.loadModules();
    }

    @Override
    protected String validate() {
        return null;
    }

    @Override
    protected void updateModel(EditorOptions model) {
        ITernRepository repository = TernCorePlugin.getTernRepositoryManager().getRepository(this.modulesBlock.getProject());
        Object[] modules = this.modulesBlock.getCheckedModules();
        ArrayList defs = new ArrayList();
        ArrayList plugins = new ArrayList();
        ITernModule module = null;
        ITernModule dependencyModule = null;
        TernModuleMetadata metadata = null;
        Collection requiredDependencies = null;
        int i = 0;
        while (i < modules.length) {
            module = (ITernModule)modules[i];
            metadata = module.getMetadata();
            if (metadata != null) {
                requiredDependencies = metadata.getRequiredDependencies(module.getVersion());
                for (String dependency : requiredDependencies) {
                    dependencyModule = repository.getModule(dependency);
                    if (dependencyModule == null) continue;
                    TernModuleHelper.update(defs, plugins, (ITernModule)dependencyModule);
                }
            }
            TernModuleHelper.update(defs, plugins, (ITernModule)module);
            ++i;
        }
        model.setTernDefs(defs.toArray(ITernDef.EMPTY_DEF));
        model.setTernPlugins(plugins.toArray(ITernPlugin.EMPTY_PLUGIN));
        model.setRepository(repository);
        model.setProject(this.modulesBlock.getProject());
    }
}

