/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.Messages;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListenerManager;
import org.jboss.ide.eclipse.as.jmx.integration.JMXClassLoaderRepository;
import org.jboss.tools.jmx.core.AbstractConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderEventEmitter;
import org.jboss.tools.jmx.core.IConnectionWrapper;

public abstract class AbstractJBossJMXConnectionProvider
extends AbstractConnectionProvider
implements IConnectionProvider,
IConnectionProviderEventEmitter,
IConnectionCategory {
    private HashMap<String, IConnectionWrapper> idToConnection;

    public AbstractJBossJMXConnectionProvider() {
        UnitedServerListener listener = this.createUnitedListener();
        UnitedServerListenerManager.getDefault().addListener(listener);
    }

    private UnitedServerListener createUnitedListener() {
        UnitedServerListener listener = new UnitedServerListener(){

            public void serverChanged(ServerEvent event) {
                if (AbstractJBossJMXConnectionProvider.this.belongsHere(event.getServer())) {
                    AbstractJBossJMXConnectionProvider.this.getConnections();
                    IConnectionWrapper con = (IConnectionWrapper)AbstractJBossJMXConnectionProvider.this.idToConnection.get(event.getServer().getId());
                    if (con != null) {
                        if (1.serverSwitchesToState((ServerEvent)event, (int)2)) {
                            AbstractJBossJMXConnectionProvider.this.fireAdded(con);
                        } else if (1.serverSwitchesToState((ServerEvent)event, (int)4)) {
                            AbstractJBossJMXConnectionProvider.this.fireRemoved(con);
                        }
                    }
                }
            }

            public void serverAdded(IServer server) {
                if (AbstractJBossJMXConnectionProvider.this.belongsHere(server)) {
                    AbstractJBossJMXConnectionProvider.this.getConnections();
                    if (!AbstractJBossJMXConnectionProvider.this.idToConnection.containsKey(server.getId())) {
                        IConnectionWrapper connection = AbstractJBossJMXConnectionProvider.this.createConnection(server);
                        AbstractJBossJMXConnectionProvider.this.idToConnection.put(server.getId(), connection);
                        if (connection != null && server.getServerState() == 2) {
                            AbstractJBossJMXConnectionProvider.this.fireAdded((IConnectionWrapper)AbstractJBossJMXConnectionProvider.this.idToConnection.get(server.getId()));
                        }
                    }
                }
            }

            public void serverChanged(IServer server) {
                if (AbstractJBossJMXConnectionProvider.this.belongsHere(server)) {
                    AbstractJBossJMXConnectionProvider.this.getConnections();
                    Object o = AbstractJBossJMXConnectionProvider.this.idToConnection.get(server.getId());
                    if (o == null) {
                        IConnectionWrapper connection = AbstractJBossJMXConnectionProvider.this.createConnection(server);
                        AbstractJBossJMXConnectionProvider.this.idToConnection.put(server.getId(), connection);
                        if (connection != null && server.getServerState() == 2) {
                            AbstractJBossJMXConnectionProvider.this.fireAdded((IConnectionWrapper)AbstractJBossJMXConnectionProvider.this.idToConnection.get(server.getId()));
                        }
                    }
                }
            }

            public void serverRemoved(IServer server) {
                if (AbstractJBossJMXConnectionProvider.this.belongsHere(server)) {
                    if (AbstractJBossJMXConnectionProvider.this.idToConnection != null) {
                        IConnectionWrapper connection = (IConnectionWrapper)AbstractJBossJMXConnectionProvider.this.idToConnection.get(server.getId());
                        if (connection != null) {
                            AbstractJBossJMXConnectionProvider.this.idToConnection.remove(server.getId());
                            AbstractJBossJMXConnectionProvider.this.fireRemoved(connection);
                        }
                    } else {
                        AbstractJBossJMXConnectionProvider.this.getConnections();
                        IConnectionWrapper dummy = AbstractJBossJMXConnectionProvider.this.createConnection(server);
                        if (dummy != null) {
                            AbstractJBossJMXConnectionProvider.this.fireRemoved(dummy);
                        }
                    }
                }
            }
        };
        return listener;
    }

    protected abstract boolean belongsHere(IServer var1);

    public abstract String getId();

    protected abstract IConnectionWrapper createConnection(IServer var1);

    public abstract String getName(IConnectionWrapper var1);

    public IConnectionWrapper findConnection(IServer s) {
        this.getConnections();
        return this.idToConnection.get(s.getId());
    }

    public IConnectionWrapper[] getConnections() {
        if (this.idToConnection == null) {
            this.idToConnection = new HashMap();
            IServer[] allServers = ServerCore.getServers();
            int i = 0;
            while (i < allServers.length) {
                IConnectionWrapper c;
                if (this.belongsHere(allServers[i]) && (c = this.createConnection(allServers[i])) != null) {
                    this.idToConnection.put(allServers[i].getId(), c);
                }
                ++i;
            }
        }
        ArrayList<IConnectionWrapper> list = new ArrayList<IConnectionWrapper>();
        Set<String> serverIds = this.idToConnection.keySet();
        for (String id : serverIds) {
            if (!this.isServerStarted(id)) continue;
            list.add(this.idToConnection.get(id));
        }
        return list.toArray(new IConnectionWrapper[list.size()]);
    }

    private boolean isServerStarted(String id) {
        IServer s = ServerCore.findServer((String)id);
        if (s != null) {
            return s.getServerState() == 2;
        }
        return false;
    }

    public boolean canCreate() {
        return false;
    }

    public IConnectionWrapper createConnection(Map map) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", Messages.NotSupported, null));
    }

    public void addConnection(IConnectionWrapper connection) {
    }

    public void removeConnection(IConnectionWrapper connection) {
    }

    public boolean canDelete(IConnectionWrapper wrapper) {
        return false;
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }

    public boolean hasClassloaderRepository() {
        return false;
    }

    public JMXClassLoaderRepository getClassloaderRepository() {
        return null;
    }

    public String getCategoryId() {
        return "IConnectionCategory.server";
    }
}

