/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.core.transform;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.vpe.preview.core.Activator;
import org.jboss.tools.vpe.preview.core.transform.DomUtil;
import org.jboss.tools.vpe.preview.core.transform.ResourceAcceptor;
import org.jboss.tools.vpe.preview.core.transform.VpvDomBuilder;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModel;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolder;
import org.jboss.tools.vpe.preview.core.transform.VpvVisualModelHolderRegistry;
import org.w3c.dom.Document;

public class VpvController {
    private VpvDomBuilder domBuilder;
    private VpvVisualModelHolderRegistry visualModelHolderRegistry;

    public VpvController(VpvDomBuilder domBuilder, VpvVisualModelHolderRegistry visualModelHolderRegistry) {
        this.domBuilder = domBuilder;
        this.visualModelHolderRegistry = visualModelHolderRegistry;
    }

    public void getResource(String path, Integer viewId, ResourceAcceptor resourceAcceptor) {
        String mimeType;
        File file;
        VpvVisualModelHolder visualModelHolder;
        VpvVisualModel visualModel;
        IFile requestedFile;
        Path workspacePath;
        block24: {
            workspacePath = new Path(path);
            requestedFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)workspacePath);
            visualModel = null;
            IStructuredModel sourceModel = null;
            try {
                try {
                    sourceModel = StructuredModelManager.getModelManager().getExistingModelForRead(requestedFile);
                    if (sourceModel == null) {
                        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                        ITextFileBuffer buffer = null;
                        IFileStore fileStore = EFS.getStore((URI)workspacePath.toFile().toURI());
                        bufferManager.connectFileStore(fileStore, (IProgressMonitor)new NullProgressMonitor());
                        buffer = bufferManager.getFileStoreTextFileBuffer(fileStore);
                        IDocument document = buffer.getDocument();
                        if (document instanceof IStructuredDocument) {
                            IModelManager modelManager = StructuredModelManager.getModelManager();
                            sourceModel = modelManager.getModelForRead((IStructuredDocument)document);
                        }
                    }
                    IDOMDocument sourceDocument = null;
                    if (sourceModel instanceof IDOMModel) {
                        IDOMModel sourceDomModel = (IDOMModel)sourceModel;
                        sourceDocument = sourceDomModel.getDocument();
                    }
                    if (sourceDocument != null) {
                        try {
                            visualModel = this.domBuilder.buildVisualModel((Document)sourceDocument);
                        }
                        catch (ParserConfigurationException e) {
                            Activator.logError(e);
                        }
                    }
                }
                catch (Exception e) {
                    Activator.logError(e);
                    if (sourceModel != null) {
                        sourceModel.releaseFromRead();
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (sourceModel != null) {
                    sourceModel.releaseFromRead();
                }
                throw throwable;
            }
            if (sourceModel != null) {
                sourceModel.releaseFromRead();
            }
        }
        if ((visualModelHolder = this.visualModelHolderRegistry.getHolderById(viewId)) != null) {
            visualModelHolder.setVisualModel(visualModel);
        }
        String htmlText = null;
        if (visualModel != null) {
            try {
                htmlText = DomUtil.nodeToString(visualModel.getVisualDocument());
            }
            catch (TransformerException e) {
                Activator.logError(e);
            }
        }
        if (htmlText != null) {
            resourceAcceptor.acceptText("<!DOCTYPE html>\n" + htmlText, "text/html");
        } else if (requestedFile.getLocation() != null && requestedFile.getLocation().toFile() != null && requestedFile.getLocation().toFile().exists()) {
            file = requestedFile.getLocation().toFile();
            mimeType = VpvController.getMimeType(file);
            resourceAcceptor.acceptFile(file, mimeType);
        } else if (workspacePath.isAbsolute() && workspacePath.toFile().exists()) {
            file = workspacePath.toFile();
            mimeType = VpvController.getMimeType(file);
            resourceAcceptor.acceptFile(file, mimeType);
        } else {
            resourceAcceptor.acceptError();
        }
    }

    private static String getMimeType(File file) {
        try {
            MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap(Activator.getFileUrl("lib/mime.types").openStream());
            return mimeTypes.getContentType(file);
        }
        catch (IOException e) {
            Activator.logError(e);
            return "application/octet-stream";
        }
    }
}

