/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.portlet.ui.internal.libprov;

import java.util.List;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryProviderOperationPanel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.portlet.core.IPortletConstants;
import org.jboss.tools.portlet.core.libprov.AbstractLibraryProviderInstallOperationConfig;
import org.jboss.tools.portlet.ui.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPortletProviderInstallPanel
extends LibraryProviderOperationPanel {
    private Button addRichFacesLibraries;
    private Combo richFacesLibraryCombo;
    private Text richfacesText;
    private AbstractLibraryProviderInstallOperationConfig config;
    private Button richfacesButton;
    private boolean isEPP;

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.config = (AbstractLibraryProviderInstallOperationConfig)this.getOperationConfig();
        this.isEPP = this.config.isEPP();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.addMessage(composite);
        this.addPortletBridgeGroup(composite, this.isEPP);
        this.addRichfacesGroup(composite, this.isEPP);
        return composite;
    }

    protected abstract void addMessage(Composite var1);

    protected abstract void addPortletBridgeGroup(Composite var1, boolean var2);

    protected abstract List<String> getRichfacesTypes();

    private void addRichfacesGroup(Composite composite, boolean isEPP) {
        Group richfacesGroup = new Group(composite, 0);
        richfacesGroup.setLayout((Layout)new GridLayout(2, false));
        richfacesGroup.setText(Messages.JSFPortletFacetInstallPage_Richfaces_Capabilities);
        GridData gd = new GridData(768);
        richfacesGroup.setLayoutData((Object)gd);
        this.addRichFacesLibraries = new Button((Composite)richfacesGroup, 32);
        this.addRichFacesLibraries.setText(Messages.JSFPortletFacetInstallPage_Add_Change_Richfaces_Libraries);
        this.addRichFacesLibraries.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPortletProviderInstallPanel.this.enableRichfacesLibraries();
                AbstractPortletProviderInstallPanel.this.config.setAddRichfacesCapabilities(AbstractPortletProviderInstallPanel.this.addRichFacesLibraries.getSelection());
            }
        });
        if (isEPP) {
            return;
        }
        this.richFacesLibraryCombo = new Combo((Composite)richfacesGroup, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.richFacesLibraryCombo.setLayoutData((Object)gd);
        this.configureRichfacesCombo();
        this.richFacesLibraryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(AbstractPortletProviderInstallPanel.this.richFacesLibraryCombo.getText());
                AbstractPortletProviderInstallPanel.this.richfacesText.setEnabled(enabled);
                AbstractPortletProviderInstallPanel.this.richfacesButton.setEnabled(enabled);
                AbstractPortletProviderInstallPanel.this.config.setRichfacesType(AbstractPortletProviderInstallPanel.this.richFacesLibraryCombo.getText());
            }
        });
        this.addRichFaces((Composite)richfacesGroup);
        boolean richFacesLibrariesSelected = this.config.isAddRichfacesCapabilities();
        this.addRichFacesLibraries.setSelection(richFacesLibrariesSelected);
        this.enableRichfacesLibraries();
        this.richFacesLibraryCombo.select(0);
        this.config.setRichfacesType(this.richFacesLibraryCombo.getText());
        if (isEPP) {
            this.richFacesLibraryCombo.setEnabled(false);
            this.richfacesButton.setEnabled(false);
            this.richfacesText.setEnabled(false);
        }
    }

    private void configureRichfacesCombo() {
        List<String> types = this.getRichfacesTypes();
        for (String type : types) {
            this.richFacesLibraryCombo.add(type);
        }
    }

    private void addRichFaces(Composite parent) {
        this.richfacesText = new Text(parent, 2052);
        this.richfacesText.setLayoutData((Object)new GridData(768));
        String richfacesRuntime = this.config.getRichfacesRuntime();
        if (richfacesRuntime == null) {
            richfacesRuntime = "";
        }
        this.richfacesText.setText(richfacesRuntime);
        this.richfacesText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPortletProviderInstallPanel.this.config.setRichfacesRuntime(AbstractPortletProviderInstallPanel.this.richfacesText.getText());
            }
        });
        this.richfacesButton = new Button(parent, 8);
        this.richfacesButton.setText(Messages.JSFPortletFacetInstallPage_Browse);
        this.richfacesButton.setLayoutData((Object)new GridData(256));
        this.richfacesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractPortletProviderInstallPanel.this.handleRichFacesButtonPressed();
            }
        });
    }

    private void handleRichFacesButtonPressed() {
        String lastPath = this.richfacesText.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 2);
        dialog.setText(Messages.JSFPortletFacetInstallPage_Select_RichFaces_Runtime);
        dialog.setFilterPath(lastPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String newPath = dialog.getFilterPath();
        this.richfacesText.setText(newPath);
    }

    private void enableRichfacesLibraries() {
        if (this.isEPP) {
            return;
        }
        boolean enabled = this.addRichFacesLibraries.getSelection();
        this.richFacesLibraryCombo.setEnabled(enabled);
        if (enabled) {
            enabled = IPortletConstants.LIBRARIES_PROVIDED_BY_RICHFACES.equals(this.richFacesLibraryCombo.getText());
            this.richfacesText.setEnabled(enabled);
            this.richfacesButton.setEnabled(enabled);
        } else {
            this.richfacesText.setEnabled(false);
            this.richfacesButton.setEnabled(false);
        }
    }

    protected Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }
}

