/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.seam.solder.core.generic;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.cdi.core.IQualifierDeclaration;
import org.jboss.tools.cdi.internal.core.impl.AnnotationDeclaration;
import org.jboss.tools.cdi.internal.core.impl.definition.AbstractMemberDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.AnnotationDefinition;
import org.jboss.tools.cdi.internal.core.impl.definition.TypeDefinition;
import org.jboss.tools.cdi.seam.solder.core.CDISeamSolderCorePlugin;
import org.jboss.tools.cdi.seam.solder.core.generic.GenericBeanDefinitionContext;
import org.jboss.tools.common.java.IParametedType;
import org.jboss.tools.common.util.EclipseJavaUtil;

public class GenericConfiguration {
    String genericTypeName;
    AnnotationDefinition genericType;
    IParametedType configType;
    Map<AbstractMemberDefinition, List<IQualifierDeclaration>> genericConfigurationPoints = new HashMap<AbstractMemberDefinition, List<IQualifierDeclaration>>();
    Set<TypeDefinition> genericBeans = new HashSet<TypeDefinition>();
    Set<IPath> involvedResources = new HashSet<IPath>();

    public GenericConfiguration(String genericTypeName) {
        this.genericTypeName = genericTypeName;
    }

    public void setGenericTypeDefinition(AnnotationDefinition genericType, GenericBeanDefinitionContext context) {
        this.genericType = genericType;
        AnnotationDeclaration g = genericType.getAnnotation(context.getVersion().getGenericTypeAnnotationTypeName());
        Object o = g.getMemberValue(null);
        if (o != null) {
            EclipseJavaUtil.resolveType((IType)genericType.getType(), (String)o.toString());
            try {
                this.configType = context.getRootContext().getProject().getTypeFactory().getParametedType((IMember)genericType.getType(), "Q" + o.toString() + ";");
            }
            catch (JavaModelException e) {
                CDISeamSolderCorePlugin.getDefault().logError(e);
            }
        }
    }

    public void clear(IPath path) {
        this.involvedResources.remove(path);
    }

    public void clear(String typeName) {
        Iterator<AbstractMemberDefinition> it = this.genericConfigurationPoints.keySet().iterator();
        while (it.hasNext()) {
            if (!typeName.equals(it.next().getTypeDefinition().getQualifiedName())) continue;
            it.remove();
        }
        Iterator<TypeDefinition> it2 = this.genericBeans.iterator();
        while (it2.hasNext()) {
            if (!typeName.equals(it2.next().getTypeDefinition().getQualifiedName())) continue;
            it2.remove();
        }
    }

    public Map<AbstractMemberDefinition, List<IQualifierDeclaration>> getGenericConfigurationPoints() {
        return this.genericConfigurationPoints;
    }

    public String getGenericTypeName() {
        return this.genericTypeName;
    }

    public AnnotationDefinition getGenericTypeDefinition() {
        return this.genericType;
    }

    public IParametedType getConfigType() {
        return this.configType;
    }

    public Set<TypeDefinition> getGenericBeans() {
        return this.genericBeans;
    }

    public Set<IPath> getInvolvedTypes() {
        return this.involvedResources;
    }
}

