/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.model;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.jboss.ide.eclipse.freemarker.model.AbstractDirective;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.model.MacroEndDirective;

public class MacroDirective
extends AbstractDirective
implements Comparable<MacroDirective> {
    private MacroEndDirective endDirective;
    private String name;
    private Item[] relatedItems;
    private String[] attributes;
    private static final char[] descriptorTokens = new char[]{'/', '#', '@', '<', '>'};

    public MacroDirective(ItemSet itemSet) {
        super(itemSet);
    }

    public MacroDirective(ItemSet itemSet, String contents) {
        super(itemSet);
        this.contents = contents;
    }

    @Override
    protected void init(ITypedRegion region, ISourceViewer viewer, IResource resource) throws Exception {
    }

    @Override
    public boolean isStartItem() {
        return true;
    }

    @Override
    public void relateItem(Item directive) {
        if (directive instanceof MacroEndDirective) {
            this.endDirective = (MacroEndDirective)directive;
        }
    }

    @Override
    public boolean relatesToItem(Item directive) {
        return directive instanceof MacroEndDirective;
    }

    @Override
    public boolean isNestable() {
        return true;
    }

    public MacroEndDirective getEndDirective() {
        return this.endDirective;
    }

    @Override
    public Item[] getRelatedItems() {
        if (this.relatedItems == null) {
            ArrayList<MacroEndDirective> l = new ArrayList<MacroEndDirective>();
            if (this.getEndDirective() != null) {
                l.add(this.getEndDirective());
            }
            this.relatedItems = l.toArray(new Item[l.size()]);
        }
        return this.relatedItems;
    }

    @Override
    public String getTreeImage() {
        return "macro.png";
    }

    @Override
    public String getTreeDisplay() {
        return this.getSplitValue(1);
    }

    public String[] getAttributes() {
        if (this.attributes == null) {
            ArrayList<String> l = new ArrayList<String>();
            String[] contents = this.splitContents();
            int i = 2;
            while (i < contents.length) {
                String att = contents[i];
                int index = att.indexOf(61);
                if (index < 0) {
                    if ((att = att.trim()).length() > 0) {
                        switch (att.charAt(att.length() - 1)) {
                            case '>': 
                            case ']': {
                                att = att.substring(0, att.length() - 1);
                                break;
                            }
                        }
                    }
                    l.add(att);
                    ++i;
                    continue;
                }
                i += 2;
            }
            this.attributes = l.toArray(new String[l.size()]);
        }
        return this.attributes;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.getSplitValue(1);
        }
        return this.name;
    }

    @Override
    public Item getEndItem() {
        return this.endDirective;
    }

    @Override
    public char[] getDescriptors() {
        return descriptorTokens;
    }

    @Override
    public int compareTo(MacroDirective arg0) {
        return MacroDirective.nullToEmpty(this.getName()).compareTo(MacroDirective.nullToEmpty(arg0.getName()));
    }

    private static String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    @Override
    public void addToContext(Map<String, Class<?>> context) {
        int i = 0;
        while (i < this.getAttributes().length) {
            if (context.get(this.getAttributes()[i]) == null) {
                context.put(this.getAttributes()[i], Object.class);
            }
            ++i;
        }
    }

    @Override
    public void removeFromContext(Map<String, Class<?>> context) {
        int i = 0;
        while (i < this.getAttributes().length) {
            Class<?> obj = context.get(this.getAttributes()[i]);
            if (obj != null && obj.equals(Object.class)) {
                context.remove(this.getAttributes()[i]);
            }
            ++i;
        }
    }
}

