/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor.partitions;

import java.util.Stack;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;

public class InterpolationRule
extends SingleLineRule {
    public InterpolationRule(char startChar, IToken token) {
        super("" + startChar + '{', String.valueOf('}'), token);
    }

    protected boolean endSequenceDetected(ICharacterScanner scanner) {
        int c;
        Stack<Character> keyStack = new Stack<Character>();
        int charsRead = 0;
        while ((c = scanner.read()) != -1) {
            ++charsRead;
            char cCheck = (char)c;
            if (c == 123) {
                if (keyStack.size() != 0) continue;
                break;
            }
            if (c == 34) {
                if (keyStack.size() > 0 && ((Character)keyStack.peek()).charValue() == '\"') {
                    keyStack.pop();
                    continue;
                }
                keyStack.push(Character.valueOf(cCheck));
                continue;
            }
            if (c == 40) {
                if (keyStack.size() > 0 && ((Character)keyStack.peek()).charValue() == '\"') continue;
                keyStack.push(Character.valueOf(cCheck));
                continue;
            }
            if (c == 41) {
                if (keyStack.size() > 0 && ((Character)keyStack.peek()).charValue() == '\"' || keyStack.size() <= 0 || ((Character)keyStack.peek()).charValue() != '(') continue;
                keyStack.pop();
                continue;
            }
            if (c == this.fEscapeCharacter) {
                scanner.read();
                ++charsRead;
                continue;
            }
            if (c == 125) {
                if (keyStack.size() != 0) continue;
                return true;
            }
            if (c == 10) break;
        }
        if (this.fBreaksOnEOF) {
            return true;
        }
        int i = 0;
        while (i < charsRead) {
            scanner.unread();
            ++i;
        }
        return false;
    }
}

