/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import freemarker.core.ParseException;
import freemarker.template.Template;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.jboss.ide.eclipse.freemarker.Plugin;
import org.jboss.ide.eclipse.freemarker.configuration.ConfigurationManager;
import org.jboss.ide.eclipse.freemarker.editor.Configuration;
import org.jboss.ide.eclipse.freemarker.editor.DocumentProvider;
import org.jboss.ide.eclipse.freemarker.editor.ReconcilingStrategy;
import org.jboss.ide.eclipse.freemarker.lang.ParserUtils;
import org.jboss.ide.eclipse.freemarker.model.Item;
import org.jboss.ide.eclipse.freemarker.model.ItemSet;
import org.jboss.ide.eclipse.freemarker.outline.OutlinePage;
import org.jboss.ide.eclipse.freemarker.preferences.Preferences;
import org.jboss.ide.eclipse.freemarker.target.TargetLanguageSupport;
import org.jboss.ide.eclipse.freemarker.target.TargetLanguages;

public class Editor
extends TextEditor
implements KeyListener,
MouseListener {
    private OutlinePage fOutlinePage;
    private Configuration configuration = new Configuration(this.getPreferenceStore(), this);
    private ItemSet itemSet;
    private Item selectedItem;
    private Item[] relatedItems;
    private static final char[] VALIDATION_TOKENS = new char[]{'\"', '[', ']', ',', '.', '\n', '4'};
    private boolean readOnly = false;
    private boolean mouseDown = false;
    private boolean ctrlDown = false;
    private boolean shiftDown = false;
    protected static final char[] BRACKETS = new char[]{'{', '}', '(', ')', '[', ']', '<', '>'};
    private MatchingCharacterPainter matchingCharacterPainter;
    public static Validator VALIDATOR;
    private freemarker.template.Configuration fmConfiguration;
    private TargetLanguageSupport targetLanguageSupport;

    public Editor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
        this.setDocumentProvider((IDocumentProvider)new DocumentProvider());
    }

    public void dispose() {
        ConfigurationManager.getInstance(this.getProject()).reload();
        super.dispose();
        if (this.matchingCharacterPainter != null) {
            this.matchingCharacterPainter.dispose();
        }
    }

    public Object getAdapter(Class aClass) {
        Object adapter;
        if (aClass.equals(IContentOutlinePage.class)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new OutlinePage(this);
                if (this.getEditorInput() != null) {
                    this.fOutlinePage.setInput(this.getEditorInput());
                }
            }
            adapter = this.fOutlinePage;
        } else {
            adapter = super.getAdapter(aClass);
        }
        return adapter;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getSourceViewer().getTextWidget().addKeyListener((KeyListener)this);
        this.getSourceViewer().getTextWidget().addMouseListener((MouseListener)this);
    }

    protected void createActions() {
        super.createActions();
        ContentAssistAction action = new ContentAssistAction(Plugin.getDefault().getResourceBundle(), "FreemarkerEditor.ContentAssist", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("FreemarkerEditor.ContentAssist", (IAction)action);
        action.setEnabled(true);
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
        if (!this.mouseDown) {
            int offset = this.getCaretOffset();
            Item item = this.getItemSet().getSelectedItem(offset);
            if (item == null && offset > 0) {
                item = this.getItemSet().getSelectedItem(offset - 1);
            }
            if (Preferences.getInstance().getBoolean(Preferences.PreferenceKey.HIGHLIGHT_RELATED_ITEMS)) {
                if (item != null && item.getRelatedItems() != null && item.getRelatedItems().length > 0) {
                    this.highlightRelatedRegions(item.getRelatedItems(), item);
                } else {
                    this.highlightRelatedRegions(null, item);
                }
            }
            if (item == null) {
                item = this.getItemSet().getContextItem(this.getCaretOffset());
            }
            if (this.fOutlinePage != null) {
                this.fOutlinePage.update(item);
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.mouseDown = true;
    }

    public void mouseUp(MouseEvent e) {
        this.mouseDown = false;
        this.handleCursorPositionChanged();
    }

    public void select(Item item) {
        this.selectAndReveal(item.getRegion().getOffset(), item.getRegion().getLength());
    }

    public IDocument getDocument() {
        ISourceViewer viewer = this.getSourceViewer();
        if (viewer != null) {
            return viewer.getDocument();
        }
        return null;
    }

    public ITextViewer getTextViewer() {
        return this.getSourceViewer();
    }

    public void addProblemMarker(String aMessage, int aLine) {
        IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
        try {
            HashMap<String, Object> attributes = new HashMap<String, Object>(5);
            attributes.put("severity", 2);
            attributes.put("lineNumber", aLine);
            attributes.put("message", aMessage);
            attributes.put("org.eclipse.core.resources.textmarker", aMessage);
            MarkerUtilities.createMarker((IResource)file, attributes, (String)"org.eclipse.core.resources.problemmarker");
        }
        catch (CoreException e) {
            Plugin.log(e);
        }
    }

    private synchronized void highlightRelatedRegions(Item[] items, Item selectedItem) {
        int i;
        if (items == null || items.length == 0) {
            if (this.relatedItems != null && this.relatedItems.length > 0) {
                i = 0;
                while (i < this.relatedItems.length) {
                    if (!(this.getDocument().getLength() < this.relatedItems[i].getRegion().getOffset() + this.relatedItems[i].getRegion().getLength() || this.selectedItem != null && this.relatedItems[i].equals(this.selectedItem))) {
                        this.resetRange(this.relatedItems[i].getRegion());
                    }
                    ++i;
                }
            }
            this.relatedItems = null;
        }
        if (this.relatedItems != null) {
            i = 0;
            while (i < this.relatedItems.length) {
                if (!(this.getDocument().getLength() < this.relatedItems[i].getRegion().getOffset() + this.relatedItems[i].getRegion().getLength() || this.selectedItem != null && this.relatedItems[i].equals(this.selectedItem))) {
                    this.resetRange(this.relatedItems[i].getRegion());
                }
                ++i;
            }
        }
        if (items != null && items.length > 0) {
            i = 0;
            while (i < items.length) {
                if (this.getDocument().getLength() >= items[i].getRegion().getOffset() + items[i].getRegion().getLength() && !items[i].equals(selectedItem)) {
                    ITypedRegion region = items[i].getRegion();
                    this.getSourceViewer().getTextWidget().setStyleRange(new StyleRange(region.getOffset(), region.getLength(), null, Preferences.getInstance().getColor(Preferences.PreferenceKey.COLOR_RELATED_ITEM)));
                }
                ++i;
            }
        }
        this.relatedItems = items;
        this.selectedItem = selectedItem;
    }

    private void resetRange(ITypedRegion region) {
        if (this.getSourceViewer() instanceof ITextViewerExtension2) {
            ((ITextViewerExtension2)this.getSourceViewer()).invalidateTextPresentation(region.getOffset(), region.getLength());
        } else {
            this.getSourceViewer().invalidateTextPresentation();
        }
    }

    public Item getSelectedItem(boolean allowFudge) {
        int caretOffset = this.getCaretOffset();
        Item item = this.getItemSet().getSelectedItem(this.getCaretOffset());
        if (item == null && caretOffset > 0) {
            item = this.getItemSet().getSelectedItem(caretOffset - 1);
        }
        return item;
    }

    public Item getSelectedItem() {
        return this.getItemSet().getSelectedItem(this.getCaretOffset());
    }

    public int getCaretOffset() {
        return this.getSourceViewer().getTextWidget().getCaretOffset();
    }

    public ItemSet getItemSet() {
        if (this.itemSet == null) {
            this.itemSet = this.createItemSet(Collections.<ITypedRegion>emptyList());
        }
        return this.itemSet;
    }

    public ItemSet createItemSet(List<ITypedRegion> regions) {
        IFile resource = null;
        if (this.getEditorInput() instanceof IFileEditorInput) {
            resource = ((IFileEditorInput)this.getEditorInput()).getFile();
        }
        return new ItemSet(this.getSourceViewer(), regions, (IResource)resource);
    }

    public OutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }

    public void keyPressed(KeyEvent e) {
        if (e.keyCode == 262144) {
            this.ctrlDown = true;
        }
        if (e.keyCode == 131072) {
            this.shiftDown = true;
        }
        if (e.keyCode == 93) {
            try {
                char c = this.getDocument().getChar(this.getCaretOffset());
                if (c == ']') {
                    this.getDocument().replace(this.getCaretOffset(), 1, "");
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if (e.keyCode == 125) {
            try {
                char c = this.getDocument().getChar(this.getCaretOffset());
                if (c == '}') {
                    this.getDocument().replace(this.getCaretOffset(), 1, "");
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void keyReleased(KeyEvent e) {
        int offset;
        if (e.keyCode == 262144) {
            this.ctrlDown = false;
        } else if (e.keyCode == 131072) {
            this.shiftDown = false;
        }
        try {
            char c;
            IDocument document = this.getSourceViewer().getDocument();
            if (this.shiftDown && (e.keyCode == 51 || e.keyCode == 50)) {
                offset = this.getCaretOffset();
                c = document.getChar(offset - 2);
                if (c == '[' || c == '<') {
                    char endChar = ParserUtils.getMatchingRightBracket(c);
                    if (document.getLength() > offset) {
                        if (offset > 0) {
                            int i = offset + 1;
                            while (i < document.getLength()) {
                                char c2 = document.getChar(i);
                                if (c2 == endChar) {
                                    return;
                                }
                                if (c2 == '\n') break;
                                ++i;
                            }
                            document.replace(offset, 0, String.valueOf(endChar));
                        }
                    } else {
                        document.replace(offset, 0, String.valueOf(endChar));
                    }
                }
            } else if (this.shiftDown && e.keyCode == 123 && (c = document.getChar((offset = this.getCaretOffset()) - 2)) == '$') {
                if (document.getLength() > offset) {
                    if (offset > 0) {
                        int i = offset + 1;
                        while (i < document.getLength()) {
                            char c2 = document.getChar(i);
                            if (c2 == '}') {
                                return;
                            }
                            if (c2 == '\n') break;
                            ++i;
                        }
                        document.replace(offset, 0, String.valueOf('}'));
                    }
                } else {
                    document.replace(offset, 0, String.valueOf('}'));
                }
            }
        }
        catch (BadLocationException badLocationException) {}
        boolean stale = false;
        if (e.keyCode == 127 || e.keyCode == 8) {
            stale = true;
        } else if (this.getSelectedItem(true) != null) {
            stale = true;
        } else {
            char c = (char)e.keyCode;
            int j = 0;
            while (j < VALIDATION_TOKENS.length) {
                if (c == VALIDATION_TOKENS[j]) {
                    stale = true;
                    break;
                }
                ++j;
            }
            if (this.ctrlDown && (e.keyCode == 118 || e.keyCode == 120)) {
                stale = true;
            }
        }
        if (stale) {
            offset = this.getCaretOffset();
            Item item = this.getItemSet().getSelectedItem(offset);
            if (item == null && offset > 0) {
                item = this.getItemSet().getSelectedItem(offset - 1);
            }
            if (Preferences.getInstance().getBoolean(Preferences.PreferenceKey.HIGHLIGHT_RELATED_ITEMS)) {
                if (item != null && item.getRelatedItems() != null && item.getRelatedItems().length > 0) {
                    this.highlightRelatedRegions(item.getRelatedItems(), item);
                } else {
                    this.highlightRelatedRegions(null, item);
                }
            }
            this.validateContents();
        }
    }

    public synchronized void validateContents() {
        if (VALIDATOR == null) {
            VALIDATOR = new Validator(this);
            VALIDATOR.start();
        }
    }

    public IProject getProject() {
        return ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
    }

    public IFile getFile() {
        return this.getEditorInput() != null ? ((IFileEditorInput)this.getEditorInput()).getFile() : null;
    }

    protected void editorSaved() {
        super.editorSaved();
        this.validateContents();
    }

    public boolean isEditorInputReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void reconcileInstantly() {
        ReconcilingStrategy s = new ReconcilingStrategy(this);
        s.setDocument(this.getDocument());
        List<ITypedRegion> regions = s.parseRegions();
        this.reconcile(regions);
    }

    public void reconcile(List<ITypedRegion> regions) {
        final ItemSet newItemSet = this.createItemSet(regions);
        Runnable newItemSetTask = new Runnable(){

            @Override
            public void run() {
                Editor.this.itemSet = newItemSet;
                if (Editor.this.fOutlinePage != null) {
                    Editor.this.fOutlinePage.refresh();
                }
            }
        };
        if (Thread.currentThread() == Display.getDefault().getThread()) {
            newItemSetTask.run();
        } else {
            Display.getDefault().asyncExec(newItemSetTask);
        }
    }

    public TargetLanguageSupport getTargetLanguageSupport() {
        if (this.targetLanguageSupport == null) {
            this.targetLanguageSupport = TargetLanguages.findSupport(this.getEditorInput());
        }
        return this.targetLanguageSupport;
    }

    public class Validator
    extends Thread {
        Editor editor;

        public Validator(Editor editor2) {
            this.editor = editor2;
        }

        @Override
        public void run() {
            try {
                try {
                    if (Editor.this.getFile() != null) {
                        if (Editor.this.fmConfiguration == null) {
                            Editor.this.fmConfiguration = new freemarker.template.Configuration();
                            Editor.this.fmConfiguration.setTagSyntax(0);
                        }
                        Editor.this.getFile().deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        String pageContents = Editor.this.getDocument().get();
                        StringReader reader = new StringReader(pageContents);
                        new Template(Editor.this.getFile().getName(), (Reader)reader, Editor.this.fmConfiguration);
                        ((Reader)reader).close();
                    }
                }
                catch (ParseException e) {
                    if (e.getMessage() != null) {
                        String errorStr = e.getMessage();
                        int errorLine = 0;
                        try {
                            int index;
                            errorLine = e.getLineNumber();
                            if (errorLine == 0 && (index = e.getMessage().indexOf("line: ")) > 0) {
                                int index2 = e.getMessage().indexOf(" ", index + 6);
                                int index3 = e.getMessage().indexOf(",", index + 6);
                                if (index3 < index2 && index3 > 0) {
                                    index2 = index3;
                                }
                                String s = e.getMessage().substring(index + 6, index2);
                                try {
                                    errorLine = Integer.parseInt(s);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            errorLine = 0;
                        }
                        this.editor.addProblemMarker(errorStr, errorLine);
                    }
                    VALIDATOR = null;
                }
                catch (Exception e) {
                    Plugin.log(e);
                    VALIDATOR = null;
                }
            }
            finally {
                VALIDATOR = null;
            }
        }
    }
}

