/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.freemarker.editor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionScanner;
import org.jboss.ide.eclipse.freemarker.editor.partitions.PartitionType;
import org.jboss.ide.eclipse.freemarker.lang.LexicalConstants;
import org.jboss.ide.eclipse.freemarker.lang.ParserUtils;
import org.jboss.ide.eclipse.freemarker.lang.SyntaxMode;

public class DocumentProvider
extends FileDocumentProvider {
    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document = super.createDocument(element);
        if (document != null) {
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new PartitionScanner(), PartitionType.PARTITION_TYPES);
            partitioner.connect(document);
            document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        }
        return document;
    }

    public static SyntaxMode findMode(IDocument document) {
        int docLength = document.getLength();
        if (docLength >= LexicalConstants.SQUARE_SYNTAX_MARKER.length()) {
            try {
                int i = 0;
                while (i < docLength && ParserUtils.isWhitespace(document.getChar(i))) {
                    ++i;
                }
                while (i < docLength) {
                    char ch = document.getChar(i);
                    if (ch != LexicalConstants.SQUARE_SYNTAX_MARKER.charAt(i)) {
                        return SyntaxMode.ANGLE;
                    }
                    ++i;
                }
                return SyntaxMode.SQUARE;
            }
            catch (BadLocationException badLocationException) {
                return SyntaxMode.getDefault();
            }
        }
        return SyntaxMode.getDefault();
    }
}

