/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.jboss.tools.ws.creation.core.data.ServiceModel;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.wizards.JBossWSAnnotatedClassWizard;
import org.jboss.tools.ws.ui.wizards.JBossWSGenerateWizardValidator;

public class JBossWSAnnotatedClassWizardPage
extends WizardPage {
    private JBossWSAnnotatedClassWizard wizard;
    private Combo projects;
    private boolean bHasChanged = false;
    private Text packageName;
    private Text className;
    private Text name;
    private Button updateWebXML;
    private Button btnPackageBrowse;
    private Button btnServiceClassBrowse;

    protected JBossWSAnnotatedClassWizardPage(String pageName) {
        super(pageName);
        this.setTitle(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_PageTitle);
        this.setDescription(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_PageDescription);
    }

    private String testDefaultServiceName(String currentName) {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        IStatus status = JBossWSGenerateWizardValidator.isWSNameValid();
        try {
            if (status.getSeverity() == 4 && !JavaEEProjectUtilities.isDynamicWebProject((IProject)this.wizard.getProject())) {
                return currentName;
            }
        }
        catch (NullPointerException nullPointerException) {
            return currentName;
        }
        String testName = currentName;
        int i = 1;
        while (status != null) {
            testName = String.valueOf(currentName) + i;
            this.wizard.setServiceName(testName);
            model = this.wizard.getServiceModel();
            JBossWSGenerateWizardValidator.setServiceModel(model);
            status = JBossWSGenerateWizardValidator.isWSNameValid();
            ++i;
        }
        return testName;
    }

    private String testDefaultClassName(String currentName) {
        ServiceModel model = this.wizard.getServiceModel();
        JBossWSGenerateWizardValidator.setServiceModel(model);
        if (this.wizard.getProject() == null) {
            return currentName;
        }
        boolean isDynamicWebProject = false;
        try {
            if (this.wizard.getProject().getNature("org.eclipse.wst.common.project.facet.core.nature") != null) {
                isDynamicWebProject = true;
            }
        }
        catch (CoreException coreException) {}
        if (!isDynamicWebProject) {
            return currentName;
        }
        String testName = currentName;
        IStatus status = JBossWSGenerateWizardValidator.isWSClassValid(testName, this.wizard.getProject());
        int i = 1;
        while (status != null && status.getSeverity() == 4) {
            testName = String.valueOf(currentName) + i;
            this.wizard.setClassName(testName);
            model = this.wizard.getServiceModel();
            JBossWSGenerateWizardValidator.setServiceModel(model);
            status = JBossWSGenerateWizardValidator.isWSClassValid(testName, this.wizard.getProject());
            ++i;
        }
        return testName;
    }

    private void updateDefaultValues() {
        String testName = null;
        if (this.className != null && this.className.getText().trim().length() == 0) {
            testName = this.testDefaultClassName(JBossWSAnnotatedClassWizard.WSCLASSDEFAULT);
            this.className.setText(testName);
            this.wizard.setClassName(testName);
        }
        if (this.name != null && this.name.getText().trim().length() == 0) {
            testName = this.testDefaultServiceName(JBossWSAnnotatedClassWizard.WSNAMEDEFAULT);
            this.name.setText(testName);
            this.wizard.setServiceName(testName);
        }
        this.wizard.setAppClassName("");
        if (this.packageName != null && this.packageName.getText().trim().length() == 0) {
            this.packageName.setText(JBossWSAnnotatedClassWizard.PACKAGEDEFAULT);
            this.wizard.setPackageName(this.packageName.getText());
        }
    }

    private void createProjectGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Project_Group);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)gd);
        this.projects = new Combo((Composite)group, 2052);
        this.projects.setToolTipText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Projects_Combo_Tooltip);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.projects.setLayoutData((Object)gd);
        this.refreshProjectList(this.wizard.getServiceModel().getWebProjectName());
        this.projects.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSAnnotatedClassWizardPage.this.wizard.setProject(JBossWSAnnotatedClassWizardPage.this.projects.getText());
                JBossWSAnnotatedClassWizardPage.this.setWebXMLSelectionValueBasedOnProjectFacet();
                JBossWSAnnotatedClassWizardPage.this.bHasChanged = true;
                JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createApplicationGroup(Composite parent) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = -5;
        gd.horizontalAlignment = 4;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Web_Service_Group);
        group.setLayoutData((Object)gd);
        new Label((Composite)group, 0).setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Service_Name_field);
        this.name = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.name.setLayoutData((Object)gd);
        this.name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSAnnotatedClassWizardPage.this.wizard.setServiceName(JBossWSAnnotatedClassWizardPage.this.name.getText());
                JBossWSAnnotatedClassWizardPage.this.bHasChanged = true;
                JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
            }
        });
        this.updateWebXML = new Button((Composite)group, 32);
        this.updateWebXML.setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Update_Web_xml_checkbox);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.updateWebXML.setLayoutData((Object)gd);
        this.updateWebXML.setSelection(this.wizard.getUpdateWebXML());
        this.updateWebXML.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JBossWSAnnotatedClassWizardPage.this.wizard.setUpdateWebXML(JBossWSAnnotatedClassWizardPage.this.updateWebXML.getSelection());
                JBossWSAnnotatedClassWizardPage.this.name.setEnabled(JBossWSAnnotatedClassWizardPage.this.wizard.getUpdateWebXML());
                JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setWebXMLSelectionValueBasedOnProjectFacet();
    }

    private void createImplementationGroup(Composite parent) {
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.horizontalIndent = -5;
        gd.horizontalAlignment = 4;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Service_implementation_group);
        group.setLayoutData((Object)gd);
        new Label((Composite)group, 0).setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_package_name_field);
        this.packageName = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.packageName.setLayoutData((Object)gd);
        this.packageName.setText(this.wizard.getPackageName());
        this.packageName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSAnnotatedClassWizardPage.this.wizard.setPackageName(JBossWSAnnotatedClassWizardPage.this.packageName.getText());
                JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
            }
        });
        this.btnPackageBrowse = new Button((Composite)group, 8);
        this.btnPackageBrowse.setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_package_browse_btn);
        this.btnPackageBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JBossWSAnnotatedClassWizardPage.this.wizard.getProject() == null) {
                    return;
                }
                IJavaProject project = JavaCore.create((IProject)JBossWSAnnotatedClassWizardPage.this.wizard.getProject());
                if (project == null) {
                    return;
                }
                try {
                    SelectionDialog dialog = JavaUI.createPackageDialog((Shell)JBossWSAnnotatedClassWizardPage.this.getShell(), (IJavaProject)project, (int)32);
                    if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length == 1) {
                        String fqClassName = ((PackageFragment)dialog.getResult()[0]).getElementName();
                        JBossWSAnnotatedClassWizardPage.this.packageName.setText(fqClassName);
                        JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)group, 0).setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Service_class_field);
        this.className = new Text((Composite)group, 2048);
        gd = new GridData(768);
        this.className.setLayoutData((Object)gd);
        this.className.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JBossWSAnnotatedClassWizardPage.this.wizard.setClassName(JBossWSAnnotatedClassWizardPage.this.className.getText());
                JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
            }
        });
        this.btnServiceClassBrowse = new Button((Composite)group, 8);
        this.btnServiceClassBrowse.setText(JBossWSUIMessages.JBossWSAnnotatedClassWizardPage_Service_class_Browse_btn);
        this.btnServiceClassBrowse.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (JBossWSAnnotatedClassWizardPage.this.wizard.getProject() == null) {
                    return;
                }
                try {
                    SelectionDialog dialog = JavaUI.createTypeDialog((Shell)JBossWSAnnotatedClassWizardPage.this.getShell(), null, (IProject)JBossWSAnnotatedClassWizardPage.this.wizard.getProject(), (int)2, (boolean)false);
                    if (dialog.open() == 0 && dialog.getResult() != null && dialog.getResult().length == 1) {
                        String fqClassName = ((IType)dialog.getResult()[0]).getElementName();
                        JBossWSAnnotatedClassWizardPage.this.className.setText(fqClassName);
                        JBossWSAnnotatedClassWizardPage.this.setPageComplete(JBossWSAnnotatedClassWizardPage.this.isPageComplete());
                    }
                }
                catch (JavaModelException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = this.createDialogArea(parent);
        this.wizard = (JBossWSAnnotatedClassWizard)this.getWizard();
        this.createProjectGroup(composite);
        this.createApplicationGroup(composite);
        this.createImplementationGroup(composite);
        this.updateDefaultValues();
        this.setControl((Control)composite);
    }

    private void refreshProjectList(String projectName) {
        String[] projectNames = this.getProjects();
        boolean foundInitialProject = false;
        this.projects.removeAll();
        int i = 0;
        while (i < projectNames.length) {
            this.projects.add(projectNames[i]);
            if (projectNames[i].equals(projectName)) {
                foundInitialProject = true;
            }
            ++i;
        }
        if (foundInitialProject) {
            this.projects.setText(projectName);
        }
    }

    public IWizardPage getNextPage() {
        return super.getNextPage();
    }

    private Composite createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.verticalSpacing = 4;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        return composite;
    }

    public boolean isPageComplete() {
        return this.validate();
    }

    private void setWebXMLSelectionValueBasedOnProjectFacet() {
        try {
            if (((JBossWSAnnotatedClassWizard)this.getWizard()).getProject() == null) {
                return;
            }
            IFacetedProject facetProject = ProjectFacetsManager.create((IProject)((JBossWSAnnotatedClassWizard)this.getWizard()).getProject());
            if (facetProject == null) {
                return;
            }
            IProjectFacetVersion version = facetProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET);
            if (version == null) {
                return;
            }
            Double versionDouble = Double.valueOf(version.getVersionString());
            if (versionDouble == 3.0 || versionDouble > 3.0) {
                this.updateWebXML.setSelection(false);
            } else if (versionDouble < 3.0) {
                this.updateWebXML.setSelection(true);
            }
        }
        catch (CoreException coreException) {
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private boolean validate() {
        IStatus status;
        ServiceModel model = this.wizard.getServiceModel();
        this.setMessage(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Description);
        this.setErrorMessage(null);
        JBossWSGenerateWizardValidator.setServiceModel(model);
        if (!this.projects.isDisposed() && this.projects.getText().length() > 0) {
            model.setWebProjectName(this.projects.getText());
        }
        if (((JBossWSAnnotatedClassWizard)this.getWizard()).getProject() == null) {
            this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NoProjectSelected);
            return false;
        }
        try {
            IFacetedProject facetProject = ProjectFacetsManager.create((IProject)((JBossWSAnnotatedClassWizard)this.getWizard()).getProject());
            if (facetProject == null || facetProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET) == null) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NotDynamicWebProject2);
                return false;
            }
        }
        catch (CoreException coreException) {
            this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NotDynamicWebProject2);
            return false;
        }
        IFile web = ((JBossWSAnnotatedClassWizard)this.getWizard()).getWebFile();
        if ((web == null || !web.exists()) && this.updateWebXML.getSelection()) {
            this.setMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NoWebXML, 2);
            return true;
        }
        try {
            if ("".equals(JBossWSCreationUtils.getJavaProjectSrcLocation((IProject)((JBossWSAnnotatedClassWizard)this.getWizard()).getProject()))) {
                this.setErrorMessage(JBossWSUIMessages.Error_JBossWS_GenerateWizard_NoSrcInProject);
                return false;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if ((status = JBossWSGenerateWizardValidator.isWSNameValid()) != null) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        IStatus classNameStatus = JBossWSGenerateWizardValidator.isWSClassValid(model.getCustomClassName(), this.wizard.getProject());
        if (classNameStatus != null) {
            if (classNameStatus.getSeverity() == 4) {
                this.setMessage(classNameStatus.getMessage(), 2);
                this.setErrorMessage(null);
                return true;
            }
            if (classNameStatus.getSeverity() == 2) {
                this.setMessage(classNameStatus.getMessage(), 2);
                this.setErrorMessage(null);
                return true;
            }
        }
        this.setMessage(JBossWSUIMessages.JBossWS_GenerateWizard_GenerateWizardPage_Description);
        this.setErrorMessage(null);
        return true;
    }

    private String[] getProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> dynamicProjects = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            boolean isDynamicWebProject = JavaEEProjectUtilities.isDynamicWebProject((IProject)projects[i]);
            if (isDynamicWebProject) {
                dynamicProjects.add(projects[i].getName());
            }
            ++i;
        }
        return dynamicProjects.toArray(new String[dynamicProjects.size()]);
    }

    protected boolean hasChanged() {
        return this.bHasChanged;
    }
}

