/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.util.Iterator;
import java.util.Stack;
import org.jboss.tools.ws.ui.views.TestHistoryEntry;

public class TestHistory {
    private Stack<TestHistoryEntry> entries = new Stack();

    public Stack<TestHistoryEntry> getEntries() {
        return this.entries;
    }

    public TestHistoryEntry findEntryByURL(String urlStr) {
        for (TestHistoryEntry entry : this.entries) {
            if (!entry.getUrl().contentEquals(urlStr)) continue;
            return entry;
        }
        return null;
    }

    public void addEntry(TestHistoryEntry newEntry) {
        this.entries.push(newEntry);
    }

    public void replaceEntry(TestHistoryEntry oldEntry, TestHistoryEntry newEntry) {
        boolean found = this.entries.remove(oldEntry);
        if (found) {
            this.addEntry(newEntry);
        }
    }

    public String toString() {
        String result = "TestHistory [entries= \n";
        Iterator entryIter = this.entries.iterator();
        while (entryIter.hasNext()) {
            TestHistoryEntry entry = (TestHistoryEntry)entryIter.next();
            result = String.valueOf(result) + entry.toString();
            if (!entryIter.hasNext()) continue;
            result = String.valueOf(result) + '\n';
        }
        result = String.valueOf(result) + "]";
        return result;
    }
}

