/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.views;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.soap.MessageFactoryImpl;
import org.apache.axis.utils.XMLUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.dialogs.WSTesterURLInputsDialog;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;
import org.jboss.tools.ws.ui.utils.JAXRSTester;
import org.jboss.tools.ws.ui.utils.JAXWSTester2;
import org.jboss.tools.ws.ui.utils.ResultsXMLStorage;
import org.jboss.tools.ws.ui.utils.ResultsXMLStorageInput;
import org.jboss.tools.ws.ui.utils.SOAPDOMParser;
import org.jboss.tools.ws.ui.utils.SchemaUtils;
import org.jboss.tools.ws.ui.utils.TesterWSDLUtils;
import org.jboss.tools.ws.ui.utils.TreeParent;
import org.jboss.tools.ws.ui.utils.WSTestUtils;
import org.jboss.tools.ws.ui.views.DelimitedStringList;
import org.jboss.tools.ws.ui.views.TestHistory;
import org.jboss.tools.ws.ui.views.TestHistoryEntry;
import org.jboss.tools.ws.ui.views.UidPwdDialog;
import org.jboss.tools.ws.ui.views.WSDLBrowseDialog;
import org.jboss.tools.ws.ui.views.WSTestStatus;
import org.jboss.wise.ui.internal.util.WiseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXRSWSTestView2
extends ViewPart {
    private static final String PAGE1_KEY = "page1";
    private static final String PAGE2_KEY = "page2";
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String XML_EDITOR_ID = "org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart";
    private static final String DELETE = "DELETE";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String GET = "GET";
    private static final String OPTIONS = "OPTIONS";
    private static final String JAX_WS = "JAX-WS";
    private static final String JAX_RS = "JAX-RS";
    private static final String EMPTY_STRING = "";
    private static final String RESULT_HEADER_DELIMITER = "%";
    private static final String HTTPS_STRING = "https";
    private static final String[] TREE_COLUMNS = new String[]{"name", "value"};
    public static final String ID = "org.jboss.tools.ws.ui.tester.views.TestWSView";
    private Text resultsText;
    private Browser resultsBrowser;
    private Combo urlCombo;
    private DelimitedStringList dlsList;
    private Combo methodCombo;
    private Text bodyText;
    private org.eclipse.swt.widgets.List resultHeadersList;
    private TreeViewer treeRequestBody;
    private ScrolledPageBook requestPageBook;
    private ShowInTreeAction treeAction;
    private ShowRawRequestAction rawRequestAction;
    private DelimitedStringList parmsList;
    private SOAPEnvelope envelope;
    private SOAPBody soapbody;
    private MenuItem openInXMLEditorAction;
    private MenuItem openResponseTagInXMLEditor;
    private Menu resultsTextMenu;
    private MenuItem copyMenuAction;
    private Menu resultsHeaderMenu;
    private MenuItem copyResultHeaderMenuAction;
    private String[] serviceNSMessage = null;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private ImageRegistry mImageRegistry;
    private static final String IMG_DESC_WSDL = "icons/obj16/wsdl.gif";
    private static final String IMG_DESC_START = "icons/obj16/run.gif";
    private static final String IMG_DESC_SHOWRAW = "icons/obj16/binary.gif";
    private static final String IMG_DESC_SHOWTREE = "icons/obj16/hierarchicalLayout.gif";
    private static final String IMG_DESC_SHOWWEB = "icons/obj16/web.gif";
    private static final String IMG_DESC_SHOWEDITOR = "icons/obj16/properties.gif";
    private static final String IMG_DESC_SAVE = "icons/obj16/save_edit.gif";
    private ToolItem openWSDLToolItem;
    private ToolItem startToolItem;
    private ScrolledPageBook pageBook;
    private ShowRawAction rawAction;
    private ShowInBrowserAction browserAction;
    private TestHistory history = new TestHistory();
    private TestHistoryEntry currentHistoryEntry = null;
    private Button useBasicAuthCB;
    private boolean restoringFromHistoryEntry = false;

    public void setWSDLURL(String url) {
        this.urlCombo.setText(url);
        this.methodCombo.setText(JAX_WS);
        this.setControlsForWSType(JAX_WS);
        this.setControlsForMethodType(this.methodCombo.getText());
        this.setControlsForSelectedURL();
    }

    public void setJAXRS(String url, String method) {
        this.urlCombo.setText(url);
        this.bodyText.setText(EMPTY_STRING);
        this.treeRequestBody.setInput(null);
        this.resultsText.setText(EMPTY_STRING);
        this.resultsBrowser.setText(EMPTY_STRING);
        String uCaseMethod = method.toUpperCase();
        if (uCaseMethod.equalsIgnoreCase(GET)) {
            this.methodCombo.setText(GET);
        } else if (uCaseMethod.equalsIgnoreCase(POST)) {
            this.methodCombo.setText(POST);
        } else if (uCaseMethod.equalsIgnoreCase(PUT)) {
            this.methodCombo.setText(PUT);
        } else if (uCaseMethod.equalsIgnoreCase(DELETE)) {
            this.methodCombo.setText(DELETE);
        } else if (uCaseMethod.equalsIgnoreCase(OPTIONS)) {
            this.methodCombo.setText(OPTIONS);
        }
        this.getCurrentHistoryEntry().setMethod(this.methodCombo.getText());
        this.setControlsForWSType(JAX_RS);
        this.setControlsForMethodType(this.methodCombo.getText());
        this.setControlsForSelectedURL();
    }

    private void getImages() {
        this.mImageRegistry = new ImageRegistry();
        this.mImageRegistry.put(IMG_DESC_WSDL, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_WSDL)));
        this.mImageRegistry.put(IMG_DESC_START, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_START)));
        this.mImageRegistry.put(IMG_DESC_SHOWRAW, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_SHOWRAW)));
        this.mImageRegistry.put(IMG_DESC_SHOWWEB, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_SHOWWEB)));
        this.mImageRegistry.put(IMG_DESC_SHOWEDITOR, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_SHOWEDITOR)));
        this.mImageRegistry.put(IMG_DESC_SAVE, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_SAVE)));
        this.mImageRegistry.put(IMG_DESC_SHOWTREE, ImageDescriptor.createFromURL((URL)JBossWSUIPlugin.getDefault().getBundle().getEntry(IMG_DESC_SHOWTREE)));
    }

    private void createRequestToolbar(ExpandableComposite parent) {
        this.rawRequestAction = new ShowRawRequestAction();
        this.rawRequestAction.setChecked(true);
        this.treeAction = new ShowInTreeAction();
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)parent);
        toolBarManager.add((IAction)this.rawRequestAction);
        toolBarManager.add((IAction)this.treeAction);
        toolBarManager.update(true);
        parent.setTextClient((Control)toolbar);
    }

    private void createResponseToolbar(ExpandableComposite parent) {
        this.rawAction = new ShowRawAction();
        this.rawAction.setChecked(true);
        this.browserAction = new ShowInBrowserAction();
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)parent);
        toolBarManager.add((IAction)new FileSaveAction());
        toolBarManager.add((IAction)new OpenInXMLEditorAction());
        toolBarManager.add((IAction)this.rawAction);
        toolBarManager.add((IAction)this.browserAction);
        toolBarManager.update(true);
        parent.setTextClient((Control)toolbar);
    }

    private String getCurrentTestType() {
        if (this.methodCombo.getText().equalsIgnoreCase(JAX_WS)) {
            return JAX_WS;
        }
        return JAX_RS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getWSDLSpecifics(String opName) {
        block27: {
            String opNameInBody;
            String soapIn;
            boolean isSOAP12;
            String actionURL;
            block26: {
                int rtnCode;
                String opNameInBody2;
                if (opName != null && (opNameInBody2 = this.getOpNameFromRequestBody()) != null) {
                    boolean isRequestSOAP12 = TesterWSDLUtils.isRequestBodySOAP12(this.getCurrentHistoryEntry().getBody());
                    String urlText = this.urlCombo.getText();
                    if (urlText != null) {
                        try {
                            URL tempURL = new URL(urlText);
                            Definition wsdlDef = TesterWSDLUtils.readWSDLURL(tempURL);
                            Map bindings = wsdlDef.getAllBindings();
                            for (Map.Entry mapEntry : bindings.entrySet()) {
                                Binding binding = (Binding)mapEntry.getValue();
                                for (BindingOperation bindOp : binding.getBindingOperations()) {
                                    String tempOpName = opNameInBody2;
                                    if (tempOpName.indexOf(58) > -1) {
                                        tempOpName = tempOpName.substring(tempOpName.indexOf(58) + 1);
                                    }
                                    if (!bindOp.getName().contentEquals(opNameInBody2) && !bindOp.getName().contentEquals(tempOpName)) continue;
                                    for (ExtensibilityElement extEl : bindOp.getExtensibilityElements()) {
                                        SOAPOperation soapOp;
                                        if (!extEl.getElementType().getLocalPart().contentEquals("operation")) continue;
                                        String actionURL2 = null;
                                        String[] nsArray = null;
                                        if (!isRequestSOAP12 && extEl instanceof SOAPOperation) {
                                            soapOp = (SOAPOperation)extEl;
                                            actionURL2 = soapOp.getSoapActionURI();
                                        } else if (isRequestSOAP12 && extEl instanceof SOAP12Operation) {
                                            soapOp = (SOAP12Operation)extEl;
                                            actionURL2 = soapOp.getSoapActionURI();
                                        }
                                        if (actionURL2 == null) continue;
                                        PortType portType = binding.getPortType();
                                        String ns = portType.getQName().getNamespaceURI();
                                        QName bindingQName = binding.getQName();
                                        Map services = wsdlDef.getAllServices();
                                        for (Map.Entry serviceEntry : services.entrySet()) {
                                            Service service = (Service)serviceEntry.getValue();
                                            for (Map.Entry portEntry : service.getPorts().entrySet()) {
                                                Port port = (Port)portEntry.getValue();
                                                if (!port.getBinding().getQName().equals(bindingQName)) continue;
                                                String serviceName = service.getQName().getLocalPart();
                                                String portName = port.getName();
                                                nsArray = new String[]{ns, serviceName, portName};
                                                if (actionURL2 != null) {
                                                    this.getCurrentHistoryEntry().setAction(actionURL2);
                                                }
                                                if (nsArray == null) continue;
                                                this.getCurrentHistoryEntry().setServiceNSMessage(nsArray);
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                        catch (WSDLException e) {
                            e.printStackTrace();
                        }
                    }
                }
                WSDLBrowseDialog wbDialog = new WSDLBrowseDialog(this.getSite().getShell());
                if (this.urlCombo.getText().length() > 0) {
                    wbDialog.setURLText(this.urlCombo.getText());
                }
                if (opName != null) {
                    wbDialog.setInitialOperationTextValue(opName);
                }
                if ((rtnCode = wbDialog.open()) != 0) {
                    return false;
                }
                this.getCurrentHistoryEntry().setServiceNSMessage(null);
                this.getCurrentHistoryEntry().setAction(EMPTY_STRING);
                this.getCurrentHistoryEntry().setWsdlDef(null);
                this.getCurrentHistoryEntry().setServiceName(null);
                this.getCurrentHistoryEntry().setPortName(null);
                this.getCurrentHistoryEntry().setBindingName(null);
                this.getCurrentHistoryEntry().setOperationName(null);
                this.serviceNSMessage = null;
                Definition wsdlDef = wbDialog.getWSDLDefinition();
                this.getCurrentHistoryEntry().setWsdlDef(wsdlDef);
                this.getCurrentHistoryEntry().setServiceName(wbDialog.getServiceTextValue());
                this.getCurrentHistoryEntry().setPortName(wbDialog.getPortTextValue());
                this.getCurrentHistoryEntry().setBindingName(wbDialog.getBindingValue());
                this.getCurrentHistoryEntry().setOperationName(wbDialog.getOperationTextValue());
                this.getCurrentHistoryEntry().setUrl(wbDialog.getWSDLText());
                this.urlCombo.setText(wbDialog.getWSDLText());
                String output = WiseUtil.getSampleSOAPInputMessageFromWISE((Definition)wsdlDef, (String)wbDialog.getServiceTextValue(), (String)wbDialog.getPortTextValue(), (String)wbDialog.getBindingValue(), (String)wbDialog.getOperationTextValue());
                String endpointURL = TesterWSDLUtils.getEndpointURL(wsdlDef, wbDialog.getServiceTextValue(), wbDialog.getPortTextValue(), wbDialog.getBindingValue(), wbDialog.getOperationTextValue());
                this.getCurrentHistoryEntry().setUrl(endpointURL);
                actionURL = TesterWSDLUtils.getActionURL(wsdlDef, wbDialog.getServiceTextValue(), wbDialog.getPortTextValue(), wbDialog.getBindingValue(), wbDialog.getOperationTextValue());
                this.getCurrentHistoryEntry().setAction(actionURL);
                this.serviceNSMessage = TesterWSDLUtils.getNSServiceNameAndMessageNameArray(wsdlDef, wbDialog.getServiceTextValue(), wbDialog.getPortTextValue(), wbDialog.getBindingValue(), wbDialog.getOperationTextValue());
                this.getCurrentHistoryEntry().setServiceNSMessage(this.serviceNSMessage);
                isSOAP12 = TesterWSDLUtils.isSOAP12(wsdlDef, wbDialog.getServiceTextValue(), wbDialog.getPortTextValue());
                this.getCurrentHistoryEntry().setSOAP12(isSOAP12);
                String headerText = SchemaUtils.getSampleSOAPMessageHeader(wsdlDef, wbDialog.getServiceTextValue(), wbDialog.getPortTextValue(), wbDialog.getBindingValue(), wbDialog.getOperationTextValue());
                soapIn = this.generateSampleSOAP(headerText, output, isSOAP12);
                if (opName == null) break block26;
                if (this.bodyText.getText().length() > 0) {
                    opNameInBody = this.getOpNameFromRequestBody();
                    if (opNameInBody == null) {
                        this.bodyText.setText(soapIn);
                        this.treeRequestBody.setInput((Object)soapIn);
                        this.getCurrentHistoryEntry().setBody(soapIn);
                        this.getCurrentHistoryEntry().setAction(actionURL);
                        break block27;
                    } else if (!opNameInBody.contentEquals(this.getCurrentHistoryEntry().getOperationName()) && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)JBossWSUIMessages.JAXRSWSTestView2_Title_Msg_May_Be_Out_of_Date, (String)JBossWSUIMessages.JAXRSWSTestView2_Text_Msg_May_Be_Out_of_Date)) {
                        this.bodyText.setText(soapIn);
                        this.treeRequestBody.setInput((Object)soapIn);
                        this.getCurrentHistoryEntry().setBody(soapIn);
                        this.getCurrentHistoryEntry().setAction(actionURL);
                    }
                }
                break block27;
            }
            if (this.bodyText.getText().length() > 0) {
                opNameInBody = this.getOpNameFromRequestBody();
                boolean isRequestSOAP12 = TesterWSDLUtils.isRequestBodySOAP12(this.getCurrentHistoryEntry().getBody());
                if (opNameInBody == null || isSOAP12 != isRequestSOAP12) {
                    this.bodyText.setText(soapIn);
                    this.treeRequestBody.setInput((Object)soapIn);
                    this.getCurrentHistoryEntry().setBody(soapIn);
                    this.getCurrentHistoryEntry().setAction(actionURL);
                } else if (!opNameInBody.contentEquals(this.getCurrentHistoryEntry().getOperationName()) && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)JBossWSUIMessages.JAXRSWSTestView2_Title_Msg_May_Be_Out_of_Date, (String)JBossWSUIMessages.JAXRSWSTestView2_Text_Msg_May_Be_Out_of_Date)) {
                    this.bodyText.setText(soapIn);
                    this.treeRequestBody.setInput((Object)soapIn);
                    this.getCurrentHistoryEntry().setBody(soapIn);
                    this.getCurrentHistoryEntry().setAction(actionURL);
                }
            }
        }
        this.setControlsForWSType(this.getCurrentTestType());
        this.setControlsForMethodType(this.methodCombo.getText());
        this.setControlsForSelectedURL();
        return true;
    }

    private void createURLAndToolbar() {
        this.urlCombo = new Combo(this.form.getBody(), 2052);
        GridData gdURL = new GridData(4, 0, true, false);
        this.urlCombo.setLayoutData((Object)gdURL);
        this.toolkit.adapt((Composite)this.urlCombo);
        this.urlCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (e.getSource().equals(JAXRSWSTestView2.this.urlCombo)) {
                    String newURL = JAXRSWSTestView2.this.urlCombo.getText();
                    String oldURL = null;
                    if (JAXRSWSTestView2.this.getCurrentHistoryEntry() != null && JAXRSWSTestView2.this.getCurrentHistoryEntry().getUrl() != null && JAXRSWSTestView2.this.getCurrentHistoryEntry().getUrl().trim().length() > 0) {
                        oldURL = JAXRSWSTestView2.this.getCurrentHistoryEntry().getUrl();
                    }
                    if (newURL != null && oldURL == null) {
                        JAXRSWSTestView2.this.setControlsForSelectedURL();
                        JAXRSWSTestView2.this.getCurrentHistoryEntry().setUrl(newURL);
                        JAXRSWSTestView2.this.getCurrentHistoryEntry().setAction(null);
                    }
                }
            }
        });
        this.urlCombo.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                JAXRSWSTestView2.this.setControlsForSelectedURL();
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setUrl(JAXRSWSTestView2.this.urlCombo.getText());
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setAction(null);
                if (e.keyCode == 13) {
                    JAXRSWSTestView2.this.handleTest(JAXRSWSTestView2.this.getCurrentTestType());
                }
            }
        });
        this.urlCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                String testURL = JAXRSWSTestView2.this.urlCombo.getText();
                TestHistoryEntry entry = JAXRSWSTestView2.this.history.findEntryByURL(testURL);
                if (entry != null) {
                    try {
                        JAXRSWSTestView2.this.currentHistoryEntry = (TestHistoryEntry)entry.clone();
                        JAXRSWSTestView2.this.setControlsForSelectedEntry(entry);
                    }
                    catch (CloneNotSupportedException e1) {
                        e1.printStackTrace();
                    }
                } else {
                    JAXRSWSTestView2.this.getCurrentHistoryEntry().setUrl(JAXRSWSTestView2.this.urlCombo.getText());
                    JAXRSWSTestView2.this.getCurrentHistoryEntry().setAction(null);
                    JAXRSWSTestView2.this.setControlsForSelectedURL();
                }
            }
        });
        Composite comp1 = this.toolkit.createComposite(this.form.getBody());
        comp1.setLayoutData((Object)new GridData(0x1000008, 0, false, false));
        comp1.setLayout((Layout)new FillLayout());
        CoolBar coolBar = new CoolBar(comp1, 0x800000);
        coolBar.setLocked(true);
        coolBar.setBackground(this.form.getBody().getBackground());
        CoolItem wsMethodCoolItem = new CoolItem(coolBar, 0x800008);
        this.methodCombo = new Combo((Composite)coolBar, 2056);
        this.methodCombo.setBackground(this.form.getBody().getBackground());
        String[] methods = new String[]{JAX_WS, GET, POST, PUT, DELETE, OPTIONS};
        this.methodCombo.setItems(methods);
        this.methodCombo.pack();
        Point size = this.methodCombo.computeSize(-1, -1);
        wsMethodCoolItem.setPreferredSize(wsMethodCoolItem.computeSize(size.x, size.y));
        wsMethodCoolItem.setControl((Control)this.methodCombo);
        this.methodCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setMethod(JAXRSWSTestView2.this.methodCombo.getText());
                JAXRSWSTestView2.this.setControlsForWSType(JAXRSWSTestView2.this.getCurrentTestType());
                JAXRSWSTestView2.this.setControlsForMethodType(JAXRSWSTestView2.this.methodCombo.getText());
                JAXRSWSTestView2.this.setControlsForSelectedURL();
            }
        });
        this.toolkit.adapt((Composite)this.methodCombo);
        CoolItem topCoolItem = new CoolItem(coolBar, 0x800000);
        ToolBar topToolBar = new ToolBar((Composite)coolBar, 0x800100);
        topToolBar.setBackground(this.form.getBody().getBackground());
        this.openWSDLToolItem = new ToolItem(topToolBar, 8);
        this.openWSDLToolItem.setImage(this.mImageRegistry.get(IMG_DESC_WSDL));
        this.openWSDLToolItem.setToolTipText(JBossWSUIMessages.JAXRSWSTestView2_GetFromWSDL_Tooltip);
        this.openWSDLToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JAXRSWSTestView2.this.getWSDLSpecifics(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.startToolItem = new ToolItem(topToolBar, 0x800008);
        this.startToolItem.setImage(this.mImageRegistry.get(IMG_DESC_START));
        this.startToolItem.setToolTipText(JBossWSUIMessages.JAXRSWSTestView2_Go_Tooltip);
        this.startToolItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JAXRSWSTestView2.this.handleTest(JAXRSWSTestView2.this.getCurrentTestType());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        topToolBar.pack();
        size = topToolBar.getSize();
        topCoolItem.setControl((Control)topToolBar);
        topCoolItem.setSize(topCoolItem.computeSize(size.x, size.y));
        this.toolkit.adapt((Composite)coolBar);
    }

    private void createRequestSide(SashForm sashForm) {
        Section section = this.toolkit.createSection((Composite)sashForm, 322);
        section.setText(JBossWSUIMessages.JAXRSWSTestView2_RequestDetails_Section);
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        sectionClient.setLayout((Layout)new GridLayout());
        sectionClient.setLayoutData((Object)new GridData());
        this.useBasicAuthCB = this.toolkit.createButton(sectionClient, JBossWSUIMessages.JAXRSWSTestView2_Checkbox_Basic_Authentication, 32);
        GridData gd10 = new GridData(4, 0, true, false);
        gd10.horizontalIndent = 3;
        this.useBasicAuthCB.setLayoutData((Object)gd10);
        ExpandableComposite ec = this.toolkit.createExpandableComposite(sectionClient, 276);
        ec.setText(JBossWSUIMessages.JAXRSWSTestView2_Headers_Section);
        this.dlsList = new DelimitedStringList((Composite)ec, 0, false, false);
        this.dlsList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setHeaders(JAXRSWSTestView2.this.dlsList.getSelection());
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setAction(null);
            }
        });
        ec.setClient((Control)this.dlsList);
        this.toolkit.adapt((Composite)this.dlsList);
        GridData gd2 = new GridData(4, 4, true, false);
        ec.setLayoutData((Object)gd2);
        ec.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        ExpandableComposite ec3 = this.toolkit.createExpandableComposite(sectionClient, 276);
        ec3.setText(JBossWSUIMessages.JAXRSWSTestView2_Parameters_Section);
        this.parmsList = new DelimitedStringList((Composite)ec3, 0, false, false);
        this.parmsList.setShowUpDown(false);
        this.parmsList.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setParms(JAXRSWSTestView2.this.parmsList.getSelection());
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setAction(null);
            }
        });
        ec3.setClient((Control)this.parmsList);
        this.toolkit.adapt((Composite)this.parmsList);
        GridData gd4 = new GridData(4, 4, true, false);
        ec3.setLayoutData((Object)gd4);
        ec3.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        ExpandableComposite ec5 = this.toolkit.createExpandableComposite(sectionClient, 82);
        ec5.setText(JBossWSUIMessages.JAXRSWSTestView2_BodyText_Section);
        this.requestPageBook = this.toolkit.createPageBook((Composite)ec5, 0);
        this.createRequestToolbar(ec5);
        Composite page1 = this.requestPageBook.createPage((Object)PAGE1_KEY);
        page1.setLayout((Layout)new GridLayout());
        this.bodyText = this.toolkit.createText(page1, EMPTY_STRING, 2624);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.heightHint = 1;
        this.bodyText.setLayoutData((Object)gd7);
        this.requestPageBook.showPage((Object)PAGE1_KEY);
        Composite page2 = this.requestPageBook.createPage((Object)PAGE2_KEY);
        page2.setLayout((Layout)new GridLayout());
        this.treeRequestBody = new TreeViewer(page2, 68160);
        this.treeRequestBody.setAutoExpandLevel(-1);
        GridData gd11 = new GridData(4, 4, true, true);
        gd11.heightHint = 1;
        this.toolkit.adapt((Composite)this.treeRequestBody.getTree());
        this.treeRequestBody.getTree().setLayoutData((Object)gd11);
        this.treeRequestBody.getTree().setHeaderVisible(true);
        TreeColumn nameColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        nameColumn.setText(JBossWSUIMessages.JAXRSWSTestView2_Name_column);
        nameColumn.setWidth(200);
        TreeColumn valueColumn = new TreeColumn(this.treeRequestBody.getTree(), 16384);
        valueColumn.setText(JBossWSUIMessages.JAXRSWSTestView2_Value_column);
        valueColumn.setWidth(200);
        this.treeRequestBody.setColumnProperties(TREE_COLUMNS);
        this.treeRequestBody.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                if (element instanceof TreeParent && property.equalsIgnoreCase("name")) {
                    return true;
                }
                return element instanceof TreeParent && property.equalsIgnoreCase("value");
            }

            public void removeListener(ILabelProviderListener listener) {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                Node node;
                Element tpelement;
                TreeParent tp;
                if (element instanceof TreeParent && columnIndex == 0) {
                    return ((TreeParent)element).getName();
                }
                if (element instanceof TreeParent && columnIndex == 1 && (tp = (TreeParent)element).getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0 && (node = tpelement.getChildNodes().item(0)).getNodeType() == 3) {
                    return node.getTextContent();
                }
                return null;
            }
        });
        this.treeRequestBody.setContentProvider((IContentProvider)new ITreeContentProvider(){
            String text;
            TreeParent tree;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput instanceof String) {
                    this.text = (String)newInput;
                    SOAPDOMParser parser = new SOAPDOMParser();
                    parser.parseXmlFile(this.text);
                    this.tree = parser.getRoot().getChildren().length > 0 ? (TreeParent)parser.getRoot().getChildren()[0] : null;
                }
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String && this.tree != null) {
                    return new Object[]{this.tree};
                }
                if (inputElement instanceof TreeParent) {
                    return ((TreeParent)inputElement).getChildren();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement == null && this.tree != null) {
                    return new Object[]{this.tree};
                }
                if (parentElement instanceof TreeParent && ((TreeParent)parentElement).hasChildren()) {
                    return ((TreeParent)parentElement).getChildren();
                }
                return null;
            }

            public Object getParent(Object element) {
                if (element instanceof TreeParent) {
                    return ((TreeParent)element).getParent();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof TreeParent) {
                    return ((TreeParent)element).hasChildren();
                }
                return false;
            }
        });
        this.treeRequestBody.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                Node node;
                Element tpelement;
                TreeParent tp;
                return element instanceof TreeParent && property.equalsIgnoreCase("value") && (tp = (TreeParent)element).getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0 && (node = tpelement.getChildNodes().item(0)).getNodeType() == 3 && node.getNodeValue().trim().length() > 0;
            }

            public Object getValue(Object element, String property) {
                Element tpelement;
                TreeParent tp = (TreeParent)element;
                if (tp.getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0) {
                    Node node = tpelement.getChildNodes().item(0);
                    return node.getTextContent();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                Node node;
                Element tpelement;
                TreeItem ti = (TreeItem)element;
                TreeParent tp = (TreeParent)ti.getData();
                if (tp.getData() != null && tp.getData() instanceof Element && (tpelement = (Element)tp.getData()).getChildNodes() != null && tpelement.getChildNodes().getLength() > 0 && (node = tpelement.getChildNodes().item(0)).getNodeType() == 3) {
                    node.setTextContent((String)value);
                    JAXRSWSTestView2.this.treeRequestBody.update((Object)tp, null);
                    SOAPDOMParser parser = new SOAPDOMParser();
                    String updatedOut = parser.updateValue((String)JAXRSWSTestView2.this.treeRequestBody.getInput(), tp, (String)value);
                    if (updatedOut != null && updatedOut.trim().length() > 0) {
                        Stack<String> pathStack = new Stack<String>();
                        pathStack.push(ti.getText());
                        TreeItem tiPath = ti;
                        while (tiPath.getParentItem() != null) {
                            tiPath = tiPath.getParentItem();
                            pathStack.push(tiPath.getText());
                        }
                        JAXRSWSTestView2.this.bodyText.setText(updatedOut);
                        JAXRSWSTestView2.this.getCurrentHistoryEntry().setBody(JAXRSWSTestView2.this.bodyText.getText());
                        JAXRSWSTestView2.this.treeRequestBody.setInput((Object)updatedOut);
                        JAXRSWSTestView2.this.treeRequestBody.setAutoExpandLevel(-1);
                        while (!pathStack.isEmpty()) {
                            TreeItem[] items = JAXRSWSTestView2.this.treeRequestBody.getTree().getItems();
                            String find = (String)pathStack.pop();
                            JAXRSWSTestView2.this.findTreeItem(find, items);
                        }
                    }
                }
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[1] = new TextCellEditor((Composite)this.treeRequestBody.getTree());
        this.treeRequestBody.setCellEditors(cellEditorArray);
        this.requestPageBook.showPage((Object)PAGE1_KEY);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 1;
        gd.minimumHeight = 100;
        this.requestPageBook.setLayoutData((Object)gd);
        this.requestPageBook.showPage((Object)PAGE1_KEY);
        this.bodyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!JAXRSWSTestView2.this.restoringFromHistoryEntry) {
                    JAXRSWSTestView2.this.getCurrentHistoryEntry().setBody(JAXRSWSTestView2.this.bodyText.getText());
                }
            }
        });
        this.bodyText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                JAXRSWSTestView2.this.getCurrentHistoryEntry().setBody(JAXRSWSTestView2.this.bodyText.getText());
                if (e.keyCode == 13 && e.stateMask == 262144) {
                    JAXRSWSTestView2.this.handleTest(JAXRSWSTestView2.this.getCurrentTestType());
                }
            }
        });
        ec5.setClient((Control)this.requestPageBook);
        GridData gd9 = new GridData(4, 4, true, true);
        gd9.minimumHeight = 200;
        ec5.setLayoutData((Object)gd9);
        ec5.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        section.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        section.setClient((Control)sectionClient);
    }

    private boolean findTreeItem(String name, TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            int i = 0;
            while (i < this.treeRequestBody.getTree().getColumnCount()) {
                String text = treeItem.getText(i);
                if (text.toUpperCase().contains(name.toUpperCase())) {
                    this.treeRequestBody.getTree().setSelection(treeItem);
                    return true;
                }
                if (treeItem.getItemCount() > 0) {
                    return this.findTreeItem(name, treeItem.getItems());
                }
                ++i;
            }
            ++n2;
        }
        return false;
    }

    private TestHistoryEntry getCurrentHistoryEntry() {
        if (this.currentHistoryEntry == null) {
            this.currentHistoryEntry = new TestHistoryEntry();
        }
        return this.currentHistoryEntry;
    }

    private void createResponseSide(SashForm sashForm) {
        Section section2 = this.toolkit.createSection((Composite)sashForm, 322);
        section2.setText(JBossWSUIMessages.JAXRSWSTestView2_ResponseDetails_Section);
        Composite sectionClient2 = this.toolkit.createComposite((Composite)section2);
        sectionClient2.setLayout((Layout)new GridLayout());
        sectionClient2.setLayoutData((Object)new GridData(4, 4, true, true));
        ExpandableComposite ec2 = this.toolkit.createExpandableComposite(sectionClient2, 276);
        ec2.setText(JBossWSUIMessages.JAXRSWSTestView2_ResponseHeaders_Section);
        ec2.setLayout((Layout)new GridLayout());
        this.resultHeadersList = new org.eclipse.swt.widgets.List((Composite)ec2, 2560);
        this.resultHeadersList.add(EMPTY_STRING);
        this.resultHeadersList.add(EMPTY_STRING);
        this.resultHeadersList.add(EMPTY_STRING);
        this.resultHeadersList.add(EMPTY_STRING);
        ec2.setClient((Control)this.resultHeadersList);
        this.resultsHeaderMenu = new Menu((Decorations)this.resultHeadersList.getShell(), 8);
        this.copyResultHeaderMenuAction = new MenuItem(this.resultsHeaderMenu, 8);
        this.copyResultHeaderMenuAction.setText(JBossWSUIMessages.JAXRSWSTestView_CopyResultMenu_Text);
        this.copyResultHeaderMenuAction.setAccelerator(262211);
        this.copyResultHeaderMenuAction.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                if (JAXRSWSTestView2.this.resultHeadersList.getSelectionCount() == 0) {
                    JAXRSWSTestView2.this.resultHeadersList.selectAll();
                }
                Display display = Display.getDefault();
                Clipboard cb = new Clipboard(display);
                TextTransfer textTransfer = TextTransfer.getInstance();
                cb.setContents((Object[])JAXRSWSTestView2.this.resultHeadersList.getSelection(), new Transfer[]{textTransfer});
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        this.resultHeadersList.setMenu(this.resultsHeaderMenu);
        this.resultHeadersList.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
                JAXRSWSTestView2.this.setMenusForCurrentState();
            }

            public void mouseUp(MouseEvent arg0) {
            }
        });
        GridData gd6 = new GridData(4, 4, true, false);
        gd6.heightHint = 1;
        gd6.minimumHeight = 50;
        ec2.setLayoutData((Object)gd6);
        ec2.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        ExpandableComposite ec4 = this.toolkit.createExpandableComposite(sectionClient2, 338);
        ec4.setText(JBossWSUIMessages.JAXRSWSTestView2_ResponseBody_Section);
        this.createResponseToolbar(ec4);
        this.pageBook = this.toolkit.createPageBook((Composite)ec4, 0);
        Composite page1 = this.pageBook.createPage((Object)PAGE1_KEY);
        page1.setLayout((Layout)new GridLayout());
        this.resultsText = this.toolkit.createText(page1, EMPTY_STRING, 2624);
        GridData gd7 = new GridData(4, 4, true, true);
        gd7.heightHint = 1;
        this.resultsText.setLayoutData((Object)gd7);
        this.pageBook.showPage((Object)PAGE1_KEY);
        Composite page2 = this.pageBook.createPage((Object)PAGE2_KEY);
        page2.setLayout((Layout)new GridLayout());
        this.resultsBrowser = new Browser(page2, 2112);
        GridData gd10 = new GridData(4, 4, true, true);
        gd10.heightHint = 1;
        this.toolkit.adapt((Composite)this.resultsBrowser);
        this.resultsBrowser.setLayoutData((Object)gd10);
        this.pageBook.showPage((Object)PAGE2_KEY);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 1;
        gd.minimumHeight = 100;
        this.pageBook.setLayoutData((Object)gd);
        this.pageBook.showPage((Object)PAGE1_KEY);
        this.resultsTextMenu = new Menu((Decorations)this.resultsText.getShell(), 8);
        this.copyMenuAction = new MenuItem(this.resultsTextMenu, 8);
        this.copyMenuAction.setText(JBossWSUIMessages.JAXRSWSTestView_CopyResultsMenu);
        this.copyMenuAction.setAccelerator(262211);
        this.copyMenuAction.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                if (JAXRSWSTestView2.this.resultsText.getSelectionCount() == 0) {
                    JAXRSWSTestView2.this.resultsText.selectAll();
                }
                JAXRSWSTestView2.this.resultsText.copy();
            }

            public void widgetSelected(SelectionEvent arg0) {
                this.widgetDefaultSelected(arg0);
            }
        });
        new MenuItem(this.resultsTextMenu, 2);
        this.openInXMLEditorAction = new MenuItem(this.resultsTextMenu, 8);
        this.openInXMLEditorAction.setText(JBossWSUIMessages.JAXRSWSTestView_Open_Result_in_XML_Editor);
        this.openInXMLEditorAction.setAccelerator(262223);
        this.openInXMLEditorAction.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String string = JAXRSWSTestView2.this.resultsText.getText();
                JAXRSWSTestView2.this.openXMLEditor(string);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.openResponseTagInXMLEditor = new MenuItem(this.resultsTextMenu, 8);
        this.openResponseTagInXMLEditor.setText(JBossWSUIMessages.JAXRSWSTestView_Open_Response_Tag_Contents_in_XML_Editor);
        this.openResponseTagInXMLEditor.setAccelerator(262226);
        this.openResponseTagInXMLEditor.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                String string = null;
                try {
                    SOAPBody body = null;
                    if (JAXRSWSTestView2.this.envelope != null) {
                        body = JAXRSWSTestView2.this.envelope.getBody();
                    } else if (JAXRSWSTestView2.this.soapbody != null) {
                        body = JAXRSWSTestView2.this.soapbody;
                    }
                    NodeList list = body.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        Node node = list.item(i);
                        if (node.getNodeName().contains("Response")) {
                            NodeList list2 = node.getChildNodes();
                            int j = 0;
                            while (j < list2.getLength()) {
                                Node node2 = list2.item(j);
                                if (node2.getNodeName().contains("Result")) {
                                    Node node3 = node2.getChildNodes().item(0);
                                    if (node3.getNodeType() == 3) {
                                        string = node3.getNodeValue();
                                        break;
                                    }
                                    if (node3.getNodeType() == 1) {
                                        Element element = (Element)node3;
                                        string = XMLUtils.ElementToString((Element)element);
                                        break;
                                    }
                                }
                                ++j;
                            }
                            if (string != null) break;
                        }
                        ++i;
                    }
                    if (string != null) {
                        JAXRSWSTestView2.this.openXMLEditor(string);
                    }
                }
                catch (SOAPException e) {
                    JBossWSUIPlugin.log(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.resultsText.setMenu(this.resultsTextMenu);
        this.resultsText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
            }

            public void focusGained(FocusEvent arg0) {
                JAXRSWSTestView2.this.setMenusForCurrentState();
            }
        });
        ec4.setClient((Control)this.pageBook);
        GridData gd8 = new GridData(4, 4, true, true);
        gd8.heightHint = 1;
        ec4.setLayoutData((Object)gd8);
        ec4.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        section2.addExpansionListener((IExpansionListener)new FormExpansionAdapter());
        section2.setClient((Control)sectionClient2);
    }

    public void createPartControl(Composite parent) {
        this.getImages();
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        this.form.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                JAXRSWSTestView2.this.form.setRedraw(false);
                JAXRSWSTestView2.this.form.reflow(true);
                JAXRSWSTestView2.this.form.layout(true, true);
                JAXRSWSTestView2.this.form.setRedraw(true);
            }
        });
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 1;
        this.form.getBody().setLayout((Layout)layout);
        this.createURLAndToolbar();
        SashForm sashForm = new SashForm(this.form.getBody(), 0);
        sashForm.setOrientation(256);
        this.toolkit.adapt((Composite)sashForm);
        GridLayout sashLayout = new GridLayout(2, false);
        sashForm.setLayout((Layout)sashLayout);
        GridData gd3 = new GridData(4, 4, true, true);
        gd3.horizontalSpan = 2;
        gd3.widthHint = 1;
        sashForm.setLayoutData((Object)gd3);
        this.createRequestSide(sashForm);
        this.createResponseSide(sashForm);
        this.toolkit.paintBordersFor((Composite)this.form);
        this.form.reflow(true);
        this.methodCombo.setText(GET);
        this.setControlsForWSType(this.getCurrentTestType());
        this.setControlsForMethodType(this.methodCombo.getText());
        this.setControlsForSelectedURL();
        this.setMenusForCurrentState();
    }

    public void dispose() {
        this.toolkit.dispose();
        this.mImageRegistry.dispose();
        super.dispose();
    }

    private String generateSampleSOAP(String headerText, String innerText, boolean isSOAP12) {
        if (innerText != null && !innerText.trim().isEmpty() && innerText.trim().startsWith("<?xml version=\"1.0\"")) {
            return innerText;
        }
        String prefix = "soap";
        String soapURI = "http://schemas.xmlsoap.org/soap/envelope/";
        if (isSOAP12) {
            prefix = "soap12";
            soapURI = "http://www.w3.org/2003/05/soap-envelope";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\" ?>\n");
        buffer.append("<" + prefix + ":Envelope xmlns:" + prefix + "=\"" + soapURI + "\" ");
        buffer.append("xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" ");
        buffer.append("xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" >\n");
        buffer.append("<" + prefix + ":Header>\n");
        if (headerText != null) {
            buffer.append(headerText);
        }
        buffer.append("</" + prefix + ":Header>\n");
        buffer.append("<" + prefix + ":Body>\n");
        if (innerText != null) {
            buffer.append(innerText);
        }
        buffer.append("</" + prefix + ":Body>\n");
        buffer.append("</" + prefix + ":Envelope>");
        return buffer.toString();
    }

    private void setMenusForCurrentState() {
        boolean enabled;
        if (this.resultsText != null && !this.resultsText.isDisposed()) {
            enabled = this.resultsText.getText().trim().length() > 0;
            this.copyMenuAction.setEnabled(enabled);
            this.openInXMLEditorAction.setEnabled(enabled);
            if (this.getCurrentTestType().equalsIgnoreCase(JAX_WS)) {
                this.openResponseTagInXMLEditor.setEnabled(enabled);
            } else if (this.getCurrentTestType().equalsIgnoreCase(JAX_RS)) {
                this.openResponseTagInXMLEditor.setEnabled(false);
            }
        }
        if (this.resultHeadersList != null && !this.resultHeadersList.isDisposed()) {
            enabled = this.resultHeadersList.getItemCount() > 0;
            this.copyResultHeaderMenuAction.setEnabled(enabled);
        }
    }

    private void openXMLEditor(String text) {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        ResultsXMLStorage storage = new ResultsXMLStorage(text);
        ResultsXMLStorageInput input = new ResultsXMLStorageInput(storage);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            try {
                if (WSTestUtils.isTextXML(text)) {
                    if (window.getWorkbench().getEditorRegistry().findEditor(XML_EDITOR_ID) != null) {
                        page.openEditor((IEditorInput)input, XML_EDITOR_ID);
                    } else {
                        page.openEditor((IEditorInput)input, DEFAULT_TEXT_EDITOR_ID);
                    }
                } else {
                    page.openEditor((IEditorInput)input, DEFAULT_TEXT_EDITOR_ID);
                }
            }
            catch (PartInitException e) {
                JBossWSUIPlugin.log(e);
            }
        }
    }

    private void setControlsForSelectedEntry(TestHistoryEntry entry) {
        if (entry != null) {
            this.restoringFromHistoryEntry = true;
            if (entry.getWsTech() != null) {
                this.setControlsForWSType(entry.getWsTech());
                if (entry.getWsTech().equalsIgnoreCase(JAX_WS)) {
                    this.methodCombo.setText(JAX_WS);
                }
            }
            if (entry.getMethod() != null && entry.getWsTech().equalsIgnoreCase(JAX_RS)) {
                this.methodCombo.setText(entry.getMethod());
                this.setControlsForMethodType(entry.getMethod());
            }
            if (this.bodyText.isEnabled()) {
                this.bodyText.setText(entry.getBody());
            }
            if (!this.treeRequestBody.getTree().isDisposed()) {
                if (entry.getBody().trim().length() > 0) {
                    if (SOAPDOMParser.isXMLLike(entry.getBody())) {
                        this.treeRequestBody.setInput((Object)entry.getBody());
                    } else {
                        this.treeRequestBody.setInput(null);
                    }
                } else {
                    this.treeRequestBody.setInput(null);
                }
            }
            if (this.dlsList.isEnabled()) {
                this.dlsList.setSelection(entry.getHeaders());
            }
            if (this.parmsList.isEnabled()) {
                this.parmsList.setSelection(entry.getParms());
            }
            if (this.resultHeadersList.isEnabled()) {
                this.resultHeadersList.removeAll();
                String[] headers = entry.getResultHeadersList();
                if (headers != null && headers.length > 0) {
                    int i = 0;
                    while (i < headers.length) {
                        this.resultHeadersList.add(headers[i]);
                        ++i;
                    }
                }
            }
            if (this.resultsText.isEnabled() && this.resultsBrowser.isEnabled()) {
                this.resultsText.setText(entry.getResultText());
                this.resultsBrowser.setText(entry.getResultText());
            }
            if (entry.getUrl().trim().length() > 0) {
                String urlText = entry.getUrl();
                try {
                    new URL(urlText);
                    this.startToolItem.setEnabled(true);
                }
                catch (MalformedURLException malformedURLException) {
                    this.startToolItem.setEnabled(false);
                    return;
                }
            } else {
                this.startToolItem.setEnabled(false);
            }
            this.restoringFromHistoryEntry = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setControlsForSelectedURL() {
        if (this.urlCombo.getText().trim().length() > 0) {
            String urlText = this.urlCombo.getText();
            try {
                new URL(urlText);
                this.startToolItem.setEnabled(true);
                if (!urlText.trim().startsWith(HTTPS_STRING)) return;
                this.useBasicAuthCB.setSelection(true);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                this.startToolItem.setEnabled(false);
                return;
            }
        } else {
            this.startToolItem.setEnabled(false);
        }
    }

    private void setControlsForMethodType(String methodType) {
        if (this.getCurrentTestType().equalsIgnoreCase(JAX_RS) && (methodType.equalsIgnoreCase(GET) || methodType.equalsIgnoreCase(OPTIONS))) {
            this.bodyText.setEnabled(false);
            this.treeRequestBody.getTree().setEnabled(false);
        } else {
            this.bodyText.setEnabled(true);
            this.treeRequestBody.getTree().setEnabled(true);
        }
    }

    private void setControlsForWSType(String wsType) {
        if (wsType.equalsIgnoreCase(JAX_WS)) {
            this.bodyText.setEnabled(true);
            this.treeRequestBody.getTree().setEnabled(true);
            this.parmsList.setEnabled(false);
            this.parmsList.removeAll();
            this.dlsList.setEnabled(false);
            String emptySOAP = this.generateSampleSOAP(null, null, false);
            emptySOAP = WSTestUtils.addNLsToXML(emptySOAP);
            if (this.bodyText.getText().trim().length() == 0) {
                this.bodyText.setText(emptySOAP);
                this.treeRequestBody.setInput((Object)emptySOAP);
            }
            this.openWSDLToolItem.setEnabled(true);
        } else if (wsType.equalsIgnoreCase(JAX_RS)) {
            this.bodyText.setEnabled(true);
            this.treeRequestBody.getTree().setEnabled(true);
            this.parmsList.setEnabled(true);
            this.dlsList.setEnabled(true);
            this.openWSDLToolItem.setEnabled(false);
            if (this.bodyText.getText().trim().length() > 0) {
                this.bodyText.setText(EMPTY_STRING);
                this.treeRequestBody.setInput(null);
            }
        }
        this.setMenusForCurrentState();
    }

    private String getOpNameFromRequestBody() {
        MessageFactoryImpl factory = new MessageFactoryImpl();
        String lookForOpName = null;
        try {
            SOAPMessage message = factory.createMessage(null, (InputStream)new ByteArrayInputStream(this.getCurrentHistoryEntry().getBody().trim().getBytes()));
            SOAPBody body = message.getSOAPBody();
            Iterator elements = body.getChildElements();
            if (elements.hasNext()) {
                Element element = (Element)elements.next();
                lookForOpName = element.getNodeName();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return lookForOpName;
    }

    private void handleTest(final String wsTech) {
        String urlText = this.urlCombo.getText();
        if (urlText.endsWith("}")) {
            WSTesterURLInputsDialog dialog = new WSTesterURLInputsDialog(this.getSite().getShell(), urlText);
            int rtn_code = dialog.open();
            if (rtn_code == 0) {
                urlText = dialog.getURL();
                this.urlCombo.setText(urlText);
            } else {
                return;
            }
        }
        try {
            new URL(urlText);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        String lookForOpName = null;
        if (wsTech.contentEquals(JAX_WS)) {
            boolean result;
            lookForOpName = this.getOpNameFromRequestBody();
            if (this.getCurrentHistoryEntry().getAction() == null && !(result = this.getWSDLSpecifics(lookForOpName))) {
                return;
            }
        }
        if (this.urlCombo.getItemCount() > 0) {
            List<String> aList = Arrays.asList(this.urlCombo.getItems());
            if (!aList.contains(this.urlCombo.getText())) {
                this.urlCombo.add(this.urlCombo.getText());
            }
        } else {
            this.urlCombo.add(this.urlCombo.getText());
        }
        this.getCurrentHistoryEntry().setWsTech(wsTech);
        if (!this.getCurrentHistoryEntry().getUrl().contentEquals(urlText)) {
            this.getCurrentHistoryEntry().setUrl(urlText);
        }
        final String url = this.getCurrentHistoryEntry().getUrl();
        final String action = this.getCurrentHistoryEntry().getAction();
        String tempBody = this.getCurrentHistoryEntry().getBody();
        if (SOAPDOMParser.isXMLLike(tempBody)) {
            tempBody = tempBody.replaceAll(">\\s+<", "><");
        }
        final String body = tempBody;
        final String method = this.getCurrentHistoryEntry().getMethod();
        final String headers = this.getCurrentHistoryEntry().getHeaders();
        final String parms = this.getCurrentHistoryEntry().getParms();
        String tempUID = null;
        String tempPwd = null;
        if (this.useBasicAuthCB.getSelection()) {
            UidPwdDialog authDialog = new UidPwdDialog(this.getSite().getShell());
            int rtnCode = authDialog.open();
            if (rtnCode == 0) {
                tempUID = authDialog.getUID();
                tempPwd = authDialog.getPwd();
            } else {
                return;
            }
        }
        final String uid = tempUID;
        final String pwd = tempPwd;
        Job aJob = new Job(JBossWSUIMessages.JAXRSWSTestView_Invoking_WS_Status){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                if (wsTech.equalsIgnoreCase(JAXRSWSTestView2.JAX_RS)) {
                    status = JAXRSWSTestView2.this.handleRSTest(monitor, url, method, body, parms, headers, uid, pwd);
                } else if (wsTech.equalsIgnoreCase(JAXRSWSTestView2.JAX_WS)) {
                    status = JAXRSWSTestView2.this.handleWSTest(monitor, url, action, body, uid, pwd);
                }
                monitor.done();
                return status;
            }
        };
        aJob.setUser(true);
        aJob.addJobChangeListener(new IJobChangeListener(){

            public void sleeping(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void running(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult() instanceof WSTestStatus) {
                    final WSTestStatus status = (WSTestStatus)event.getResult();
                    PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            TestHistoryEntry oldEntry;
                            if (status.getResultsText() != null) {
                                String results = status.getResultsText();
                                results = SOAPDOMParser.isValidXML(results) ? SOAPDOMParser.prettyPrint(results) : SOAPDOMParser.prettyPrintJSON(results);
                                JAXRSWSTestView2.this.getCurrentHistoryEntry().setResultText(results);
                                JAXRSWSTestView2.this.getCurrentHistoryEntry().setUrl(JAXRSWSTestView2.this.urlCombo.getText());
                                JAXRSWSTestView2.this.resultsText.setText(results);
                                JAXRSWSTestView2.this.resultsBrowser.setText(results);
                                JAXRSWSTestView2.this.form.reflow(true);
                            } else if (status.getMessage() != null) {
                                JAXRSWSTestView2.this.getCurrentHistoryEntry().setResultText(status.getMessage());
                                JAXRSWSTestView2.this.getCurrentHistoryEntry().setUrl(JAXRSWSTestView2.this.urlCombo.getText());
                                JAXRSWSTestView2.this.resultsText.setText(status.getMessage());
                                JAXRSWSTestView2.this.resultsBrowser.setText(status.getMessage());
                                JAXRSWSTestView2.this.form.reflow(true);
                            }
                            JAXRSWSTestView2.this.resultHeadersList.removeAll();
                            String[] headers = DelimitedStringList.parseString(status.getHeadersList(), JAXRSWSTestView2.RESULT_HEADER_DELIMITER);
                            if (headers != null && headers.length > 0) {
                                int i = 0;
                                while (i < headers.length) {
                                    JAXRSWSTestView2.this.resultHeadersList.add(headers[i]);
                                    ++i;
                                }
                            }
                            JAXRSWSTestView2.this.getCurrentHistoryEntry().setResultHeadersList(headers);
                            if (JAXRSWSTestView2.this.resultsText.getText().trim().length() == 0 && headers != null && headers.length > 0) {
                                JAXRSWSTestView2.this.getCurrentHistoryEntry().setResultText(JBossWSUIMessages.JAXRSWSTestView2_Msg_No_Results_Check_Headers);
                                JAXRSWSTestView2.this.resultsText.setText(JBossWSUIMessages.JAXRSWSTestView2_Msg_No_Results_Check_Headers);
                                JAXRSWSTestView2.this.form.reflow(true);
                            }
                            if ((oldEntry = JAXRSWSTestView2.this.history.findEntryByURL(JAXRSWSTestView2.this.getCurrentHistoryEntry().getUrl())) != null) {
                                JAXRSWSTestView2.this.history.replaceEntry(oldEntry, JAXRSWSTestView2.this.getCurrentHistoryEntry());
                            } else {
                                try {
                                    JAXRSWSTestView2.this.history.addEntry((TestHistoryEntry)JAXRSWSTestView2.this.getCurrentHistoryEntry().clone());
                                }
                                catch (CloneNotSupportedException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                }
            }

            public void awake(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }
        });
        aJob.schedule();
        this.setMenusForCurrentState();
    }

    /*
     * Unable to fully structure code
     */
    private IStatus handleWSTest(IProgressMonitor monitor, String url, String action, String body, String uid, String pwd) {
        try {
            JBossWSUIPlugin.getDefault().countRequestSubmitted("JAX-WS");
            this.envelope = null;
            this.soapbody = null;
            monitor.worked(10);
            tester = new JAXWSTester2();
            itRan = false;
            this.serviceNSMessage = this.getCurrentHistoryEntry().getServiceNSMessage();
            while (!monitor.isCanceled()) {
                try {
                    if (itRan || this.serviceNSMessage == null || this.serviceNSMessage.length != 3) break;
                    itRan = true;
                    tester.doTest(monitor, url, action, this.serviceNSMessage[0], this.serviceNSMessage[1], this.serviceNSMessage[2], body, uid, pwd);
                }
                catch (InterruptedException v0) {
                    monitor.setCanceled(true);
                }
            }
            if (monitor.isCanceled()) {
                status = new WSTestStatus(0, "org.jboss.tools.ws.ui", JBossWSUIMessages.JAXRSWSTestView_Message_Service_Invocation_Cancelled);
                return status;
            }
            if (!itRan) {
                status = new WSTestStatus(0, "org.jboss.tools.ws.ui", JBossWSUIMessages.JAXRSWSTestView_Message_Unsuccessful_Test);
                return status;
            }
            monitor.worked(70);
            result = tester.getResultBody();
            this.envelope = tester.getResultSOAP();
            this.soapbody = tester.getResultSOAPBody();
            cleanedUp = WSTestUtils.addNLsToXML(result);
            status = new WSTestStatus(0, "org.jboss.tools.ws.ui", JBossWSUIMessages.JAXRSWSTestView_JAXWS_Success_Status);
            status.setResultsText(cleanedUp);
            monitor.worked(10);
            listText = "";
            if (tester.getResultHeaders() != null) {
                iter = tester.getResultHeaders().entrySet().iterator();
                while (iter.hasNext()) {
                    text = "";
                    entry = iter.next();
                    text = entry.getKey() == null ? entry.getValue().toString() : String.valueOf(text) + entry.toString();
                    listText = String.valueOf(listText) + text;
                    if (!iter.hasNext()) continue;
                    listText = String.valueOf(listText) + "%";
                }
            }
            status.setHeadersList(listText);
            monitor.worked(10);
            return status;
        }
        catch (Exception e) {
            innerE = e.getCause();
            if (innerE != null) ** GOTO lbl55
            status = new WSTestStatus(0, "org.jboss.tools.ws.ui", String.valueOf(JBossWSUIMessages.JAXRSWSTestView_Exception_Status) + e.getLocalizedMessage());
            status.setResultsText(e.toString());
            if (!e.getLocalizedMessage().contains("Unsupported endpoint address: REPLACE_WITH_ACTUAL_URL")) {
                JBossWSUIPlugin.log(e);
            }
            return status;
        }
lbl-1000:
        // 1 sources

        {
            innerE = innerE.getCause();
lbl55:
            // 2 sources

            ** while (innerE.getCause() != null)
        }
lbl56:
        // 1 sources

        status = new WSTestStatus(0, "org.jboss.tools.ws.ui", String.valueOf(JBossWSUIMessages.JAXRSWSTestView_Exception_Status) + innerE.getLocalizedMessage());
        status.setResultsText(innerE.toString());
        if (!innerE.getLocalizedMessage().contains("Unsupported endpoint address: REPLACE_WITH_ACTUAL_URL")) {
            JBossWSUIPlugin.log(e);
        }
        return status;
    }

    /*
     * Unable to fully structure code
     */
    private IStatus handleRSTest(IProgressMonitor monitor, String address, String method, String body, String parms, String headersStr, String uid, String pwd) {
        block14: {
            if (method.equalsIgnoreCase("GET")) {
                body = "";
            }
            if (body != null && body.trim().length() == 0) {
                body = null;
            }
            monitor.worked(10);
            parameters = new HashMap<String, String>();
            if (parms != null && parms.length() > 0 && (parsedList = DelimitedStringList.parseString(parms, ",")) != null && parsedList.length > 0) {
                i = 0;
                while (i < parsedList.length) {
                    nameValuePair = parsedList[i];
                    nameAndValue = DelimitedStringList.parseString(nameValuePair, "=");
                    if (nameAndValue != null && nameAndValue.length == 2) {
                        parameters.put(nameAndValue[0], nameAndValue[1]);
                    }
                    ++i;
                }
            }
            monitor.worked(10);
            headers = new HashMap<String, String>();
            if (headersStr != null && headersStr.length() > 0 && (parsedList = DelimitedStringList.parseString(headersStr, ",")) != null && parsedList.length > 0) {
                i = 0;
                while (i < parsedList.length) {
                    nameValuePair = parsedList[i];
                    nameAndValue = DelimitedStringList.parseString(nameValuePair, "=");
                    if (nameAndValue != null && nameAndValue.length == 2) {
                        headers.put(nameAndValue[0], nameAndValue[1]);
                    }
                    ++i;
                }
            }
            tester = new JAXRSTester();
            try {
                JBossWSUIPlugin.getDefault().countRequestSubmitted(method);
                tester.doTest(address, parameters, headers, method, body, null, -1, uid, pwd);
                result = tester.getResultBody();
                cleanedUp = WSTestUtils.addNLsToXML(result);
                status = new WSTestStatus(0, "org.jboss.tools.ws.ui", JBossWSUIMessages.JAXRSWSTestView_JAXRS_Success_Status);
                status.setResultsText(cleanedUp);
                listText = "";
                if (tester.getResultHeaders() != null) {
                    iter = tester.getResultHeaders().entrySet().iterator();
                    while (iter.hasNext()) {
                        text = "";
                        entry = iter.next();
                        text = entry.getKey() == null ? entry.getValue().toString() : String.valueOf(text) + entry.toString();
                        listText = String.valueOf(listText) + text;
                        if (!iter.hasNext()) continue;
                        listText = String.valueOf(listText) + "%";
                    }
                }
                status.setHeadersList(listText);
                monitor.worked(10);
                return status;
            }
            catch (Exception e) {
                result = tester.getResultBody();
                if (result.isEmpty()) {
                    result = e.getLocalizedMessage();
                }
                cleanedUp = WSTestUtils.addNLsToXML(result);
                status = new WSTestStatus(0, "org.jboss.tools.ws.ui", JBossWSUIMessages.JAXRSWSTestView_JAXRS_Success_Status);
                status.setResultsText(cleanedUp);
                listText = "";
                if (tester.getResultHeaders() == null) break block14;
                iter = tester.getResultHeaders().entrySet().iterator();
                ** while (iter.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                text = "";
                entry = iter.next();
                text = entry.getKey() == null ? entry.getValue().toString() : String.valueOf(text) + entry.toString();
                listText = String.valueOf(listText) + text;
                if (!iter.hasNext()) continue;
                listText = String.valueOf(listText) + "%";
                continue;
            }
        }
        status.setHeadersList(listText);
        monitor.worked(10);
        return status;
    }

    public void setFocus() {
        this.urlCombo.setFocus();
    }

    class FileSaveAction
    extends Action {
        FileSaveAction() {
        }

        public void run() {
            IStatus status = WSTestUtils.saveTextToFile(JAXRSWSTestView2.this.resultsText.getText());
            if (status.getCode() == 4) {
                MessageDialog.openError((Shell)new Shell(Display.getCurrent()), (String)JBossWSUIMessages.JAXRSWSTestView2_SaveResponseText_Error, (String)status.getMessage());
            }
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_SaveResponseText_tooltip;
        }

        public ImageDescriptor getImageDescriptor() {
            return JAXRSWSTestView2.this.mImageRegistry.getDescriptor(JAXRSWSTestView2.IMG_DESC_SAVE);
        }
    }

    class FormExpansionAdapter
    extends ExpansionAdapter {
        FormExpansionAdapter() {
        }

        public void expansionStateChanged(ExpansionEvent e) {
            JAXRSWSTestView2.this.form.setRedraw(false);
            JAXRSWSTestView2.this.form.reflow(true);
            JAXRSWSTestView2.this.form.layout(true, true);
            JAXRSWSTestView2.this.form.setRedraw(true);
        }
    }

    class OpenInXMLEditorAction
    extends Action {
        OpenInXMLEditorAction() {
        }

        public void run() {
            JAXRSWSTestView2.this.openXMLEditor(JAXRSWSTestView2.this.resultsText.getText());
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_OpenInEditor_Action;
        }

        public ImageDescriptor getImageDescriptor() {
            return JAXRSWSTestView2.this.mImageRegistry.getDescriptor(JAXRSWSTestView2.IMG_DESC_SHOWEDITOR);
        }
    }

    class ShowInBrowserAction
    extends ToggleAction {
        ShowInBrowserAction() {
        }

        public void run() {
            if (JAXRSWSTestView2.this.rawAction.isChecked()) {
                JAXRSWSTestView2.this.rawAction.setChecked(false);
            }
            if (JAXRSWSTestView2.this.resultsText.getText().length() > 0) {
                JAXRSWSTestView2.this.resultsBrowser.setText(JAXRSWSTestView2.this.resultsText.getText());
            }
            JAXRSWSTestView2.this.pageBook.showPage((Object)JAXRSWSTestView2.PAGE2_KEY);
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_ShowInBrowser_Tooltip;
        }

        public ImageDescriptor getImageDescriptor() {
            return JAXRSWSTestView2.this.mImageRegistry.getDescriptor(JAXRSWSTestView2.IMG_DESC_SHOWWEB);
        }
    }

    class ShowInTreeAction
    extends ToggleAction {
        ShowInTreeAction() {
        }

        public void run() {
            String rawRequestBody;
            if (JAXRSWSTestView2.this.rawRequestAction.isChecked()) {
                JAXRSWSTestView2.this.rawRequestAction.setChecked(false);
            }
            if ((rawRequestBody = JAXRSWSTestView2.this.bodyText.getText()).trim().length() > 0) {
                JAXRSWSTestView2.this.treeRequestBody.setInput((Object)rawRequestBody);
            } else {
                JAXRSWSTestView2.this.treeRequestBody.setInput(null);
            }
            JAXRSWSTestView2.this.requestPageBook.showPage((Object)JAXRSWSTestView2.PAGE2_KEY);
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_ShowRequestTree_toolbar_btn;
        }

        public ImageDescriptor getImageDescriptor() {
            return JAXRSWSTestView2.this.mImageRegistry.getDescriptor(JAXRSWSTestView2.IMG_DESC_SHOWTREE);
        }
    }

    class ShowRawAction
    extends ToggleAction {
        ShowRawAction() {
        }

        public void run() {
            if (JAXRSWSTestView2.this.browserAction.isChecked()) {
                JAXRSWSTestView2.this.browserAction.setChecked(false);
            }
            JAXRSWSTestView2.this.pageBook.showPage((Object)JAXRSWSTestView2.PAGE1_KEY);
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_ShowRaw_Tooltip;
        }

        public ImageDescriptor getImageDescriptor() {
            return JAXRSWSTestView2.this.mImageRegistry.getDescriptor(JAXRSWSTestView2.IMG_DESC_SHOWRAW);
        }
    }

    class ShowRawRequestAction
    extends ToggleAction {
        ShowRawRequestAction() {
        }

        public void run() {
            if (JAXRSWSTestView2.this.treeAction.isChecked()) {
                JAXRSWSTestView2.this.treeAction.setChecked(false);
            }
            JAXRSWSTestView2.this.requestPageBook.showPage((Object)JAXRSWSTestView2.PAGE1_KEY);
        }

        public String getToolTipText() {
            return JBossWSUIMessages.JAXRSWSTestView2_ShowRequestXML_toolbar_btn;
        }

        public ImageDescriptor getImageDescriptor() {
            return JAXRSWSTestView2.this.mImageRegistry.getDescriptor(JAXRSWSTestView2.IMG_DESC_SHOWRAW);
        }
    }

    class ToggleAction
    extends Action {
        public ToggleAction() {
            super(null, 2);
        }
    }
}

