/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.ws.ui.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.ws.core.utils.StatusUtils;
import org.jboss.tools.ws.creation.core.utils.JBossWSCreationUtils;
import org.jboss.tools.ws.ui.JBossWSUIPlugin;
import org.jboss.tools.ws.ui.messages.JBossWSUIMessages;

public class JBossWSUIUtils {
    private static String JAVA = ".java";
    private static String CLASS = ".class";
    private static final String WS_NATIVE_JAR = "jbossws-native-client.jar";
    private static final String WS_CXF_JAR = "jbossws-cxf-client.jar";
    private static final String WS_METRO_JAR = "jbossws-metro-client.jar";
    private static final String CLIENT_FOLDER = "client";
    private static final String CLIENT_AS7_FOLDER = "modules:org:jboss:ws:jaxws-client:main";
    private static final String CLIENT_AS71_FOLDER = "modules:system:layers:base:org:jboss:ws:jaxws-client:main";
    private static final String WS_IMPL = "Implementation-Title";
    private static final String WS_VERSION = "Implementation-Version";
    private static final String WS_JAR = "jbossws-client.jar";

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return String.valueOf(currentPath) + File.separator + newNode;
    }

    public static String addNodesToPath(String currentPath, String[] newNode) {
        String returnPath = currentPath;
        int i = 0;
        while (i < newNode.length) {
            returnPath = String.valueOf(returnPath) + File.separator + newNode[i];
            ++i;
        }
        return returnPath;
    }

    public static IStatus validateClassName(String name, IJavaElement context) {
        IStatus status = null;
        String[] sourceComplianceLevels = JBossWSUIUtils.getSourceComplianceLevels(context);
        status = JavaConventions.validateClassFileName((String)(String.valueOf(name) + CLASS), (String)sourceComplianceLevels[0], (String)sourceComplianceLevels[1]);
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        File file = JBossWSCreationUtils.findFileByPath((String)(String.valueOf(name) + JAVA), (String)context.getJavaProject().getProject().getLocation().toOSString());
        if (file != null && file.exists()) {
            status = StatusUtils.warningStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_ClassName_Same);
        }
        return status;
    }

    public static IStatus validatePackageName(String name, IJavaElement context) {
        IStatus status = null;
        if (!(context != null && context.exists() || (status = JavaConventions.validatePackageName((String)name, (String)"1.3", (String)"1.3")) == null || status.isOK())) {
            return status;
        }
        String[] sourceComplianceLevels = JBossWSUIUtils.getSourceComplianceLevels(context);
        status = JavaConventions.validatePackageName((String)name, (String)sourceComplianceLevels[0], (String)sourceComplianceLevels[1]);
        if (status != null && status.getSeverity() == 4) {
            return status;
        }
        IPackageFragmentRoot[] roots = null;
        try {
            IResource[] srcFolders = JBossWSCreationUtils.getJavaSourceRoots((IJavaProject)context.getJavaProject());
            roots = new IPackageFragmentRoot[srcFolders.length];
            int i = 0;
            IResource[] iResourceArray = srcFolders;
            int n = srcFolders.length;
            int n2 = 0;
            while (n2 < n) {
                IResource src = iResourceArray[n2];
                roots[i] = context.getJavaProject().getPackageFragmentRoot(src);
                ++i;
                ++n2;
            }
        }
        catch (JavaModelException e) {
            JBossWSUIPlugin.log(e);
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
        int n = roots.length;
        int n3 = 0;
        while (n3 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n3];
            if (root != null) {
                IPackageFragment pack = root.getPackageFragment(name);
                try {
                    IFileStore store;
                    URI location;
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = pack.getPath())) {
                        status = StatusUtils.warningStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_IsOutputFolder);
                        return status;
                    }
                    if (pack.exists()) {
                        status = pack.containsJavaResources() || !pack.hasSubpackages() ? StatusUtils.warningStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_PackageExists) : StatusUtils.warningStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_PackageNotShown);
                        return status;
                    }
                    if (pack.getResource() != null && (location = pack.getResource().getLocationURI()) != null && (store = EFS.getStore((URI)location)).fetchInfo().exists()) {
                        status = StatusUtils.warningStatus((String)JBossWSUIMessages.Error_JBossWS_GenerateWizard_PackageExistsDifferentCase);
                        return status;
                    }
                }
                catch (CoreException e) {
                    JBossWSUIPlugin.log(e);
                }
            }
            ++n3;
        }
        return status;
    }

    public static String[] getSourceComplianceLevels(IJavaElement context) {
        IJavaProject javaProject;
        if (context != null && (javaProject = context.getJavaProject()) != null) {
            return new String[]{javaProject.getOption("org.eclipse.jdt.core.compiler.source", true), javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)};
        }
        return new String[]{JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source"), JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance")};
    }

    public static String[] getWSRuntimeDetail(String serverHome) {
        String as71;
        File as71File;
        String[] strs = null;
        File jbosswsHomeDir = new File(serverHome);
        String jarPath = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), new String[]{CLIENT_FOLDER, WS_CXF_JAR});
        strs = JBossWSUIUtils.getWSRuntimeDetailFromPath(jarPath);
        if (strs != null) {
            return strs;
        }
        jarPath = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), new String[]{CLIENT_FOLDER, WS_NATIVE_JAR});
        strs = JBossWSUIUtils.getWSRuntimeDetailFromPath(jarPath);
        if (strs != null) {
            return strs;
        }
        jarPath = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), new String[]{CLIENT_FOLDER, WS_METRO_JAR});
        strs = JBossWSUIUtils.getWSRuntimeDetailFromPath(jarPath);
        if (strs != null) {
            return strs;
        }
        jarPath = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), new String[]{CLIENT_FOLDER, WS_JAR});
        strs = JBossWSUIUtils.getWSRuntimeDetailFromPath(jarPath);
        if (strs != null) {
            return strs;
        }
        String as7 = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), CLIENT_AS7_FOLDER.split(":"));
        File as7File = new File(as7);
        if (as7File.exists() && as7File.isDirectory()) {
            File[] files = as7File.listFiles();
            String jarName = "";
            int i = 0;
            while (i < files.length) {
                jarName = files[i].getName();
                if ((jarName.contains(WS_CXF_JAR.substring(0, WS_CXF_JAR.length() - 5)) || jarName.contains(WS_CXF_JAR.substring(0, WS_NATIVE_JAR.length() - 5)) || jarName.contains(WS_CXF_JAR.substring(0, WS_METRO_JAR.length() - 5))) && (strs = JBossWSUIUtils.getWSRuntimeDetailFromPath(files[i].getAbsolutePath())) != null) {
                    return strs;
                }
                ++i;
            }
        }
        if ((as71File = new File(as71 = JBossWSUIUtils.addNodesToPath(jbosswsHomeDir.getAbsolutePath(), CLIENT_AS71_FOLDER.split(":")))).exists() && as71File.isDirectory()) {
            File[] files71 = as71File.listFiles();
            String jarName71 = "";
            int i = 0;
            while (i < files71.length) {
                jarName71 = files71[i].getName();
                if ((jarName71.contains(WS_CXF_JAR.substring(0, WS_CXF_JAR.length() - 5)) || jarName71.contains(WS_CXF_JAR.substring(0, WS_NATIVE_JAR.length() - 5)) || jarName71.contains(WS_CXF_JAR.substring(0, WS_METRO_JAR.length() - 5))) && (strs = JBossWSUIUtils.getWSRuntimeDetailFromPath(files71[i].getAbsolutePath())) != null) {
                    return strs;
                }
                ++i;
            }
        }
        return new String[]{"", ""};
    }

    public static String[] getWSRuntimeDetailFromPath(String path) {
        File jarFile = new File(path);
        if (!jarFile.isFile()) {
            return null;
        }
        String[] strs = new String[]{"", ""};
        JarFile jar = null;
        try {
            try {
                jar = new JarFile(jarFile);
                Attributes attributes = jar.getManifest().getMainAttributes();
                strs[0] = attributes.getValue(WS_IMPL);
                strs[1] = attributes.getValue(WS_VERSION);
            }
            catch (IOException iOException) {
                String[] stringArray = strs;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException iOException2) {}
                }
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException iOException) {}
        }
        return strs;
    }

    public static Label[] createWSRuntimeDetailsGroup(Composite root, int horizontalSpan) {
        Group wsRuntimeDetails = new Group(root, 0);
        wsRuntimeDetails.setText(JBossWSUIMessages.Runtime_Details);
        GridData gd = new GridData(768);
        gd.horizontalSpan = horizontalSpan;
        wsRuntimeDetails.setLayout((Layout)new GridLayout(2, false));
        wsRuntimeDetails.setLayoutData((Object)gd);
        new Label((Composite)wsRuntimeDetails, 0).setText(JBossWSUIMessages.Runtime_Details_Impl);
        Label impl = new Label((Composite)wsRuntimeDetails, 0);
        gd = new GridData(768);
        impl.setLayoutData((Object)gd);
        new Label((Composite)wsRuntimeDetails, 0).setText(JBossWSUIMessages.Runtime_Details_Version);
        Label vDetail = new Label((Composite)wsRuntimeDetails, 0);
        gd = new GridData(768);
        vDetail.setLayoutData((Object)gd);
        Label[] labels = new Label[]{impl, vDetail};
        return labels;
    }
}

