/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.el.internal.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.tools.common.el.core.model.ELObject;
import org.jboss.tools.common.el.core.parser.LexicalToken;
import org.jboss.tools.common.el.internal.core.model.ELModelImpl;

public abstract class ELObjectImpl
implements ELObject {
    protected LexicalToken firstToken;
    protected LexicalToken lastToken;
    protected ELObjectImpl parent;
    protected List<ELObject> children = null;
    static List<ELObject> empty = Collections.emptyList();

    @Override
    public ELModelImpl getModel() {
        return this.parent == null ? null : this.parent.getModel();
    }

    @Override
    public int getLength() {
        return this.getEndPosition() - this.getStartPosition();
    }

    @Override
    public int getStartPosition() {
        return this.firstToken == null ? -1 : this.firstToken.getStart();
    }

    @Override
    public int getEndPosition() {
        LexicalToken lt = this.lastToken != null ? this.lastToken : this.firstToken;
        return lt == null ? -1 : lt.getStart() + lt.getLength();
    }

    @Override
    public String getText() {
        if (this.getModel() == null) {
            return null;
        }
        String source = this.getModel().getSource();
        int start = this.firstToken.getStart() - this.getModel().delta;
        LexicalToken lt = this.lastToken != null ? this.lastToken : this.firstToken;
        int end = lt.getStart() + lt.getLength() - this.getModel().delta;
        return source.substring(start, end);
    }

    @Override
    public ELObjectImpl getParent() {
        return this.parent;
    }

    @Override
    public List<ELObject> getChildren() {
        return this.children == null ? empty : this.children;
    }

    @Override
    public LexicalToken getFirstToken() {
        return this.firstToken;
    }

    @Override
    public LexicalToken getLastToken() {
        return this.lastToken;
    }

    public void setParent(ELObjectImpl parent) {
        this.parent = parent;
    }

    public void addChild(ELObjectImpl child) {
        if (this.children == null) {
            this.children = new ArrayList<ELObject>(1);
        }
        this.children.add(child);
        child.setParent(this);
    }

    protected void removeChild(ELObjectImpl child) {
        if (this.children != null && this.children.contains(child)) {
            this.children.remove(child);
            child.setParent(null);
        }
    }

    public void setFirstToken(LexicalToken firstToken) {
        this.firstToken = firstToken;
    }

    public void setLastToken(LexicalToken lastToken) {
        this.lastToken = lastToken;
    }
}

