/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard;

import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.jdt.ui.internal.JdtUiMessages;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.EntitiesList;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.EntitiesSource;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.HibernateJPARefactoring;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.HibernateJPAWizardDataFactory;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardData;
import org.hibernate.eclipse.jdt.ui.internal.jpa.process.wizard.IHibernateJPAWizardParams;

public class HibernateJPAWizard
extends RefactoringWizard
implements IPageChangingListener {
    protected final String wizard_title = JdtUiMessages.AllEntitiesProcessor_header;
    protected IHibernateJPAWizardData data;
    protected IHibernateJPAWizardParams params;

    public HibernateJPAWizard(IHibernateJPAWizardData data, IHibernateJPAWizardParams params) {
        super((Refactoring)new HibernateJPARefactoring(data.getChanges()), 2);
        this.data = data;
        this.params = params;
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor((String)"NEW_WIZARD"));
        this.setWindowTitle(this.wizard_title);
        this.setDefaultPageTitle(this.wizard_title);
    }

    protected void addUserInputPages() {
        StructuredSelection selection = null;
        if (this.data != null && this.data.getSelection2Update() != null) {
            selection = this.data.getSelection2Update();
        }
        if (selection == null) {
            selection = new StructuredSelection();
        }
        String title = JdtUiMessages.EntitiesSource_header;
        EntitiesSource page0 = new EntitiesSource(title, (IStructuredSelection)selection);
        this.addPage((IWizardPage)page0);
        title = JdtUiMessages.EntitiesList_header;
        EntitiesList page1 = new EntitiesList(title, this.data, this.params);
        this.addPage((IWizardPage)page1);
        this.setDefaultPageTitle(page1.getName());
    }

    public HibernateJPARefactoring getHibernateJPARefactoring() {
        return (HibernateJPARefactoring)this.getRefactoring();
    }

    public boolean showWizard() {
        IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = win.getShell();
        RefactoringStarter refactoringStarter = new RefactoringStarter();
        boolean res = refactoringStarter.activate((RefactoringWizard)this, shell, this.wizard_title, 2);
        return res;
    }

    public IWizardPage getStartingPage() {
        if (this.getPages().length <= 0) {
            return null;
        }
        if (this.getPages().length == 1) {
            return this.getPages()[0];
        }
        return this.getPages()[1];
    }

    public void setContainer(IWizardContainer wizardContainer) {
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).removePageChangingListener((IPageChangingListener)this);
        }
        super.setContainer(wizardContainer);
        if (this.getContainer() instanceof WizardDialog) {
            ((WizardDialog)this.getContainer()).addPageChangingListener((IPageChangingListener)this);
        }
    }

    public void handlePageChanging(PageChangingEvent event) {
        Object currentPage = event.getCurrentPage();
        Object targetPage = event.getTargetPage();
        if (targetPage instanceof IWizardPage) {
            this.setDefaultPageTitle(((IWizardPage)targetPage).getName());
        }
        if (currentPage instanceof EntitiesSource && targetPage instanceof EntitiesList) {
            EntitiesSource entitiesSource = (EntitiesSource)((Object)currentPage);
            EntitiesList entitiesList = (EntitiesList)((Object)targetPage);
            IStructuredSelection selection = entitiesSource.getSelection();
            IHibernateJPAWizardData data = HibernateJPAWizardDataFactory.createHibernateJPAWizardData(selection, this.params, entitiesSource.getProcessDepth());
            entitiesList.setData(data);
        }
    }
}

