/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.jdt.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.jdt.ui.internal.ELTransformer;
import org.hibernate.eclipse.jdt.ui.internal.HQLProblem;
import org.jboss.tools.hibernate.spi.IService;

public class HQLDetector
extends ASTVisitor {
    private final IFile resource;
    List<HQLProblem> problems = new ArrayList<HQLProblem>();
    private final ConsoleConfiguration consoleConfiguration;
    private final CompilationUnit cu;

    public HQLDetector(CompilationUnit cu, ConsoleConfiguration consoleConfiguration, IResource resource) {
        this.cu = cu;
        this.consoleConfiguration = consoleConfiguration;
        this.resource = (IFile)resource;
    }

    public boolean visit(NormalAnnotation node) {
        if (node.getTypeName().getFullyQualifiedName().endsWith("NamedQuery")) {
            for (MemberValuePair element : node.values()) {
                Expression value;
                if (!element.getName().getIdentifier().equals("query") || !((value = element.getValue()) instanceof StringLiteral)) continue;
                StringLiteral sl = (StringLiteral)value;
                try {
                    HQLDetector.checkQuery(this.consoleConfiguration, sl.getLiteralValue(), true);
                }
                catch (RuntimeException re) {
                    this.problems.add(new HQLProblem(re.getLocalizedMessage(), true, this.resource, sl.getStartPosition(), sl.getStartPosition() + sl.getLength() - 1, this.getLineNumber(sl.getStartPosition())));
                }
            }
        }
        return super.visit(node);
    }

    private int getLineNumber(int startPosition) {
        if (this.cu != null) {
            return this.cu.getLineNumber(startPosition);
        }
        return 0;
    }

    public boolean visit(MarkerAnnotation node) {
        return super.visit(node);
    }

    public boolean visit(SingleMemberAnnotation node) {
        return super.visit(node);
    }

    public boolean visit(MethodInvocation node) {
        if (node.getName().getIdentifier().equals("createQuery")) {
            Object object;
            if (node.arguments().size() == 1 && (object = node.arguments().get(0)) instanceof StringLiteral) {
                StringLiteral sl = (StringLiteral)object;
                String literalValue = sl.getLiteralValue();
                try {
                    HQLDetector.checkQuery(this.consoleConfiguration, literalValue, true);
                }
                catch (RuntimeException re) {
                    this.problems.add(new HQLProblem(re.getLocalizedMessage(), true, this.resource, sl.getStartPosition(), sl.getStartPosition() + sl.getLength() - 1, this.getLineNumber(sl.getStartPosition())));
                }
            }
            return false;
        }
        return true;
    }

    public static void checkQuery(ConsoleConfiguration cc, String query, boolean allowEL) {
        if (cc != null && cc.isSessionFactoryCreated()) {
            if (allowEL) {
                query = ELTransformer.removeEL(query);
            }
            IService service = cc.getHibernateExtension().getHibernateService();
            service.newHQLQueryPlan(query, false, cc.getSessionFactory());
        }
    }

    public List<HQLProblem> getProblems() {
        return this.problems;
    }
}

