/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.maven.jdt.internal.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.jboss.tools.maven.jdt.internal.jobs.UpdateMavenProjectJob;

public class ExecutePhaseJob
extends WorkspaceJob {
    private final IMavenProjectFacade mavenProjectFacade;
    private final String phase;

    public ExecutePhaseJob(String name, IMavenProjectFacade mavenProjectFacade, String phase) {
        super(name);
        this.mavenProjectFacade = mavenProjectFacade;
        this.phase = phase;
        this.setRule(MavenPlugin.getProjectConfigurationManager().getRule());
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        IMaven maven = MavenPlugin.getMaven();
        MavenExecutionRequest request = maven.createExecutionRequest(monitor);
        request.setPom(this.mavenProjectFacade.getPomFile());
        request.setGoals(Arrays.asList(this.phase));
        MavenExecutionResult result = maven.execute(request, monitor);
        if (result.hasExceptions()) {
            Status errorStatus;
            if (result.getExceptions().size() > 1) {
                ArrayList<Status> errors = new ArrayList<Status>();
                for (Throwable t : result.getExceptions()) {
                    errors.add(this.toStatus(t));
                }
                errorStatus = new MultiStatus(MavenJdtPlugin.PLUGIN_ID, -1, errors.toArray(new IStatus[errors.size()]), "Unable to execute mvn " + this.phase, null);
            } else {
                errorStatus = this.toStatus((Throwable)result.getExceptions().get(0));
            }
            return errorStatus;
        }
        UpdateMavenProjectJob updateProjectJob = new UpdateMavenProjectJob(new IProject[]{this.mavenProjectFacade.getProject()});
        updateProjectJob.schedule();
        return Status.OK_STATUS;
    }

    private Status toStatus(Throwable t) {
        return new Status(4, MavenJdtPlugin.PLUGIN_ID, t.getLocalizedMessage());
    }
}

