/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.seam.text.xpl;

import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.impl.BitSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.jsf.vpe.seam.text.xpl.SeamTextParserTokenTypes;

public class SeamTextParser
extends LLkParser
implements SeamTextParserTokenTypes {
    private Set htmlElements = new HashSet<String>(Arrays.asList("a", "p", "q", "code", "pre", "table", "tr", "td", "th", "ul", "ol", "li", "b", "i", "u", "tt", "del", "em", "hr", "br", "div", "span", "h1", "h2", "h3", "h4", "img", "object", "param", "embed"));
    private Set htmlAttributes = new HashSet<String>(Arrays.asList("src", "href", "lang", "class", "id", "style", "width", "height", "name", "value", "type", "wmode"));
    private StringBuilder mainBuilder;
    private StringBuilder builder = this.mainBuilder = new StringBuilder();
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "DOUBLEQUOTE", "BACKTICK", "WORD", "PUNCTUATION", "ESCAPE", "STAR", "SLASH", "BAR", "HAT", "PLUS", "EQ", "HASH", "TWIDDLE", "UNDERSCORE", "OPEN", "CLOSE", "QUOTE", "GT", "LT", "AMPERSAND", "SPACE", "NEWLINE"};
    public static final BitSet _tokenSet_0 = new BitSet(SeamTextParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(SeamTextParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(SeamTextParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(SeamTextParser.mk_tokenSet_3());

    public String toString() {
        return this.builder.toString();
    }

    private void append(String ... strings) {
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.builder.append(string);
            ++n2;
        }
    }

    private static boolean hasMultiple(String string, char c) {
        return string.indexOf(c) != string.lastIndexOf(c);
    }

    private void validateElement(Token t) throws NoViableAltException {
        if (!this.htmlElements.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void validateAttribute(Token t) throws NoViableAltException {
        if (!this.htmlAttributes.contains(t.getText().toLowerCase())) {
            throw new NoViableAltException(t, null);
        }
    }

    private void beginCapture() {
        this.builder = new StringBuilder();
    }

    private String endCapture() {
        String result = this.builder.toString();
        this.builder = this.mainBuilder;
        return result;
    }

    protected String linkTag(String description, String url) {
        return "<a href=\"" + url + "\" styleClass=\"seamTextLink\">" + description + "</a>";
    }

    protected String macroInclude(String macroName) {
        return "";
    }

    protected SeamTextParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 4);
    }

    protected SeamTextParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public SeamTextParser(TokenStream lexer) {
        this(lexer, 4);
    }

    public SeamTextParser(ParserSharedInputState state) {
        super(state, 4);
        this.tokenNames = _tokenNames;
    }

    public final void startRule() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 25) {
            this.newline();
        }
        switch (this.LA(1)) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 22: 
            case 24: {
                switch (this.LA(1)) {
                    case 13: {
                        this.heading();
                        while (this.LA(1) == 25) {
                            this.newline();
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 22: 
                    case 24: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.text();
                while (this.LA(1) == 13) {
                    this.heading();
                    while (this.LA(1) == 25) {
                        this.newline();
                    }
                    this.text();
                }
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void newline() throws RecognitionException, TokenStreamException {
        Token n = null;
        n = this.LT(1);
        this.match(25);
        this.append(n.getText());
    }

    public final void heading() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 13 && _tokenSet_0.member(this.LA(2))) {
            this.h1();
        } else if (this.LA(1) == 13 && this.LA(2) == 13 && _tokenSet_0.member(this.LA(3))) {
            this.h2();
        } else if (this.LA(1) == 13 && this.LA(2) == 13 && this.LA(3) == 13 && _tokenSet_0.member(this.LA(4))) {
            this.h3();
        } else if (this.LA(1) == 13 && this.LA(2) == 13 && this.LA(3) == 13 && this.LA(4) == 13) {
            this.h4();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        this.newlineOrEof();
    }

    public final void text() throws RecognitionException, TokenStreamException {
        int _cnt17 = 0;
        while (true) {
            if (_tokenSet_1.member(this.LA(1))) {
                switch (this.LA(1)) {
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 24: {
                        this.paragraph();
                        break;
                    }
                    case 5: {
                        this.preformatted();
                        break;
                    }
                    case 4: {
                        this.blockquote();
                        break;
                    }
                    case 14: 
                    case 15: {
                        this.list();
                        break;
                    }
                    case 22: {
                        this.html();
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                while (this.LA(1) == 25) {
                    this.newline();
                }
            } else {
                if (_cnt17 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            ++_cnt17;
        }
    }

    public final void paragraph() throws RecognitionException, TokenStreamException {
        this.append("<p>\n");
        int _cnt20 = 0;
        while (true) {
            if (!_tokenSet_0.member(this.LA(1))) {
                if (_cnt20 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.line();
            this.newlineOrEof();
            ++_cnt20;
        }
        this.append("</p>\n");
        this.newlineOrEof();
    }

    public final void preformatted() throws RecognitionException, TokenStreamException {
        this.match(5);
        this.append("<pre>");
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: {
                    this.word();
                    continue block9;
                }
                case 7: {
                    this.punctuation();
                    continue block9;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.specialChars();
                    continue block9;
                }
                case 18: 
                case 19: {
                    this.moreSpecialChars();
                    continue block9;
                }
                case 4: 
                case 21: 
                case 22: 
                case 23: {
                    this.htmlSpecialChars();
                    continue block9;
                }
                case 24: {
                    this.space();
                    continue block9;
                }
                case 25: {
                    this.newline();
                    continue block9;
                }
            }
            break;
        }
        this.match(5);
        this.append("</pre>");
    }

    public final void blockquote() throws RecognitionException, TokenStreamException {
        this.match(4);
        this.append("<blockquote>\n");
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    continue block8;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: {
                    this.formatted();
                    continue block8;
                }
                case 5: {
                    this.preformatted();
                    continue block8;
                }
                case 25: {
                    this.newline();
                    continue block8;
                }
                case 22: {
                    this.html();
                    continue block8;
                }
                case 14: 
                case 15: {
                    this.list();
                    continue block8;
                }
            }
            break;
        }
        this.match(4);
        this.newlineOrEof();
        this.append("</blockquote>\n");
    }

    public final void list() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 15: {
                this.olist();
                break;
            }
            case 14: {
                this.ulist();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.newlineOrEof();
    }

    public final void html() throws RecognitionException, TokenStreamException {
        this.openTag();
        while (true) {
            if (this.LA(1) == 24 && (this.LA(2) == 10 || this.LA(2) == 21 || this.LA(2) == 24)) {
                this.space();
                continue;
            }
            if (this.LA(1) != 24 || this.LA(2) != 6) break;
            this.space();
            this.attribute();
        }
        switch (this.LA(1)) {
            case 21: {
                this.beforeBody();
                this.body();
                this.closeTagWithBody();
                break;
            }
            case 10: {
                this.closeTagWithNoBody();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void line() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 6: 
            case 7: 
            case 8: 
            case 18: 
            case 24: {
                this.plain();
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: {
                this.formatted();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block11: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    continue block11;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: {
                    this.formatted();
                    continue block11;
                }
                case 5: {
                    this.preformatted();
                    continue block11;
                }
                case 4: {
                    this.quoted();
                    continue block11;
                }
                case 22: {
                    this.html();
                    continue block11;
                }
            }
            break;
        }
    }

    public final void newlineOrEof() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 25: {
                this.newline();
                break;
            }
            case 1: {
                this.match(1);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void plain() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 6: {
                this.word();
                break;
            }
            case 7: {
                this.punctuation();
                break;
            }
            case 8: {
                this.escape();
                break;
            }
            case 24: {
                this.space();
                break;
            }
            default: {
                if (this.LA(1) == 18 && _tokenSet_2.member(this.LA(2))) {
                    this.link();
                    break;
                }
                if (this.LA(1) == 18 && this.LA(2) == 22) {
                    this.macro();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void formatted() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 9: {
                this.bold();
                break;
            }
            case 17: {
                this.underline();
                break;
            }
            case 10: {
                this.italic();
                break;
            }
            case 11: {
                this.monospace();
                break;
            }
            case 12: {
                this.superscript();
                break;
            }
            case 16: {
                this.deleted();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void quoted() throws RecognitionException, TokenStreamException {
        this.match(4);
        this.append("<q>");
        int _cnt65 = 0;
        block10: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    break;
                }
                case 9: {
                    this.bold();
                    break;
                }
                case 17: {
                    this.underline();
                    break;
                }
                case 10: {
                    this.italic();
                    break;
                }
                case 11: {
                    this.monospace();
                    break;
                }
                case 12: {
                    this.superscript();
                    break;
                }
                case 16: {
                    this.deleted();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt65 >= 1) break block10;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt65;
        }
        this.match(4);
        this.append("</q>");
    }

    public final void word() throws RecognitionException, TokenStreamException {
        Token w = null;
        w = this.LT(1);
        this.match(6);
        this.append(w.getText());
    }

    public final void punctuation() throws RecognitionException, TokenStreamException {
        Token p = null;
        p = this.LT(1);
        this.match(7);
        this.append(p.getText());
    }

    public final void specialChars() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token b = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        switch (this.LA(1)) {
            case 9: {
                st = this.LT(1);
                this.match(9);
                this.append(st.getText());
                break;
            }
            case 10: {
                sl = this.LT(1);
                this.match(10);
                this.append(sl.getText());
                break;
            }
            case 11: {
                b = this.LT(1);
                this.match(11);
                this.append(b.getText());
                break;
            }
            case 12: {
                h = this.LT(1);
                this.match(12);
                this.append(h.getText());
                break;
            }
            case 13: {
                p = this.LT(1);
                this.match(13);
                this.append(p.getText());
                break;
            }
            case 14: {
                eq = this.LT(1);
                this.match(14);
                this.append(eq.getText());
                break;
            }
            case 15: {
                hh = this.LT(1);
                this.match(15);
                this.append(hh.getText());
                break;
            }
            case 8: {
                e = this.LT(1);
                this.match(8);
                this.append(e.getText());
                break;
            }
            case 16: {
                t = this.LT(1);
                this.match(16);
                this.append(t.getText());
                break;
            }
            case 17: {
                u = this.LT(1);
                this.match(17);
                this.append(u.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void moreSpecialChars() throws RecognitionException, TokenStreamException {
        Token o = null;
        Token c = null;
        switch (this.LA(1)) {
            case 18: {
                o = this.LT(1);
                this.match(18);
                this.append(o.getText());
                break;
            }
            case 19: {
                c = this.LT(1);
                this.match(19);
                this.append(c.getText());
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void htmlSpecialChars() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 21: {
                this.match(21);
                this.append("&gt;");
                break;
            }
            case 22: {
                this.match(22);
                this.append("&lt;");
                break;
            }
            case 4: {
                this.match(4);
                this.append("&quot;");
                break;
            }
            case 23: {
                this.match(23);
                this.append("&amp;");
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void space() throws RecognitionException, TokenStreamException {
        Token s = null;
        s = this.LT(1);
        this.match(24);
        this.append(s.getText());
    }

    public final void escape() throws RecognitionException, TokenStreamException {
        this.match(8);
        switch (this.LA(1)) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                this.specialChars();
                break;
            }
            case 18: 
            case 19: {
                this.moreSpecialChars();
                break;
            }
            case 20: {
                this.evenMoreSpecialChars();
                break;
            }
            case 4: 
            case 21: 
            case 22: 
            case 23: {
                this.htmlSpecialChars();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void link() throws RecognitionException, TokenStreamException {
        this.match(18);
        this.beginCapture();
        while (_tokenSet_3.member(this.LA(1))) {
            this.plain();
        }
        String text = this.endCapture();
        this.match(14);
        this.match(21);
        this.beginCapture();
        this.attributeValue();
        String link = this.endCapture();
        this.append(this.linkTag(text, link));
        this.match(19);
    }

    public final void macro() throws RecognitionException, TokenStreamException {
        this.match(18);
        this.match(22);
        this.match(14);
        this.beginCapture();
        this.attributeValue();
        String macroName = this.endCapture();
        this.append(this.macroInclude(macroName));
        this.match(19);
    }

    public final void bold() throws RecognitionException, TokenStreamException {
        this.match(9);
        this.append("<b>");
        int _cnt47 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    break;
                }
                case 17: {
                    this.underline();
                    break;
                }
                case 10: {
                    this.italic();
                    break;
                }
                case 11: {
                    this.monospace();
                    break;
                }
                case 12: {
                    this.superscript();
                    break;
                }
                case 16: {
                    this.deleted();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt47 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt47;
        }
        this.match(9);
        this.append("</b>");
    }

    public final void underline() throws RecognitionException, TokenStreamException {
        this.match(17);
        this.append("<u>");
        int _cnt50 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    break;
                }
                case 9: {
                    this.bold();
                    break;
                }
                case 10: {
                    this.italic();
                    break;
                }
                case 11: {
                    this.monospace();
                    break;
                }
                case 12: {
                    this.superscript();
                    break;
                }
                case 16: {
                    this.deleted();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt50 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt50;
        }
        this.match(17);
        this.append("</u>");
    }

    public final void italic() throws RecognitionException, TokenStreamException {
        this.match(10);
        this.append("<i>");
        int _cnt53 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    break;
                }
                case 9: {
                    this.bold();
                    break;
                }
                case 17: {
                    this.underline();
                    break;
                }
                case 11: {
                    this.monospace();
                    break;
                }
                case 12: {
                    this.superscript();
                    break;
                }
                case 16: {
                    this.deleted();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt53 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt53;
        }
        this.match(10);
        this.append("</i>");
    }

    public final void monospace() throws RecognitionException, TokenStreamException {
        Token st = null;
        Token sl = null;
        Token h = null;
        Token p = null;
        Token eq = null;
        Token hh = null;
        Token e = null;
        Token t = null;
        Token u = null;
        this.match(11);
        this.append("<tt>");
        int _cnt56 = 0;
        block17: while (true) {
            switch (this.LA(1)) {
                case 6: {
                    this.word();
                    break;
                }
                case 7: {
                    this.punctuation();
                    break;
                }
                case 24: {
                    this.space();
                    break;
                }
                case 9: {
                    st = this.LT(1);
                    this.match(9);
                    this.append(st.getText());
                    break;
                }
                case 10: {
                    sl = this.LT(1);
                    this.match(10);
                    this.append(sl.getText());
                    break;
                }
                case 12: {
                    h = this.LT(1);
                    this.match(12);
                    this.append(h.getText());
                    break;
                }
                case 13: {
                    p = this.LT(1);
                    this.match(13);
                    this.append(p.getText());
                    break;
                }
                case 14: {
                    eq = this.LT(1);
                    this.match(14);
                    this.append(eq.getText());
                    break;
                }
                case 15: {
                    hh = this.LT(1);
                    this.match(15);
                    this.append(hh.getText());
                    break;
                }
                case 8: {
                    e = this.LT(1);
                    this.match(8);
                    this.append(e.getText());
                    break;
                }
                case 16: {
                    t = this.LT(1);
                    this.match(16);
                    this.append(t.getText());
                    break;
                }
                case 17: {
                    u = this.LT(1);
                    this.match(17);
                    this.append(u.getText());
                    break;
                }
                case 18: 
                case 19: {
                    this.moreSpecialChars();
                    break;
                }
                case 4: 
                case 21: 
                case 22: 
                case 23: {
                    this.htmlSpecialChars();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt56 >= 1) break block17;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt56;
        }
        this.match(11);
        this.append("</tt>");
    }

    public final void superscript() throws RecognitionException, TokenStreamException {
        this.match(12);
        this.append("<sup>");
        int _cnt59 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    break;
                }
                case 9: {
                    this.bold();
                    break;
                }
                case 17: {
                    this.underline();
                    break;
                }
                case 10: {
                    this.italic();
                    break;
                }
                case 11: {
                    this.monospace();
                    break;
                }
                case 16: {
                    this.deleted();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt59 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt59;
        }
        this.match(12);
        this.append("</sup>");
    }

    public final void deleted() throws RecognitionException, TokenStreamException {
        this.match(16);
        this.append("<del>");
        int _cnt62 = 0;
        block9: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    break;
                }
                case 9: {
                    this.bold();
                    break;
                }
                case 17: {
                    this.underline();
                    break;
                }
                case 10: {
                    this.italic();
                    break;
                }
                case 11: {
                    this.monospace();
                    break;
                }
                case 12: {
                    this.superscript();
                    break;
                }
                case 25: {
                    this.newline();
                    break;
                }
                default: {
                    if (_cnt62 >= 1) break block9;
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            ++_cnt62;
        }
        this.match(16);
        this.append("</del>");
    }

    public final void evenMoreSpecialChars() throws RecognitionException, TokenStreamException {
        Token q = null;
        q = this.LT(1);
        this.match(20);
        this.append(q.getText());
    }

    public final void attributeValue() throws RecognitionException, TokenStreamException {
        block7: while (true) {
            switch (this.LA(1)) {
                case 23: {
                    this.match(23);
                    this.append("&amp;");
                    continue block7;
                }
                case 6: {
                    this.word();
                    continue block7;
                }
                case 7: {
                    this.punctuation();
                    continue block7;
                }
                case 24: {
                    this.space();
                    continue block7;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.specialChars();
                    continue block7;
                }
            }
            break;
        }
    }

    public final void h1() throws RecognitionException, TokenStreamException {
        this.match(13);
        this.append("<h1>");
        this.line();
        this.append("</h1>");
    }

    public final void h2() throws RecognitionException, TokenStreamException {
        this.match(13);
        this.match(13);
        this.append("<h2>");
        this.line();
        this.append("</h2>");
    }

    public final void h3() throws RecognitionException, TokenStreamException {
        this.match(13);
        this.match(13);
        this.match(13);
        this.append("<h3>");
        this.line();
        this.append("</h3>");
    }

    public final void h4() throws RecognitionException, TokenStreamException {
        this.match(13);
        this.match(13);
        this.match(13);
        this.match(13);
        this.append("<h4>");
        this.line();
        this.append("</h4>");
    }

    public final void olist() throws RecognitionException, TokenStreamException {
        this.append("<ol>\n");
        int _cnt76 = 0;
        while (true) {
            if (this.LA(1) != 15) {
                if (_cnt76 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.olistLine();
            this.newlineOrEof();
            ++_cnt76;
        }
        this.append("</ol>\n");
    }

    public final void ulist() throws RecognitionException, TokenStreamException {
        this.append("<ul>\n");
        int _cnt80 = 0;
        while (true) {
            if (this.LA(1) != 14) {
                if (_cnt80 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.ulistLine();
            this.newlineOrEof();
            ++_cnt80;
        }
        this.append("</ul>\n");
    }

    public final void olistLine() throws RecognitionException, TokenStreamException {
        this.match(15);
        this.append("<li>");
        this.line();
        this.append("</li>");
    }

    public final void ulistLine() throws RecognitionException, TokenStreamException {
        this.match(14);
        this.append("<li>");
        this.line();
        this.append("</li>");
    }

    public final void openTag() throws RecognitionException, TokenStreamException {
        Token name = null;
        this.match(22);
        name = this.LT(1);
        this.match(6);
        this.validateElement(name);
        this.append("<");
        this.append(name.getText());
    }

    public final void attribute() throws RecognitionException, TokenStreamException {
        Token att = null;
        att = this.LT(1);
        this.match(6);
        while (this.LA(1) == 24) {
            this.space();
        }
        this.match(14);
        while (this.LA(1) == 24) {
            this.space();
        }
        this.match(4);
        this.validateAttribute(att);
        this.append(att.getText());
        this.append("=\"");
        this.attributeValue();
        this.match(4);
        this.append("\"");
    }

    public final void beforeBody() throws RecognitionException, TokenStreamException {
        this.match(21);
        this.append(">");
    }

    public final void body() throws RecognitionException, TokenStreamException {
        block8: while (true) {
            switch (this.LA(1)) {
                case 6: 
                case 7: 
                case 8: 
                case 18: 
                case 24: {
                    this.plain();
                    continue block8;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 16: 
                case 17: {
                    this.formatted();
                    continue block8;
                }
                case 5: {
                    this.preformatted();
                    continue block8;
                }
                case 4: {
                    this.quoted();
                    continue block8;
                }
                case 14: 
                case 15: {
                    this.list();
                    continue block8;
                }
                case 25: {
                    this.newline();
                    continue block8;
                }
            }
            if (this.LA(1) != 22 || this.LA(2) != 6) break;
            this.html();
        }
    }

    public final void closeTagWithBody() throws RecognitionException, TokenStreamException {
        Token name = null;
        this.match(22);
        this.match(10);
        name = this.LT(1);
        this.match(6);
        this.match(21);
        this.append("</");
        this.append(name.getText());
        this.append(">");
    }

    public final void closeTagWithNoBody() throws RecognitionException, TokenStreamException {
        this.match(10);
        this.match(21);
        this.append("/>");
    }

    private static final long[] mk_tokenSet_0() {
        long[] lArray = new long[2];
        lArray[0] = 17244096L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] lArray = new long[2];
        lArray[0] = 21487600L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] lArray = new long[2];
        lArray[0] = 17056192L;
        long[] data = lArray;
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] lArray = new long[2];
        lArray[0] = 17039808L;
        long[] data = lArray;
        return data;
    }
}

