/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.seam.template;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.jboss.tools.jsf.vpe.seam.SeamTemplatesActivator;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.util.XmlUtil;
import org.mozilla.interfaces.nsIDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SeamUtil {
    public static final String ATTR_TEMPLATE = "template";
    public static final String ATTR_STYLE_CLASS = "styleClass";
    public static final String ATTR_URL = "url";
    public static final String SEAM_ATTR_MARGINS = "margins";
    public static final String[] POSSIBLE_ALIGNS = new String[]{"left", "right", "center", "justify", "justifyall"};
    public static final String SEAM_ATTR_ALIGNMENT = "alignment";
    public static final String SEAM_DIV_BASIC_STYLE_VALUE = "line-height: 142.0pt; font-family: unknown;";
    public static final String SEAM_SPAN_BASIC_STYLE_VALUE = "font-family: unknown;";
    public static final String SEAM_ATTR_HORIZONAL_ALIGNMENT = "horizontalAlignment";
    public static final String SEAM_ATTR_VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String SEAM_ATTR_WIDTH_PERCENTAGE = "widthPercentage";
    public static final String SEAM_ATTR_TYPE_ID_VALUE_PDF_TITLE = "pdf-title";
    public static final String SEAM_ATTR_TYPE_ID = "TYPEID";
    public static final String SEAM_ATTR_TYPE_ID_VALUE_PDF_FOOTER = "pdf-footer";

    public static Node getParentByName(VpePageContext pageContext, Node sourceNode, String parentName) {
        Node parentNode = sourceNode.getParentNode();
        VpeTemplateManager templateManager = VpeTemplateManager.getInstance();
        while (parentNode != null) {
            if (parentName.equals(templateManager.getTemplateName(pageContext, parentNode))) {
                return parentNode;
            }
            parentNode = parentNode.getParentNode();
        }
        return null;
    }

    public static void setAlignment(Element sourceElement, nsIDOMElement visualElement) {
        if (sourceElement.hasAttribute(SEAM_ATTR_ALIGNMENT)) {
            String align = sourceElement.getAttribute(SEAM_ATTR_ALIGNMENT);
            visualElement.setAttribute("align", "left");
            int i = 0;
            while (i < POSSIBLE_ALIGNS.length) {
                if (POSSIBLE_ALIGNS[i].equalsIgnoreCase(align)) {
                    if (POSSIBLE_ALIGNS[i].equalsIgnoreCase("justifyall")) {
                        visualElement.setAttribute("align", "justify");
                        return;
                    }
                    visualElement.setAttribute("align", POSSIBLE_ALIGNS[i]);
                    return;
                }
                ++i;
            }
        }
    }

    public static void getChildsByName(VpePageContext pageContext, Node sourceNode, String childName, List<Node> childNodes) {
        NodeList children = sourceNode.getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node childNode = children.item(i);
                String childSourcePrefix = childNode.getPrefix();
                if (childSourcePrefix == null) {
                    childSourcePrefix = "";
                }
                List taglibs = XmlUtil.getTaglibsForNode((Node)childNode, (VpePageContext)pageContext);
                TaglibData sourceNodeTaglib = XmlUtil.getTaglibForPrefix((String)childSourcePrefix, (List)taglibs);
                String childNodeName = childNode.getNodeName();
                if (sourceNodeTaglib != null) {
                    String sourceNodeUri = sourceNodeTaglib.getUri();
                    String templateTaglibPrefix = VpeTemplateManager.getInstance().getTemplateTaglibPrefix(sourceNodeUri);
                    if (templateTaglibPrefix != null) {
                        childNodeName = String.valueOf(templateTaglibPrefix) + ":" + childNode.getLocalName();
                    }
                }
                if (childNodeName.equals(childName)) {
                    childNodes.add(childNode);
                }
                SeamUtil.getChildsByName(pageContext, childNode, childName, childNodes);
                ++i;
            }
        }
    }

    public static Node[] getChildsByName(VpePageContext pageContext, Node sourceNode, String childName) {
        ArrayList<Node> footerNodes = new ArrayList<Node>(0);
        SeamUtil.getChildsByName(pageContext, sourceNode, childName, footerNodes);
        return footerNodes.toArray(new Node[0]);
    }

    public static String getStyleAttr(Node sourceFontNode) {
        if (sourceFontNode == null || !sourceFontNode.getNodeName().endsWith("font")) {
            return null;
        }
        String styleAttrValue = String.valueOf(SeamUtil.getFontFamily(sourceFontNode)) + SeamUtil.getSize(sourceFontNode) + SeamUtil.parseFontStyleValue(sourceFontNode);
        return styleAttrValue;
    }

    private static String parseFontStyleValue(Node sourceFontNode) {
        StringBuilder styleAttrValue = new StringBuilder();
        Element sourceFontElement = (Element)sourceFontNode;
        if (sourceFontElement.hasAttribute("style")) {
            int lineThroughPos;
            int underLinePos;
            int italicPos;
            String stringValueToParse = sourceFontElement.getAttribute("style");
            int boldPos = stringValueToParse.indexOf("bold");
            if (boldPos != -1) {
                styleAttrValue.append(" font-weight : bold;");
            }
            if ((italicPos = stringValueToParse.indexOf("italic")) != -1) {
                styleAttrValue.append(" font-style : italic;");
            }
            if ((underLinePos = stringValueToParse.indexOf("underline")) != -1) {
                styleAttrValue.append(" text-decoration : underline;");
            }
            if ((lineThroughPos = stringValueToParse.indexOf("line-through")) != -1) {
                styleAttrValue.append(" text-decoration : line-through;");
            }
        }
        return styleAttrValue.toString();
    }

    private static String getFontFamily(Node sourceFontNode) {
        String fontFamily = "unknown";
        Element sourceFontElement = (Element)sourceFontNode;
        if (sourceFontElement.hasAttribute("name")) {
            String stringName;
            fontFamily = stringName = sourceFontElement.getAttribute("name");
        }
        return " font-family : " + fontFamily + ";";
    }

    private static String getSize(Node sourceFontNode) {
        Element sourceFontElement = (Element)sourceFontNode;
        if (sourceFontElement.hasAttribute("size")) {
            String stringSizeAttr;
            block4: {
                try {
                    stringSizeAttr = sourceFontElement.getAttribute("size");
                    int intSize = Integer.parseInt(stringSizeAttr);
                    if (intSize >= 0) break block4;
                    return "";
                }
                catch (NumberFormatException numberFormatException) {
                    return "";
                }
            }
            return " font-size : " + stringSizeAttr + "pt;";
        }
        return "";
    }

    public static String getAbsoluteResourcePath(String resourcePathInPlugin) {
        String pluginPath = SeamTemplatesActivator.getPluginResourcePath();
        Path pluginFile = new Path(pluginPath);
        File file = pluginFile.append(resourcePathInPlugin).toFile();
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        throw new IllegalArgumentException("Can't get path for " + resourcePathInPlugin);
    }

    public static void setImg(nsIDOMElement img, String fileImageName) {
        img.setAttribute("src", "file://" + SeamUtil.getAbsoluteResourcePath(fileImageName).replace('\\', '/'));
    }
}

