/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.seam.template;

import java.util.ArrayList;
import org.jboss.tools.jsf.vpe.seam.template.SeamPdfAbstractTemplate;
import org.jboss.tools.jsf.vpe.seam.template.SeamUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SeamPdfTableTemplate
extends SeamPdfAbstractTemplate {
    private nsIDOMElement visualElement;
    private Element sourceElement;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        this.sourceElement = (Element)sourceNode;
        nsIDOMElement visualNode = visualDocument.createElement("div");
        nsIDOMElement tableNode = visualDocument.createElement("table");
        nsIDOMElement visualTable = (nsIDOMElement)XPCOM.queryInterface((nsISupports)tableNode, nsIDOMElement.class);
        visualNode.appendChild((nsIDOMNode)tableNode);
        this.visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        visualTable.setAttribute("width", this.getWidthPerc(this.sourceElement));
        visualTable.setAttribute("align", this.getAlignment(this.sourceElement));
        visualTable.setAttribute("cellspacing", "0px");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)this.visualElement);
        VpeChildrenInfo childrenInfo = new VpeChildrenInfo(this.visualElement);
        Node[] cells = SeamUtil.getChildsByName(pageContext, sourceNode, "p:cell");
        if (cells != null) {
            int i = 0;
            while (i < cells.length) {
                Node parentNode = SeamUtil.getParentByName(pageContext, cells[i], "p:table");
                if (parentNode != null && parentNode == sourceNode) {
                    childrenInfo.addSourceChild(cells[i]);
                }
                ++i;
            }
        }
        creationData.addChildrenInfo(childrenInfo);
        return creationData;
    }

    public void validate(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        this.setColumns(pageContext, sourceNode, visualDocument, data);
    }

    private int getNumberOfColumns(Node sourceTableNode) {
        int columnsNumber = 1;
        Element sourceTableElement = (Element)sourceTableNode;
        String columnsAttrName = "columns";
        if (sourceTableElement.hasAttribute(columnsAttrName)) {
            try {
                String columnsNumberString = sourceTableElement.getAttribute(columnsAttrName);
                columnsNumber = Integer.parseInt(columnsNumberString);
                if (columnsNumber < 1) {
                    columnsNumber = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                columnsNumber = 1;
            }
        } else {
            columnsNumber = 1;
        }
        return columnsNumber;
    }

    /*
     * Unable to fully structure code
     */
    private void setColumns(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, VpeCreationData data) {
        numberOfColumns = this.getNumberOfColumns(sourceNode);
        visualTable = ((nsIDOMElement)XPCOM.queryInterface((nsISupports)data.getNode(), nsIDOMElement.class)).getElementsByTagName("table").item(0L);
        visualCells = this.getCells(data.getNode());
        if (visualCells == null) {
            return;
        }
        cellsLength = visualCells.length;
        if (cellsLength == 0) {
            return;
        }
        trVisualNode = visualDocument.createElement("tr");
        visualTable.appendChild((nsIDOMNode)trVisualNode);
        posCounter = 0;
        i = 0;
        while (i < cellsLength) {
            visualCell = visualCells[i];
            parentNode = null;
            if (visualCell != null) {
                parentNode = visualCell.getParentNode();
            }
            if (parentNode == null) ** GOTO lbl44
            parentNode.removeChild(visualCell);
            trVisualNode.appendChild(visualCell);
            colspanValue = this.getColspanValue(visualCell);
            if (colspanValue <= 1 || ++posCounter % numberOfColumns == 0) ** GOTO lbl44
            posInRow = posCounter - 1;
            numEndCells = numberOfColumns - posInRow;
            if (numEndCells <= colspanValue) {
                colspanValue = numEndCells;
                trVisualNode = visualDocument.createElement("tr");
                visualTable.appendChild((nsIDOMNode)trVisualNode);
                posCounter = 0;
            } else {
                j = 0;
                while (j < numberOfColumns - colspanValue) {
                    visualCell = visualCells[++i];
                    trVisualNode.appendChild(visualCell);
                    ++j;
                }
                i -= numberOfColumns - colspanValue;
                posCounter += colspanValue - 1;
lbl44:
                // 3 sources

                if (posCounter % numberOfColumns == 0 && i + 1 != cellsLength) {
                    trVisualNode = visualDocument.createElement("tr");
                    visualTable.appendChild((nsIDOMNode)trVisualNode);
                    posCounter = 0;
                }
            }
            ++i;
        }
        if (trVisualNode.getChildNodes().getLength() != (long)numberOfColumns) {
            trVisualNode.getParentNode().removeChild((nsIDOMNode)trVisualNode);
        }
    }

    private String getWidthPerc(Element sourceElement) {
        String width = "100%";
        if (sourceElement.hasAttribute("widthPercentage")) {
            try {
                width = sourceElement.getAttribute("widthPercentage");
                int intWidth = Integer.parseInt(width);
                width = intWidth < 1 || intWidth > 100 ? "100%" : String.valueOf(Integer.toString(intWidth)) + "%";
            }
            catch (NumberFormatException numberFormatException) {
                width = "100%";
            }
        }
        return width;
    }

    private String getAlignment(Element sourceElement) {
        if (sourceElement.hasAttribute("horizontalAlignment")) {
            String align = sourceElement.getAttribute("horizontalAlignment");
            int i = 0;
            while (i < SeamUtil.POSSIBLE_ALIGNS.length) {
                if (SeamUtil.POSSIBLE_ALIGNS[i].equalsIgnoreCase(align)) {
                    if (SeamUtil.POSSIBLE_ALIGNS[i].equalsIgnoreCase("justifyall")) {
                        return "justify";
                    }
                    return align;
                }
                ++i;
            }
        }
        return "center";
    }

    private int getColspanValue(nsIDOMNode visualNode) {
        int colspan = 1;
        nsIDOMElement visualElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        if (visualElement.hasAttribute("colspan")) {
            try {
                String colspanString = visualElement.getAttribute("colspan");
                colspan = Integer.parseInt(colspanString);
                if (colspan < 1) {
                    colspan = 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                colspan = 1;
            }
        }
        return colspan;
    }

    private nsIDOMNode[] getCells(nsIDOMNode visualTable) {
        nsIDOMNodeList children = visualTable.getChildNodes();
        if (children == null) {
            return null;
        }
        ArrayList<nsIDOMElement> childrenList = new ArrayList<nsIDOMElement>();
        int i = 0;
        while ((long)i < children.getLength()) {
            nsIDOMNode child = children.item((long)i);
            if (child.getNodeType() == 1 && "TD".equals(child.getNodeName())) {
                childrenList.add((nsIDOMElement)XPCOM.queryInterface((nsISupports)child, nsIDOMElement.class));
            }
            ++i;
        }
        return (nsIDOMNode[])childrenList.toArray(new nsIDOMElement[0]);
    }
}

