/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.proxy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.jboss.tools.hibernate.proxy.ColumnProxy;
import org.jboss.tools.hibernate.proxy.TableProxy;
import org.jboss.tools.hibernate.spi.IColumn;
import org.jboss.tools.hibernate.spi.IForeignKey;
import org.jboss.tools.hibernate.spi.ITable;

public class ForeignKeyProxy
implements IForeignKey {
    private ForeignKey target = null;
    private ITable referencedTable = null;
    private HashSet<IColumn> columns = null;
    private List<IColumn> referencedColumns = null;

    public ForeignKeyProxy(ForeignKey foreignKey) {
        this.target = foreignKey;
    }

    public ITable getReferencedTable() {
        if (this.referencedTable == null && this.target.getReferencedTable() != null) {
            this.referencedTable = new TableProxy(this.target.getReferencedTable());
        }
        return this.referencedTable;
    }

    public Iterator<IColumn> columnIterator() {
        if (this.columns == null) {
            this.initializeColumns();
        }
        return this.columns.iterator();
    }

    private void initializeColumns() {
        this.columns = new HashSet();
        Iterator origin = this.target.columnIterator();
        while (origin.hasNext()) {
            this.columns.add(new ColumnProxy((Column)origin.next()));
        }
    }

    public boolean isReferenceToPrimaryKey() {
        return this.target.isReferenceToPrimaryKey();
    }

    public List<IColumn> getReferencedColumns() {
        if (this.referencedColumns == null) {
            this.initializeReferencedColumns();
        }
        return this.referencedColumns;
    }

    private void initializeReferencedColumns() {
        this.referencedColumns = new ArrayList<IColumn>();
        for (Object column : this.target.getReferencedColumns()) {
            this.referencedColumns.add(new ColumnProxy((Column)column));
        }
    }

    public boolean containsColumn(IColumn column) {
        assert (column instanceof ColumnProxy);
        return this.target.containsColumn(((ColumnProxy)column).getTarget());
    }
}

