/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.iterator.TransformationIterator;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.orm.OrmTable;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmTable;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernateTable;
import org.jboss.tools.hibernate.jpt.core.internal.context.orm.HibernateOrmTable;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.spi.INamingStrategy;

public class HibernateOrmTableImpl
extends GenericOrmTable
implements HibernateOrmTable {
    protected String defaultDBTableName;

    public HibernateOrmTableImpl(OrmTable.ParentAdapter owner) {
        super(owner);
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.defaultDBTableName = this.buildDefaultDBTableName();
    }

    public void update() {
        super.update();
        this.setDefaultDBTableName(this.buildDefaultDBTableName());
    }

    public org.eclipse.jpt.jpa.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    protected void setDefaultDBTableName(String name) {
        String old = this.defaultDBTableName;
        this.defaultDBTableName = name;
        this.firePropertyChanged("defaultDBName", old, name);
    }

    protected String buildDefaultDBTableName() {
        if (this.getDefaultName() != null) {
            INamingStrategy ns = this.getJpaProject().getNamingStrategy();
            if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
                try {
                    return ns.classToTableName(this.getDefaultName());
                }
                catch (Exception e) {
                    IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                    HibernateJptPlugin.logException(m.getText(), e);
                }
            }
        }
        return this.getDefaultName();
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName() != null ? this.getSpecifiedDBTableName() : this.getDefaultDBTableName();
    }

    @Override
    public String getDefaultDBTableName() {
        return this.defaultDBTableName;
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    protected Iterator<String> tableNames(Iterator<Table> tables) {
        return new TransformationIterator(tables, (Transformer)new Transformer<Table, String>(){

            public String transform(Table t) {
                if (t instanceof HibernateTable) {
                    return ((HibernateTable)t).getDBTableName();
                }
                return t.getName();
            }
        });
    }

    protected void validateAgainstDatabase(List<IMessage> messages) {
        if (!this.catalogIsResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.TABLE_UNRESOLVED_CATALOG, new Object[]{new String[]{this.getCatalog(), this.getDBTableName()}, this.getCatalogValidationTextRange()}));
            return;
        }
        if (!this.schemaIsResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.TABLE_UNRESOLVED_SCHEMA, new Object[]{new String[]{this.getSchema(), this.getDBTableName()}, this.getSchemaValidationTextRange()}));
            return;
        }
        if (!this.isResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.TABLE_UNRESOLVED_NAME, new Object[]{new String[]{this.getDBTableName()}, this.getNameValidationTextRange()}));
            return;
        }
    }
}

