/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.common.core.internal.utility.EmptyTextRange;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.jboss.tools.hibernate.jpt.core.internal.context.HibernatePersistenceUnit;
import org.jboss.tools.hibernate.jpt.core.internal.context.Messages;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaType;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JavaTypeDef;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.JpaUtil;
import org.jboss.tools.hibernate.jpt.core.internal.resource.java.TypeAnnotation;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.spi.IService;
import org.jboss.tools.hibernate.spi.ITypeFactory;

public class TypeImpl
extends AbstractJavaContextModel<JpaContextModel>
implements JavaType,
Messages {
    private TypeAnnotation annotation;
    private String type;
    private ITypeFactory typeFactory;

    public TypeImpl(JpaContextModel parent, TypeAnnotation annotation, IService service) {
        super(parent);
        this.annotation = annotation;
        this.typeFactory = service.newTypeFactory();
    }

    public void synchronizeWithResourceModel() {
        this.setType_(this.annotation.getType());
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String name) {
        String old = this.type;
        this.type = name;
        this.getTypeAnnotation().setType(name);
        this.firePropertyChanged("type", old, name);
    }

    public void setType_(String name) {
        String old = this.type;
        this.type = name;
        this.firePropertyChanged("type", old, name);
    }

    @Override
    public TypeAnnotation getTypeAnnotation() {
        return this.annotation;
    }

    public TextRange getValidationTextRange() {
        return this.annotation.getTextRange();
    }

    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateType(messages, reporter);
    }

    public HibernatePersistenceUnit getPersistenceUnit() {
        return (HibernatePersistenceUnit)((JpaContextModel)this.getParent()).getPersistenceUnit();
    }

    @Override
    public TextRange getTypeTextRange() {
        return this.annotation.getTypeTextRange();
    }

    public Iterable<String> getCompletionProposals(int pos) {
        Iterable result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        TextRange typeRange = this.getTypeTextRange();
        if (typeRange != null && typeRange.touches(pos)) {
            return IterableTools.iterable((Object[])this.getPersistenceUnit().uniqueTypeDefNames());
        }
        return null;
    }

    protected void validateType(List<IMessage> messages, IReporter reporter) {
        if (this.type != null) {
            TextRange range;
            TextRange textRange = range = this.getTypeTextRange() == null ? EmptyTextRange.instance() : this.getTypeTextRange();
            if (this.type.trim().length() == 0) {
                messages.add(HibernateJpaValidationMessage.buildMessage(1, "TYPE_CANT_BE_EMPTY", (JpaModel)this, range));
            } else if (this.typeFactory.getBasicType(this.type) == null && !this.getPersistenceUnit().hasTypeDef(this.type)) {
                IType lwType = null;
                try {
                    lwType = this.getJpaProject().getJavaProject().findType(this.type);
                    if (lwType == null || !lwType.isClass()) {
                        messages.add(HibernateJpaValidationMessage.buildMessage(1, "TYPE_CLASS_NOT_FOUND", new String[]{this.type}, (JpaModel)this, range));
                    } else {
                        Boolean isImplements = JpaUtil.isTypeImplementsOneOfInterfaces(this.getJpaProject().getJavaProject(), lwType, JavaTypeDef.POSSIBLE_INTERFACES);
                        if (isImplements == null) {
                            messages.add(HibernateJpaValidationMessage.buildMessage(1, "INCONSISTENT_TYPE_HIERARCHY", new String[]{this.type}, (JpaModel)this, range));
                        } else if (!isImplements.booleanValue()) {
                            messages.add(HibernateJpaValidationMessage.buildMessage(1, "USER_TYPE_INTERFACE", new String[]{this.type}, (JpaModel)this, range));
                        }
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }
}

