/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.jpt.core.internal.context.java;

import java.util.List;
import org.eclipse.jpt.jpa.core.JpaModel;
import org.eclipse.jpt.jpa.core.context.java.JavaTable;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaTable;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJpaProject;
import org.jboss.tools.hibernate.jpt.core.internal.HibernateJptPlugin;
import org.jboss.tools.hibernate.jpt.core.internal.context.java.HibernateJavaTable;
import org.jboss.tools.hibernate.jpt.core.internal.validation.HibernateJpaValidationMessage;
import org.jboss.tools.hibernate.spi.INamingStrategy;

public class HibernateJavaTableImpl
extends GenericJavaTable
implements HibernateJavaTable {
    protected String defaultDBTableName;

    public HibernateJavaTableImpl(JavaTable.ParentAdapter parent) {
        super(parent);
    }

    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.defaultDBTableName = this.buildDefaultDBTableName();
    }

    public void update() {
        super.update();
        this.setDefaultDBTableName(this.buildDefaultDBTableName());
    }

    public HibernateJpaProject getJpaProject() {
        return (HibernateJpaProject)super.getJpaProject();
    }

    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getDBTableName());
    }

    @Override
    public String getDBTableName() {
        return this.getSpecifiedDBTableName() != null ? this.getSpecifiedDBTableName() : this.getDefaultDBTableName();
    }

    @Override
    public String getSpecifiedDBTableName() {
        if (this.getSpecifiedName() == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.tableName(this.getSpecifiedName());
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getName();
    }

    protected String buildDefaultDBTableName() {
        if (this.getDefaultName() == null) {
            return null;
        }
        INamingStrategy ns = this.getJpaProject().getNamingStrategy();
        if (this.getJpaProject().isNamingStrategyEnabled() && ns != null) {
            try {
                return ns.classToTableName(this.getDefaultName());
            }
            catch (Exception e) {
                IMessage m = HibernateJpaValidationMessage.buildMessage(1, "NAMING_STRATEGY_EXCEPTION", (JpaModel)this);
                HibernateJptPlugin.logException(m.getText(), e);
            }
        }
        return this.getDefaultName();
    }

    @Override
    public String getDefaultDBTableName() {
        return this.defaultDBTableName;
    }

    protected void setDefaultDBTableName(String name) {
        String old = this.defaultDBTableName;
        this.defaultDBTableName = name;
        this.firePropertyChanged("defaultDBName", old, name);
    }

    protected void validateAgainstDatabase(List<IMessage> messages) {
        if (!this.catalogIsResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.TABLE_UNRESOLVED_CATALOG, new Object[]{new String[]{this.getCatalog(), this.getDBTableName()}, this.getCatalogValidationTextRange()}));
            return;
        }
        if (!this.schemaIsResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.TABLE_UNRESOLVED_SCHEMA, new Object[]{new String[]{this.getSchema(), this.getDBTableName()}, this.getSchemaValidationTextRange()}));
            return;
        }
        if (!this.isResolved()) {
            messages.add(this.buildValidationMessage(JptJpaCoreValidationMessages.TABLE_UNRESOLVED_NAME, new Object[]{new String[]{this.getDBTableName()}, this.getNameValidationTextRange()}));
        }
    }
}

