/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.wst;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;
import org.jboss.tools.livereload.core.internal.server.jetty.JettyServerRunner;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadProxyServer;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadServer;
import org.jboss.tools.livereload.core.internal.service.EventService;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientRefreshFilter;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientRefreshedEvent;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientRefreshingEvent;
import org.jboss.tools.livereload.core.internal.service.ServerLifeCycleListener;
import org.jboss.tools.livereload.core.internal.service.ServerStartedAndStoppedFilter;
import org.jboss.tools.livereload.core.internal.service.ServerStartedEvent;
import org.jboss.tools.livereload.core.internal.service.ServerStoppedEvent;
import org.jboss.tools.livereload.core.internal.service.Subscriber;
import org.jboss.tools.livereload.core.internal.service.WorkspaceResourceChangedListener;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.WSTUtils;

public class LiveReloadServerBehaviour
extends ServerBehaviourDelegate
implements Subscriber {
    public static final String PROXY_PORTS = "proxy_ports";
    private LiveReloadServer liveReloadServer;
    private final Map<IServer, LiveReloadProxyServer> proxyServers = new HashMap<IServer, LiveReloadProxyServer>();
    private final Map<IServer, JettyServerRunner> proxyRunners = new HashMap<IServer, JettyServerRunner>();
    private WorkspaceResourceChangedListener resourceChangeListener;
    private ServerLifeCycleListener serverLifeCycleListener;
    private JettyServerRunner liveReloadServerRunnable;
    private int websocketPort;

    protected void initialize(IProgressMonitor monitor) {
        super.initialize(monitor);
        EventService.getInstance().subscribe(this, new ServerStartedAndStoppedFilter());
        EventService.getInstance().subscribe(this, new LiveReloadClientRefreshFilter());
    }

    public void dispose() {
        super.dispose();
        try {
            if (this.liveReloadServer != null) {
                this.liveReloadServer.stop();
                Iterator<Map.Entry<IServer, JettyServerRunner>> iterator = this.proxyRunners.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<IServer, JettyServerRunner> entry = iterator.next();
                    JettyServerRunner runner = entry.getValue();
                    JettyServerRunner.stop(runner);
                    iterator.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IStatus canPublish() {
        return Status.OK_STATUS;
    }

    public IStatus canStart(String launchMode) {
        return Status.OK_STATUS;
    }

    public void startServer() throws CoreException {
        try {
            this.setServerStarting();
            IServer server = this.getServer();
            this.websocketPort = server.getAttribute("org.jboss.tools.livereload.core.websocket_port", 35729);
            if (!this.isProxyEnabled()) {
                this.setProxyEnabled(true);
            }
            boolean allowRemoteConnections = this.isRemoteConnectionsAllowed();
            boolean enableScriptInjection = this.isScriptInjectionEnabled();
            this.liveReloadServer = new LiveReloadServer(server.getName(), server.getHost(), this.websocketPort, true, allowRemoteConnections, enableScriptInjection);
            this.liveReloadServerRunnable = JettyServerRunner.start(this.liveReloadServer);
            if (!this.liveReloadServerRunnable.isSuccessfullyStarted()) {
                this.setServerStopped();
            } else {
                this.addWorkspaceResourceChangeListener();
                this.addServerLifeCycleListener();
                this.setServerStarted();
            }
        }
        catch (TimeoutException e) {
            this.setServerStopped();
            throw new CoreException((IStatus)new Status(4, "org.jboss.tools.livereload.core", e.getMessage(), (Throwable)e));
        }
    }

    public boolean isScriptInjectionEnabled() {
        return this.getServer().getAttribute("org.jboss.tools.livereload.core.enable_script_injection", false);
    }

    public void setScriptInjectionAllowed(boolean allowScriptInjection) throws CoreException {
        this.configureServerAttribute("org.jboss.tools.livereload.core.enable_script_injection", allowScriptInjection);
    }

    public boolean isRemoteConnectionsAllowed() {
        return this.getServer().getAttribute("org.jboss.tools.livereload.core.allow_remote_connections", false);
    }

    public void setRemoteConnectionsAllowed(boolean allowRemoteConnections) throws CoreException {
        this.configureServerAttribute("org.jboss.tools.livereload.core.allow_remote_connections", allowRemoteConnections);
    }

    public boolean isProxyEnabled() {
        return this.getServer().getAttribute("org.jboss.tools.livereload.core.enable_proxy_server", false);
    }

    public void setProxyEnabled(boolean enableProxy) throws CoreException {
        this.configureServerAttribute("org.jboss.tools.livereload.core.enable_proxy_server", enableProxy);
    }

    private void configureServerAttribute(String attributeName, boolean attributeValue) throws CoreException {
        IServerWorkingCopy workingCopy = this.getServer().createWorkingCopy();
        workingCopy.setAttribute(attributeName, attributeValue);
        workingCopy.save(true, (IProgressMonitor)new NullProgressMonitor());
    }

    public IStatus canStop() {
        if (this.getServer().getServerState() == 1 || this.getServer().getServerState() == 2) {
            return Status.OK_STATUS;
        }
        return Status.CANCEL_STATUS;
    }

    public void stop(boolean force) {
        this.setServerStopping();
        JettyServerRunner.stop(this.liveReloadServerRunnable);
        this.removeWorkspaceResourceChangeListener();
        this.removeServerLifeCycleListener();
        this.setServerStopped();
    }

    @Override
    public String getId() {
        return LiveReloadServer.class.getSimpleName();
    }

    public LiveReloadServer getLiveReloadServer() {
        return this.liveReloadServer;
    }

    private void addServerLifeCycleListener() {
        this.serverLifeCycleListener = new ServerLifeCycleListener(this.getServer());
        ServerCore.addServerLifecycleListener((IServerLifecycleListener)this.serverLifeCycleListener);
    }

    public ServerLifeCycleListener getServerLifeCycleListener() {
        return this.serverLifeCycleListener;
    }

    private void removeServerLifeCycleListener() {
        if (this.serverLifeCycleListener != null) {
            ServerCore.removeServerLifecycleListener((IServerLifecycleListener)this.serverLifeCycleListener);
            this.serverLifeCycleListener.stop();
        }
    }

    private void addWorkspaceResourceChangeListener() {
        this.resourceChangeListener = new WorkspaceResourceChangedListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeListener, 16);
    }

    private void removeWorkspaceResourceChangeListener() {
        if (this.resourceChangeListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeListener);
        }
    }

    @Override
    public void inform(EventObject event) {
        if (!this.isProxyEnabled()) {
            return;
        }
        if (event instanceof ServerStartedEvent) {
            this.startProxy(((ServerStartedEvent)event).getServer());
        } else if (event instanceof ServerStoppedEvent) {
            this.stopProxy(((ServerStoppedEvent)event).getServer());
        } else if (event instanceof LiveReloadClientRefreshingEvent) {
            this.setServerPublishState(2);
        } else if (event instanceof LiveReloadClientRefreshedEvent) {
            this.setServerPublishState(1);
        }
    }

    private void startProxy(IServer startedServer) {
        if (this.proxyServers.containsKey(startedServer)) {
            LiveReloadProxyServer proxyServer = this.proxyServers.get(startedServer);
            try {
                proxyServer.start();
            }
            catch (Exception e) {
                Logger.error("Failed to start LiveReload Proxy on port " + proxyServer.getConnectors()[0].getPort() + " for server " + startedServer.getName(), e);
            }
        } else {
            int targetPort = WSTUtils.getWebPort(startedServer);
            if (targetPort != -1) {
                try {
                    boolean allowRemoteConnections = this.isRemoteConnectionsAllowed();
                    boolean enableScriptInjection = this.isScriptInjectionEnabled();
                    String proxyHost = this.getProxyHost();
                    int proxyPort = this.getProxyPort(startedServer);
                    LiveReloadProxyServer proxyServer = new LiveReloadProxyServer(proxyHost, proxyPort, startedServer.getHost(), targetPort, this.websocketPort, allowRemoteConnections, enableScriptInjection);
                    this.proxyServers.put(startedServer, proxyServer);
                    JettyServerRunner proxyRunner = JettyServerRunner.start(proxyServer);
                    this.proxyRunners.put(startedServer, proxyRunner);
                }
                catch (Exception e) {
                    Logger.error("Failed to create or start LiveReload proxy for server " + startedServer.getName(), e);
                }
            }
        }
    }

    private String getProxyHost() {
        return this.getServer().getHost();
    }

    private int getProxyPort(IServer startedServer) throws CoreException {
        int port;
        String startedServerId;
        IServer liveReloadServer = this.getServer();
        Map proxyPorts = liveReloadServer.getAttribute(PROXY_PORTS, new HashMap());
        if (proxyPorts.containsKey(startedServerId = startedServer.getId()) && !SocketUtil.isPortInUse((int)(port = ((Integer)proxyPorts.get(startedServerId)).intValue()))) {
            return port;
        }
        IServerWorkingCopy swc = this.getServer().createWorkingCopy();
        int port2 = SocketUtil.findUnusedPort((int)50000, (int)60000);
        proxyPorts.put(startedServerId, port2);
        swc.setAttribute(PROXY_PORTS, proxyPorts);
        swc.saveAll(true, null);
        return port2;
    }

    private void stopProxy(IServer stoppedServer) {
        this.proxyServers.remove(stoppedServer);
        JettyServerRunner proxyRunner = this.proxyRunners.remove(stoppedServer);
        if (proxyRunner != null) {
            JettyServerRunner.stop(proxyRunner);
        }
    }

    public Map<IServer, LiveReloadProxyServer> getProxyServers() {
        return this.proxyServers;
    }

    public void setServerStarting() {
        this.setServerState(1);
    }

    public void setServerStarted() {
        this.setServerState(2);
    }

    public void setServerStopping() {
        this.setServerState(3);
    }

    public void setServerStopped() {
        this.setServerState(4);
    }
}

