/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.util.EventObject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadScriptFileServlet;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadScriptInjectionFilter;
import org.jboss.tools.livereload.core.internal.server.jetty.LiveReloadWebSocketServlet;
import org.jboss.tools.livereload.core.internal.server.jetty.WorkspaceFileServlet;
import org.jboss.tools.livereload.core.internal.service.EventService;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientConnectedEvent;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientConnectionFilter;
import org.jboss.tools.livereload.core.internal.service.LiveReloadClientDisconnectedEvent;
import org.jboss.tools.livereload.core.internal.service.Subscriber;

public class LiveReloadServer
extends Server
implements Subscriber {
    private static final String MIN_WEB_SOCKET_PROTOCOL_VERSION = "minVersion";
    private static final String MIN_WEB_SOCKET_PROTOCOL_VERSION_VALUE = "-1";
    private SelectChannelConnector websocketConnector;
    private final int websocketPort;
    private final String hostname;
    private int connectedClients = 0;

    public LiveReloadServer(String name, String hostname, int websocketPort, boolean enableProxyServer, boolean allowRemoteConnections, boolean enableScriptInjection) {
        this.websocketPort = websocketPort;
        this.hostname = hostname;
        this.configure(name, hostname, websocketPort, enableProxyServer, allowRemoteConnections, enableScriptInjection);
    }

    private void configure(String name, String hostname, int websocketPort, boolean enableProxyServer, boolean allowRemoteConnections, boolean enableScriptInjection) {
        this.setAttribute("serverName", name);
        this.websocketConnector = new SelectChannelConnector();
        if (!allowRemoteConnections) {
            this.websocketConnector.setHost(hostname);
        }
        this.websocketConnector.setStatsOn(true);
        this.websocketConnector.setPort(websocketPort);
        this.websocketConnector.setMaxIdleTime(0);
        this.addConnector((Connector)this.websocketConnector);
        HandlerCollection handlers = new HandlerCollection();
        this.setHandler((Handler)handlers);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handlers, "/", 0);
        context.setConnectorNames(new String[]{this.websocketConnector.getName()});
        ServletHolder liveReloadServletHolder = new ServletHolder((Servlet)new LiveReloadWebSocketServlet());
        liveReloadServletHolder.setInitParameter(MIN_WEB_SOCKET_PROTOCOL_VERSION, MIN_WEB_SOCKET_PROTOCOL_VERSION_VALUE);
        context.addServlet(liveReloadServletHolder, "/livereload");
        context.addServlet(new ServletHolder((Servlet)new LiveReloadScriptFileServlet()), "/livereload.js");
        if (enableProxyServer) {
            context.addServlet(new ServletHolder((Servlet)new WorkspaceFileServlet()), "/*");
            if (enableScriptInjection) {
                context.addFilter(new FilterHolder((Filter)new LiveReloadScriptInjectionFilter(websocketPort)), "/*", null);
            }
        }
        EventService.getInstance().subscribe(this, new LiveReloadClientConnectionFilter());
    }

    public int getNumberOfConnectedClients() {
        return this.connectedClients;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.websocketPort;
    }

    public String toString() {
        return "LiveReload Server";
    }

    @Override
    public void inform(EventObject event) {
        if (event instanceof LiveReloadClientConnectedEvent) {
            ++this.connectedClients;
        } else if (event instanceof LiveReloadClientDisconnectedEvent) {
            --this.connectedClients;
            if (this.connectedClients < 0) {
                this.connectedClients = 0;
            }
        }
    }

    @Override
    public String getId() {
        return this.toString();
    }
}

