/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.jboss.tools.livereload.core.internal.util.HttpUtils;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.ScriptInjectionUtils;

public class LiveReloadScriptInjectionFilter
implements Filter {
    private final String scriptContent;

    public LiveReloadScriptInjectionFilter(int livereloadPort) {
        this.scriptContent = "<script>document.write('<script src=\"http://' + location.host.split(':')[0]+ ':" + livereloadPort + "/livereload.js\"></'+ 'script>')</script>";
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String acceptedContentTypes = httpRequest.getHeader("Accept");
        Logger.trace("Processing request {} {}", httpRequest.getMethod(), httpRequest.getRequestURI());
        if (!"/livereload".equals(httpRequest.getRequestURI()) && HttpUtils.isHtmlContentType(acceptedContentTypes)) {
            Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
            ModifiableHttpServletResponse responseWrapper = new ModifiableHttpServletResponse((HttpServletResponse)response);
            try {
                chain.doFilter(request, (ServletResponse)responseWrapper);
            }
            catch (Throwable throwable) {
                if (!continuation.isResponseWrapped()) {
                    this.terminate(httpRequest, responseWrapper);
                } else {
                    continuation.addContinuationListener(new ContinuationListener(responseWrapper, httpRequest){
                        private final /* synthetic */ ModifiableHttpServletResponse val$responseWrapper;
                        private final /* synthetic */ HttpServletRequest val$httpRequest;
                        {
                            this.val$responseWrapper = modifiableHttpServletResponse;
                            this.val$httpRequest = httpServletRequest;
                        }

                        public void onTimeout(Continuation continuation) {
                            try {
                                this.val$responseWrapper.terminate();
                            }
                            catch (IOException e) {
                                Logger.error("Failed to terminate the response", e);
                            }
                        }

                        public void onComplete(Continuation continuation) {
                            try {
                                LiveReloadScriptInjectionFilter.this.terminate(this.val$httpRequest, this.val$responseWrapper);
                            }
                            catch (IOException e) {
                                Logger.error("Failed to terminate the response", e);
                            }
                        }
                    });
                }
                throw throwable;
            }
            if (!continuation.isResponseWrapped()) {
                this.terminate(httpRequest, responseWrapper);
            } else {
                continuation.addContinuationListener(new /* invalid duplicate definition of identical inner class */);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private void terminate(HttpServletRequest httpRequest, ModifiableHttpServletResponse responseWrapper) throws IOException {
        String returnedContentType = responseWrapper.getHeader("Content-Type");
        Logger.trace(" response type: {}", returnedContentType);
        if (HttpUtils.isHtmlContentType(returnedContentType)) {
            Logger.debug("Injecting livereload.js <script> in response for {} ({})", httpRequest.getRequestURI(), returnedContentType);
            InputStream responseStream = responseWrapper.getResponseAsStream();
            char[] modifiedResponseContent = ScriptInjectionUtils.injectContent(responseStream, this.scriptContent);
            Charset charset = HttpUtils.getContentCharSet(returnedContentType, "UTF-8");
            responseWrapper.terminate(modifiedResponseContent, charset);
        } else {
            Logger.trace("*Not* injecting livereload.js <script> in response for {} ({})", httpRequest.getRequestURI(), returnedContentType);
            responseWrapper.terminate();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public class ByteArrayServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.outputStream.write(b, off, len);
        }

        public void write(byte[] b) throws IOException {
            this.outputStream.write(b);
        }

        public synchronized byte[] toByteArray() {
            return this.outputStream.toByteArray();
        }
    }

    public class ModifiableHttpServletResponse
    extends HttpServletResponseWrapper {
        private ByteArrayServletOutputStream responseOutputStream;

        public ModifiableHttpServletResponse(HttpServletResponse response) {
            super(response);
            this.responseOutputStream = new ByteArrayServletOutputStream();
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return this.responseOutputStream;
        }

        public InputStream getResponseAsStream() throws IOException {
            byte[] byteArray = this.responseOutputStream.toByteArray();
            this.responseOutputStream.close();
            String characterEncoding = this.getCharacterEncoding();
            return IOUtils.toInputStream((String)new String(byteArray, characterEncoding), (String)characterEncoding);
        }

        public void terminate(char[] responseContent, Charset charset) throws IOException {
            CharBuffer charBuffer = CharBuffer.wrap(responseContent);
            ByteBuffer byteBuffer = charset.encode(charBuffer);
            ((HttpServletResponse)this.getResponse()).setHeader("Content-length", Integer.toString(byteBuffer.array().length));
            this.getResponse().getOutputStream().write(byteBuffer.array());
            this.responseOutputStream.close();
        }

        public void terminate() throws IOException {
            byte[] responseContent = this.responseOutputStream.toByteArray();
            this.responseOutputStream.close();
            IOUtils.write((byte[])responseContent, (OutputStream)this.getResponse().getOutputStream());
            this.getResponse().getOutputStream().flush();
            this.getResponse().getOutputStream().close();
        }
    }
}

