/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.livereload.core.internal.server.jetty;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.jboss.tools.livereload.core.internal.util.Logger;
import org.jboss.tools.livereload.core.internal.util.TimeoutUtils;

public class JettyServerRunner
implements Runnable {
    public static final String NAME = "serverName";
    private final Server server;
    private IStatus status = null;

    public static JettyServerRunner start(Server liveReloadServer) throws TimeoutException {
        JettyServerRunner runner = new JettyServerRunner(liveReloadServer);
        Logger.debug("Starting {} on port {}", liveReloadServer, runner.getPort());
        Thread serverThread = new Thread((Runnable)runner, (String)liveReloadServer.getAttribute(NAME));
        serverThread.start();
        TimeoutUtils.TaskMonitor monitor = new TimeoutUtils.TaskMonitor(){

            @Override
            public boolean isComplete() {
                boolean statusOk;
                boolean started = JettyServerRunner.this.isStarted();
                boolean bl = statusOk = JettyServerRunner.this.status != null && !JettyServerRunner.this.status.isOK();
                return started || statusOk;
            }
        };
        if (TimeoutUtils.timeout(monitor, 15L, TimeUnit.SECONDS)) {
            Logger.error("Failed to start " + liveReloadServer + " within expected time (reason: timeout)");
            JettyServerRunner.stop(runner);
            throw new TimeoutException("Failed to start " + liveReloadServer + " within expected time (reason: timeout)");
        }
        return runner;
    }

    public static void stop(JettyServerRunner runner) {
        if (runner != null) {
            try {
                runner.stop();
                TimeoutUtils.TaskMonitor monitor = new TimeoutUtils.TaskMonitor(){

                    @Override
                    public boolean isComplete() {
                        return JettyServerRunner.this.isStopped();
                    }
                };
                if (TimeoutUtils.timeout(monitor, 5L, TimeUnit.SECONDS)) {
                    Logger.error("Failed to stop LiveReload Server within expected time (reason: timeout)");
                    throw new TimeoutException("Failed to stop LiveReload Server within expected time (reason: timeout)");
                }
            }
            catch (Exception e) {
                Logger.error("Failed to stop LiveReload Server", e);
            }
        }
    }

    private JettyServerRunner(Server server) {
        this.server = server;
    }

    @Override
    public void run() {
        try {
            if (!this.server.isStarted()) {
                Logger.debug("Starting {}...", this.server.getAttribute(NAME));
                this.server.start();
                this.status = Status.OK_STATUS;
            }
        }
        catch (Exception startException) {
            this.status = Logger.error("Failed to start '" + this.server.getAttribute(NAME) + "'", startException);
            try {
                this.server.stop();
            }
            catch (Exception stopException) {
                Logger.error("Failed to stop server '" + this.server.getAttribute(NAME) + "' after startup failure", stopException);
            }
        }
    }

    private void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    boolean isStarted() {
        boolean started = this.server.isStarted();
        Connector[] connectorArray = this.server.getConnectors();
        int n = connectorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Connector connector = connectorArray[n2];
            started = started && connector.isStarted();
            ++n2;
        }
        return started;
    }

    public boolean isSuccessfullyStarted() {
        return this.isStarted() && this.status != null && this.status.isOK();
    }

    boolean isStopped() {
        return this.server.isStopped();
    }

    public int getPort() {
        return this.server.getConnectors()[0].getPort();
    }
}

