/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RichFacesVirtualEarthTemplate
extends VpeAbstractTemplate {
    private static String EARTH_AERIAL = "/virtualEarth/earth_aerial.png";
    private static String EARTH_HYBRID = "/virtualEarth/earth_hybrid.png";
    private static String EARTH_ROAD = "/virtualEarth/earth_road.png";
    private static String MAP_STYLE_ATTRIBUTE_NAME = "mapStyle";
    private static String[] MAP_STYLE_VALUES = new String[]{"road", "aerial", "hybrid"};
    private static String STYLE_CLASS_ATTR_NAME = "styleClass";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement img = visualDocument.createElement("IMG");
        if (sourceElement.hasAttribute(MAP_STYLE_ATTRIBUTE_NAME)) {
            String mapStyleValue = sourceElement.getAttribute(MAP_STYLE_ATTRIBUTE_NAME);
            if (mapStyleValue.equalsIgnoreCase(MAP_STYLE_VALUES[0])) {
                ComponentUtil.setImg(img, EARTH_ROAD);
            } else if (mapStyleValue.equalsIgnoreCase(MAP_STYLE_VALUES[1])) {
                ComponentUtil.setImg(img, EARTH_AERIAL);
            } else if (mapStyleValue.equalsIgnoreCase(MAP_STYLE_VALUES[2])) {
                ComponentUtil.setImg(img, EARTH_HYBRID);
            }
        } else {
            ComponentUtil.setImg(img, EARTH_ROAD);
        }
        this.copyStyleAttribute(img, sourceNode);
        if (sourceElement.hasAttribute(STYLE_CLASS_ATTR_NAME)) {
            img.setAttribute("class", sourceElement.getAttribute(STYLE_CLASS_ATTR_NAME));
        }
        return new VpeCreationData((nsIDOMNode)img);
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        nsIDOMElement img = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        if (name.equalsIgnoreCase(MAP_STYLE_ATTRIBUTE_NAME)) {
            if (value.trim().equalsIgnoreCase("") || !this.searchInMapStyleValues(value)) {
                ComponentUtil.setImg(img, EARTH_ROAD);
                return;
            }
            if (value.equalsIgnoreCase(MAP_STYLE_VALUES[0])) {
                ComponentUtil.setImg(img, EARTH_ROAD);
            } else if (value.equalsIgnoreCase(MAP_STYLE_VALUES[1])) {
                ComponentUtil.setImg(img, EARTH_AERIAL);
            } else if (value.equalsIgnoreCase(MAP_STYLE_VALUES[2])) {
                ComponentUtil.setImg(img, EARTH_HYBRID);
            }
            return;
        }
        if (STYLE_CLASS_ATTR_NAME.equals(name)) {
            img.setAttribute("class", value);
        } else {
            img.setAttribute(name, value);
        }
    }

    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
        nsIDOMElement img = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        if (name.equalsIgnoreCase(MAP_STYLE_ATTRIBUTE_NAME)) {
            ComponentUtil.setImg(img, EARTH_ROAD);
            return;
        }
        if (STYLE_CLASS_ATTR_NAME.equals(name)) {
            img.removeAttribute("class");
        } else {
            img.removeAttribute(name);
        }
    }

    private boolean searchInMapStyleValues(String mapStyleValue) {
        int i = 0;
        while (i < MAP_STYLE_VALUES.length) {
            if (MAP_STYLE_VALUES[i].equalsIgnoreCase(mapStyleValue.trim())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void copyStyleAttribute(nsIDOMElement img, Node sourceNode) {
        NamedNodeMap namedNodeMap = sourceNode.getAttributes();
        int i = 0;
        while (i < namedNodeMap.getLength()) {
            Node attribute = namedNodeMap.item(i);
            if (attribute.getNodeName().equalsIgnoreCase("style")) {
                img.setAttribute(attribute.getNodeName(), attribute.getNodeValue());
                return;
            }
            ++i;
        }
    }
}

