/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesSeparatorTemplate
extends VpeAbstractTemplate {
    static final String STYLE_PATH = "separator/separator.css";
    static final String LINE_SOLID = "solid";
    static final String LINE_DOUBLE = "double";
    static final String LINE_DOTTED = "dotted";
    static final String LINE_DASHED = "dashed";
    static final String LINE_BEVELED = "beveled";
    static final String PIXEL_PREFIX = "px";
    static final String PERCENT_PREFIX = "%";
    static final String[] LINE_TYPES = new String[]{"solid", "double", "dotted", "dashed", "beveled"};
    static final String LINE_TYPE_ATTR = "lineType";
    static final String DEFAULT_HEIGHT = "6px";
    static final String DEFAULT_ALIGN = "left";
    static final String DEFAULT_WIDTH = "100%";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        String lineType;
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, "richFacesSeparator");
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement separator = visualDocument.createElement("DIV");
        nsIDOMElement line = visualDocument.createElement("DIV");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)separator);
        String width = sourceElement.hasAttribute("width") ? sourceElement.getAttribute("width") : null;
        String height = sourceElement.hasAttribute("height") ? sourceElement.getAttribute("height") : null;
        separator.setAttribute("align", sourceElement.hasAttribute("align") ? sourceElement.getAttribute("align") : DEFAULT_ALIGN);
        separator.setAttribute("class", "td-parentdiv");
        String styleClassAttrName = "styleClass";
        String lineClass = sourceElement.getAttribute(styleClassAttrName);
        String styleAttrName = "style";
        String style = sourceElement.hasAttribute(styleAttrName) ? sourceElement.getAttribute(styleAttrName) : null;
        String string = lineType = sourceElement.hasAttribute(LINE_TYPE_ATTR) ? sourceElement.getAttribute(LINE_TYPE_ATTR) : null;
        if (!sourceElement.hasAttribute(LINE_TYPE_ATTR) || lineType.equalsIgnoreCase(LINE_BEVELED)) {
            String className = "dr-table-header rich-table-header-continue";
            if (sourceElement.hasAttribute(styleClassAttrName)) {
                className = String.valueOf(className) + " " + lineClass;
            }
            line.setAttribute("class", className);
            style = this.setBeveledStyle(width, height, String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";" + style);
        } else {
            line.setAttribute("class", lineClass);
            style = this.setStyle(lineType, width, height, style);
            line.setAttribute("class", "separator-color");
        }
        line.setAttribute("style", style);
        separator.appendChild((nsIDOMNode)line);
        return creationData;
    }

    public void removeAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name) {
        String lineType;
        super.removeAttribute(pageContext, sourceElement, visualDocument, visualNode, data, name);
        nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        nsIDOMElement line = this.getLineElement(element);
        String style = sourceElement.hasAttribute("style") ? sourceElement.getAttribute("style") : null;
        String width = sourceElement.hasAttribute("width") ? sourceElement.getAttribute("width") : null;
        String height = sourceElement.hasAttribute("height") ? sourceElement.getAttribute("height") : null;
        String string = lineType = sourceElement.hasAttribute(LINE_TYPE_ATTR) ? sourceElement.getAttribute(LINE_TYPE_ATTR) : LINE_BEVELED;
        if (name.equalsIgnoreCase("height") || name.equalsIgnoreCase(LINE_TYPE_ATTR) || name.equalsIgnoreCase("width")) {
            String newStyle = LINE_BEVELED.equalsIgnoreCase(lineType) ? this.setBeveledStyle(width, height, String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";" + style) : this.setStyle(lineType, width == null ? DEFAULT_WIDTH : this.addPrefixSize(width), height == null ? DEFAULT_HEIGHT : this.addPrefixSize(height), style);
            line.setAttribute("style", newStyle);
        } else if (name.equalsIgnoreCase("align")) {
            element.removeAttribute(name);
        } else if (name.equalsIgnoreCase("style")) {
            String newStyle = LINE_BEVELED.equalsIgnoreCase(lineType) ? this.setBeveledStyle(width, height, ComponentUtil.getHeaderBackgoundImgStyle()) : this.setStyle(lineType, width == null ? DEFAULT_WIDTH : this.addPrefixSize(width), height == null ? DEFAULT_HEIGHT : height, "");
            line.setAttribute(name, newStyle);
        } else {
            line.removeAttribute(name);
        }
    }

    public void setAttribute(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        String lineType;
        super.setAttribute(pageContext, sourceElement, visualDocument, visualNode, data, name, value);
        nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)visualNode, nsIDOMElement.class);
        nsIDOMElement line = this.getLineElement(element);
        String style = sourceElement.hasAttribute("style") ? sourceElement.getAttribute("style") : null;
        String width = sourceElement.hasAttribute("width") ? sourceElement.getAttribute("width") : null;
        String height = sourceElement.hasAttribute("height") ? sourceElement.getAttribute("height") : null;
        String string = lineType = sourceElement.hasAttribute(LINE_TYPE_ATTR) ? sourceElement.getAttribute(LINE_TYPE_ATTR) : LINE_BEVELED;
        if (name.equalsIgnoreCase("height")) {
            if (!this.isNumber(value) && value.indexOf(PIXEL_PREFIX) == -1) {
                return;
            }
            String newStyle = LINE_BEVELED.equalsIgnoreCase(lineType) ? this.setBeveledStyle(width, value, String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";" + style) : this.setStyle(lineType, width == null ? DEFAULT_WIDTH : this.addPrefixSize(width), value == null ? DEFAULT_HEIGHT : this.addPrefixSize(value), style);
            line.setAttribute("style", newStyle);
        } else if (name.equalsIgnoreCase("width")) {
            if (!this.isNumber(value) && !this.isHasPrefix(value)) {
                return;
            }
            String newStyle = lineType.equalsIgnoreCase(LINE_BEVELED) ? this.setBeveledStyle(value, height, String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";" + style) : this.setStyle(lineType, value == null ? DEFAULT_WIDTH : this.addPrefixSize(value), height == null ? DEFAULT_HEIGHT : this.addPrefixSize(height), style);
            line.setAttribute("style", newStyle);
        } else if (name.equalsIgnoreCase(LINE_TYPE_ATTR)) {
            if (!this.isLineType(value)) {
                return;
            }
            String newStyle = value.equalsIgnoreCase(LINE_BEVELED) ? this.setBeveledStyle(width, height, String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";" + style) : this.setStyle(value, width == null ? DEFAULT_WIDTH : this.addPrefixSize(width), height == null ? DEFAULT_HEIGHT : this.addPrefixSize(height), style);
            line.setAttribute("style", newStyle);
        } else if (name.equalsIgnoreCase("align")) {
            element.setAttribute(name, value);
        } else if (name.equalsIgnoreCase("style")) {
            String newStyle = lineType.equalsIgnoreCase(LINE_BEVELED) ? this.setBeveledStyle(width, value, String.valueOf(ComponentUtil.getHeaderBackgoundImgStyle()) + ";" + (value == null ? "" : value)) : this.setStyle(lineType, width == null ? DEFAULT_WIDTH : this.addPrefixSize(width), height == null ? DEFAULT_HEIGHT : this.addPrefixSize(height), value);
            line.setAttribute(name, newStyle);
        } else {
            line.setAttribute(name, value);
        }
    }

    private String addPrefixSize(String size) {
        if (size != null && !this.isHasPrefix(size)) {
            size = String.valueOf(size) + PIXEL_PREFIX;
        }
        return size;
    }

    private boolean isNumber(String num) {
        try {
            Integer.valueOf(num);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isHasPrefix(String size) {
        int pos1 = size.indexOf(PIXEL_PREFIX);
        int pos2 = size.indexOf(PERCENT_PREFIX);
        return pos1 != -1 || pos2 != -1;
    }

    private boolean isLineType(String lineType) {
        int i = 0;
        while (i < LINE_TYPES.length) {
            if (lineType.equalsIgnoreCase(LINE_TYPES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private nsIDOMElement getLineElement(nsIDOMElement parent) {
        nsIDOMNodeList list = parent.getChildNodes();
        nsIDOMNode node = list.item(0L);
        nsIDOMElement element = (nsIDOMElement)XPCOM.queryInterface((nsISupports)node, nsIDOMElement.class);
        return element;
    }

    private String setStyle(String lineType, String width, String height, String style) {
        StringBuffer newStyle = new StringBuffer();
        newStyle.append("border-style:" + (lineType == null ? LINE_SOLID : lineType) + ";");
        newStyle.append("border-width:" + (height == null ? DEFAULT_HEIGHT : height) + " 0px 0px;");
        newStyle.append("width:" + (width == null ? DEFAULT_WIDTH : width) + ";");
        newStyle.append(style == null ? "" : style);
        return newStyle.toString();
    }

    private String setBeveledStyle(String width, String height, String style) {
        StringBuffer newStyle = new StringBuffer();
        newStyle.append("height:" + (height == null ? DEFAULT_HEIGHT : height) + ";");
        newStyle.append("width:" + (width == null ? DEFAULT_WIDTH : width) + ";");
        newStyle.append(style == null ? "" : style);
        return newStyle.toString();
    }
}

