/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import java.util.Map;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesProgressBarTemplate
extends VpeAbstractTemplate {
    private static final String CSS_EXTENSION = "progressBar";
    private static final String CSS_PATH = "progressBar/progressBar.css";
    private static final String NBSP = "\u00a0";
    private static final String DEFAULT_HEIGHT = "height: 13px;";
    private static final String DEFAULT_UPLOADED_STATUS = "60%";
    private static final String CSS_PB_BLOCK = "rich-progress-bar-block";
    private static final String CSS_PB_SHELL = "rich-progress-bar-shell";
    private static final String CSS_PB_UPLOADED = "rich-progress-bar-uploaded";
    private static final String CSS_PB_HEIGHT = "rich-progress-bar-height";
    private static final String CSS_PB_WIDTH = "rich-progress-bar-width";
    private static final String CSS_PB_SHELL_DIG = "rich-progress-bar-shell-dig";
    private static final String CSS_PB_UPLOADED_DIG = "rich-progress-bar-uploaded-dig";
    private static final String CSS_PB_REMAINED = "rich-progress-bar-remained";
    private static final String CSS_PB_PADDING = "rich-progress-bar-padding";
    private static final String CSS_PB_COMPLETED = "rich-progress-bar-completed";
    private static final String CSS_PB_HEIGHT_DIG = "rich-progress-bar-height-dig";
    private static final String CSS_PB_VPE_TEXT = "rich-progress-bar-vpe-text";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, CSS_PATH, CSS_EXTENSION);
        Element sourceElement = (Element)sourceNode;
        String style = ComponentUtil.getAttribute(sourceElement, "style");
        String styleClass = ComponentUtil.getAttribute(sourceElement, "styleClass");
        String sourceLabel = ComponentUtil.getAttribute(sourceElement, "label");
        if (ComponentUtil.isBlank(styleClass)) {
            styleClass = "";
        }
        if (ComponentUtil.isBlank(style)) {
            style = DEFAULT_HEIGHT;
        }
        nsIDOMElement progressDiv = visualDocument.createElement("div");
        nsIDOMElement remainDiv = visualDocument.createElement("div");
        nsIDOMElement uploadDiv = visualDocument.createElement("div");
        nsIDOMElement completeDiv = visualDocument.createElement("div");
        nsIDOMElement vpeTextDiv = visualDocument.createElement("div");
        Element initialFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"initial");
        Map initialFacetChildren = VisualDomUtil.findFacetElements((Node)initialFacet, (VpePageContext)pageContext);
        boolean initialFacetHtmlChildrenPresent = ((List)initialFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0;
        Element completeFacet = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"complete");
        Map completeFacetChildren = VisualDomUtil.findFacetElements((Node)completeFacet, (VpePageContext)pageContext);
        boolean completeFacetHtmlChildrenPresent = ((List)completeFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)).size() > 0;
        List<Node> children = ComponentUtil.getChildren(sourceElement, true);
        boolean progressBarWithLabel = initialFacetHtmlChildrenPresent || completeFacetHtmlChildrenPresent || children.size() > 0 || ComponentUtil.isNotBlank(sourceLabel);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)progressDiv);
        if (progressBarWithLabel) {
            progressDiv.setAttribute("class", "rich-progress-bar-block rich-progress-bar-width rich-progress-bar-shell-dig " + styleClass);
            remainDiv.setAttribute("class", "rich-progress-bar-width rich-progress-bar-remained rich-progress-bar-padding");
            uploadDiv.setAttribute("class", CSS_PB_UPLOADED_DIG);
            vpeTextDiv.setAttribute("class", "rich-progress-bar-height-dig rich-progress-bar-uploaded-dig rich-progress-bar-vpe-text");
            completeDiv.setAttribute("class", "rich-progress-bar-height-dig rich-progress-bar-width rich-progress-bar-completed rich-progress-bar-padding");
            VpeChildrenInfo vpeTextInfo = new VpeChildrenInfo(vpeTextDiv);
            if (initialFacetHtmlChildrenPresent) {
                for (Node node : (List)initialFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                    vpeTextInfo.addSourceChild(node);
                }
            }
            if (completeFacetHtmlChildrenPresent) {
                for (Node node : (List)completeFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                    vpeTextInfo.addSourceChild(node);
                }
            }
            for (Node child : children) {
                vpeTextInfo.addSourceChild(child);
            }
            creationData.addChildrenInfo(vpeTextInfo);
            if (ComponentUtil.isNotBlank(sourceLabel)) {
                vpeTextDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(sourceLabel));
            }
            progressDiv.appendChild((nsIDOMNode)remainDiv);
            progressDiv.appendChild((nsIDOMNode)uploadDiv);
            progressDiv.appendChild((nsIDOMNode)vpeTextDiv);
            uploadDiv.appendChild((nsIDOMNode)completeDiv);
            remainDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(NBSP));
            completeDiv.appendChild((nsIDOMNode)visualDocument.createTextNode(NBSP));
        } else {
            progressDiv.setAttribute("class", "rich-progress-bar-block rich-progress-bar-width rich-progress-bar-shell " + styleClass);
            uploadDiv.setAttribute("class", "rich-progress-bar-height rich-progress-bar-uploaded");
            progressDiv.appendChild((nsIDOMNode)uploadDiv);
        }
        remainDiv.setAttribute("style", style);
        uploadDiv.setAttribute("style", "width: 60%; " + style);
        completeDiv.setAttribute("style", style);
        vpeTextDiv.setAttribute("style", style);
        return creationData;
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

