/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesPaint2DTemplate
extends VpeAbstractTemplate {
    private static final String IMAGE_NAME = "/paint2D/paint2D.gif";
    private static final String PAINT2D_CSS_FILE = "/paint2D/paint2D.css";
    private static final String DEFAULT_WIDTH = "10";
    private static final String DEFAULT_HEIGHT = "10";
    private static final String ATTR_TRANSPARENT_VALUE = "transparent";
    private static final String RICH_PAINT2D_STYLE = "rich-paint2D";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        ComponentUtil.setCSSLink(pageContext, PAINT2D_CSS_FILE, "paint2d");
        Element sourceElement = (Element)sourceNode;
        nsIDOMElement img = visualDocument.createElement("img");
        ComponentUtil.setImg(img, IMAGE_NAME);
        String attrValue = ComponentUtil.getAttribute(sourceElement, "style");
        if (attrValue.length() != 0) {
            img.setAttribute("style", attrValue);
        }
        attrValue = ComponentUtil.getAttribute(sourceElement, "styleClass");
        String styleClass = RICH_PAINT2D_STYLE;
        if (attrValue.length() != 0) {
            styleClass = String.valueOf(styleClass) + " " + attrValue;
        }
        img.setAttribute("class", styleClass);
        String width = ComponentUtil.getAttribute(sourceElement, "width", "10");
        img.setAttribute("width", width);
        String height = ComponentUtil.getAttribute(sourceElement, "height", "10");
        img.setAttribute("height", height);
        String bgColor = ComponentUtil.getAttribute(sourceElement, "bgcolor", ATTR_TRANSPARENT_VALUE);
        img.setAttribute("bgcolor", bgColor);
        VpeCreationData creationData = VisualDomUtil.createTemplateWithTextContainer((Element)sourceElement, (nsIDOMElement)img, (String)"span", (nsIDOMDocument)visualDocument);
        return creationData;
    }
}

