/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesPageTemplate
extends VpeAbstractTemplate {
    private static final String CSS_BASIC_STYLE_PATH = "page/page-basic.css";
    private static final String CSS_SIMPLE_THEME_STYLE_PATH = "page/page-theme_simple.css";
    private static final String COMPONENT_NAME = "richFacesPage";
    private static final String FACET_NAME_SUBHEADER = "subheader";
    private static final String FACET_NAME_SIDEBAR = "sidebar";
    private static final String CSS_PAGE = "rich-page";
    private static final String CSS_PAGE_HEADER = "rich-page-header";
    private static final String CSS_PAGE_HEADER_CONTENT = "rich-page-header-content";
    private static final String CSS_PAGE_SUBHEADER = "rich-page-subheader";
    private static final String CSS_PAGE_CONTENT = "rich-page-content";
    private static final String CSS_PAGE_SIDEBAR = "rich-page-sidebar";
    private static final String CSS_PAGE_MAIN = "rich-page-main";
    private static final String CSS_PAGE_BODY = "rich-page-body";
    private static final String CSS_PAGE_FOOTER = "rich-page-footer";
    private static final String CSS_PAGE_FOOTER_CONTENT = "rich-page-footer-content";
    private static final String STYLE_SIDEBAR_LEFT = "float: left;";
    private static final String STYLE_PAGE_MAIN_RIGHT = "float: right;margin-left: -30em;";
    private static final String STYLE_SIDEBAR_RIGHT = "float: right;";
    private static final String STYLE_PAGE_MAIN_LEFT = "float: left;margin-right: -30em;";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        Element subHeaderFacet;
        VpeCreationData creationData = null;
        Element sourceElement = (Element)sourceNode;
        ComponentUtil.setCSSLink(pageContext, CSS_BASIC_STYLE_PATH, COMPONENT_NAME);
        Attributes attrs = new Attributes(sourceElement);
        nsIDOMElement pageDiv = visualDocument.createElement("div");
        nsIDOMElement pageContentDiv = visualDocument.createElement("div");
        nsIDOMElement pageMainDiv = visualDocument.createElement("div");
        nsIDOMElement pageBodyDiv = visualDocument.createElement("div");
        creationData = new VpeCreationData((nsIDOMNode)pageDiv);
        String styleClass = CSS_PAGE;
        if (ComponentUtil.isNotBlank(attrs.getStyleClass())) {
            styleClass = String.valueOf(styleClass) + " " + attrs.getStyleClass();
        }
        pageDiv.setAttribute("class", styleClass);
        String style = "";
        if (ComponentUtil.isNotBlank(attrs.getWidth())) {
            style = String.valueOf(style) + " ; width: " + attrs.getWidth() + "px;";
        }
        if (ComponentUtil.isNotBlank(attrs.getStyle())) {
            style = String.valueOf(style) + " " + attrs.getStyle();
        }
        pageDiv.setAttribute("style", style);
        if (ComponentUtil.isNotBlank(attrs.getDir())) {
            pageDiv.setAttribute("dir", attrs.getDir());
        }
        pageContentDiv.setAttribute("class", CSS_PAGE_CONTENT);
        pageMainDiv.setAttribute("class", CSS_PAGE_MAIN);
        String bodyClass = CSS_PAGE_BODY;
        if (ComponentUtil.isNotBlank(attrs.getBodyClass())) {
            bodyClass = String.valueOf(bodyClass) + " " + attrs.getBodyClass();
        }
        pageBodyDiv.setAttribute("class", bodyClass);
        Element headerFacet = ComponentUtil.getFacet(sourceElement, "header");
        if (headerFacet != null) {
            nsIDOMElement pageHeaderDiv = visualDocument.createElement("div");
            nsIDOMElement pageHeaderContentDiv = visualDocument.createElement("div");
            String headerClass = CSS_PAGE_HEADER;
            if (ComponentUtil.isNotBlank(attrs.getHeaderClass())) {
                headerClass = String.valueOf(headerClass) + " " + attrs.getHeaderClass();
            }
            pageHeaderDiv.setAttribute("class", headerClass);
            pageHeaderContentDiv.setAttribute("class", CSS_PAGE_HEADER_CONTENT);
            pageHeaderDiv.appendChild((nsIDOMNode)pageHeaderContentDiv);
            pageDiv.appendChild((nsIDOMNode)pageHeaderDiv);
            VpeChildrenInfo headerInfo = new VpeChildrenInfo(pageHeaderContentDiv);
            headerInfo.addSourceChild((Node)headerFacet);
            creationData.addChildrenInfo(headerInfo);
        }
        if ((subHeaderFacet = ComponentUtil.getFacet(sourceElement, FACET_NAME_SUBHEADER)) != null) {
            nsIDOMElement pageSubHeaderDiv = visualDocument.createElement("div");
            String subheaderClass = CSS_PAGE_SUBHEADER;
            if (ComponentUtil.isNotBlank(attrs.getSubHeaderClass())) {
                subheaderClass = String.valueOf(subheaderClass) + " " + attrs.getSubHeaderClass();
            }
            pageSubHeaderDiv.setAttribute("class", subheaderClass);
            pageDiv.appendChild((nsIDOMNode)pageSubHeaderDiv);
            VpeChildrenInfo subHeaderInfo = new VpeChildrenInfo(pageSubHeaderDiv);
            subHeaderInfo.addSourceChild((Node)subHeaderFacet);
            creationData.addChildrenInfo(subHeaderInfo);
        }
        pageDiv.appendChild((nsIDOMNode)pageContentDiv);
        Element sidebarFacet = ComponentUtil.getFacet(sourceElement, FACET_NAME_SIDEBAR);
        if (sidebarFacet != null) {
            nsIDOMElement pageSidebarDiv = visualDocument.createElement("div");
            String sidebarClass = CSS_PAGE_SIDEBAR;
            if (ComponentUtil.isNotBlank(attrs.getSidebarClass())) {
                sidebarClass = String.valueOf(sidebarClass) + " " + attrs.getSidebarClass();
            }
            pageSidebarDiv.setAttribute("class", sidebarClass);
            pageContentDiv.appendChild((nsIDOMNode)pageSidebarDiv);
            String sidebarStyle = "";
            Object pageMainDivStyle = "";
            String pageBodyStyle = "";
            double widthDouble = ComponentUtil.parseWidth(attrs.getSidebarWidth());
            if (widthDouble != -1.0) {
                sidebarStyle = String.valueOf(sidebarStyle) + " ; width: " + widthDouble + "em;";
            }
            if (ComponentUtil.isNotBlank(attrs.getSidebarPosition()) && "right".equalsIgnoreCase(attrs.getSidebarPosition())) {
                sidebarStyle = String.valueOf(sidebarStyle) + " float: right;";
                pageMainDivStyle = String.valueOf(pageMainDivStyle) + " float: left;margin-right: -30em;";
                if (widthDouble != -1.0) {
                    pageBodyStyle = String.valueOf(pageBodyStyle) + " ;margin-right: " + widthDouble + "em;";
                }
            } else {
                sidebarStyle = String.valueOf(sidebarStyle) + " float: left;";
                pageMainDivStyle = String.valueOf(pageMainDivStyle) + " float: right;margin-left: -30em;";
                if (widthDouble != -1.0) {
                    pageBodyStyle = String.valueOf(pageBodyStyle) + " ;margin-left: " + widthDouble + "em;";
                }
            }
            pageSidebarDiv.setAttribute("style", sidebarStyle);
            pageMainDiv.setAttribute("style", (String)pageMainDivStyle);
            pageBodyDiv.setAttribute("style", pageBodyStyle);
            VpeChildrenInfo sidebarInfo = new VpeChildrenInfo(pageSidebarDiv);
            sidebarInfo.addSourceChild((Node)sidebarFacet);
            creationData.addChildrenInfo(sidebarInfo);
        }
        pageContentDiv.appendChild((nsIDOMNode)pageMainDiv);
        pageMainDiv.appendChild((nsIDOMNode)pageBodyDiv);
        VpeChildrenInfo pageBodyDivInfo = new VpeChildrenInfo(pageBodyDiv);
        for (Node child : ComponentUtil.getChildren(sourceElement, true)) {
            pageBodyDivInfo.addSourceChild(child);
        }
        creationData.addChildrenInfo(pageBodyDivInfo);
        Element footerFacet = ComponentUtil.getFacet(sourceElement, "footer");
        if (footerFacet != null) {
            nsIDOMElement pageFooterDiv = visualDocument.createElement("div");
            nsIDOMElement pageFooterContentDiv = visualDocument.createElement("div");
            String footerClass = CSS_PAGE_FOOTER;
            if (ComponentUtil.isNotBlank(attrs.getFooterClass())) {
                footerClass = String.valueOf(footerClass) + " " + attrs.getFooterClass();
            }
            pageFooterDiv.setAttribute("class", footerClass);
            pageFooterContentDiv.setAttribute("class", CSS_PAGE_FOOTER_CONTENT);
            pageFooterDiv.appendChild((nsIDOMNode)pageFooterContentDiv);
            pageDiv.appendChild((nsIDOMNode)pageFooterDiv);
            VpeChildrenInfo footerInfo = new VpeChildrenInfo(pageFooterContentDiv);
            footerInfo.addSourceChild((Node)footerFacet);
            creationData.addChildrenInfo(footerInfo);
        }
        return creationData;
    }

    class Attributes {
        private final String BODY_CLASS = "bodyClass";
        private final String CONTENT_CLASS = "contentClass";
        private final String FOOTER_CLASS = "footerClass";
        private final String HEADER_CLASS = "headerClass";
        private final String SUBHEADER_CLASS = "subheaderClass";
        private final String LANG = "lang";
        private final String MARKUP_TYPE = "markupType";
        private final String NAMESPACE = "namespace";
        private final String PAGE_TITLE = "pageTitle";
        private final String SIDEBAR_CLASS = "sidebarClass";
        private final String SIDEBAR_POSITION = "sidebarPosition";
        private final String SIDEBAR_WIDTH = "sidebarWidth";
        private final String THEME = "theme";
        private String bodyClass;
        private String contentClass;
        private String footerClass;
        private String headerClass;
        private String subheaderClass;
        private String dir;
        private String lang;
        private String markupType;
        private String namespace;
        private String pageTitle;
        private String sidebarClass;
        private String sidebarPosition;
        private String sidebarWidth;
        private String style;
        private String styleClass;
        private String theme;
        private String width;

        public Attributes(Element sourceElement) {
            this.bodyClass = sourceElement.getAttribute("bodyClass");
            this.contentClass = sourceElement.getAttribute("contentClass");
            this.footerClass = sourceElement.getAttribute("footerClass");
            this.headerClass = sourceElement.getAttribute("headerClass");
            this.subheaderClass = sourceElement.getAttribute("subheaderClass");
            this.dir = sourceElement.getAttribute("dir");
            this.lang = sourceElement.getAttribute("lang");
            this.markupType = sourceElement.getAttribute("markupType");
            this.namespace = sourceElement.getAttribute("namespace");
            this.pageTitle = sourceElement.getAttribute("pageTitle");
            this.sidebarClass = sourceElement.getAttribute("sidebarClass");
            this.sidebarPosition = sourceElement.getAttribute("sidebarPosition");
            this.sidebarWidth = sourceElement.getAttribute("sidebarWidth");
            this.style = sourceElement.getAttribute("style");
            this.styleClass = sourceElement.getAttribute("styleClass");
            this.theme = sourceElement.getAttribute("theme");
            this.width = sourceElement.getAttribute("width");
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public String getBodyClass() {
            return this.bodyClass;
        }

        public String getContentClass() {
            return this.contentClass;
        }

        public String getFooterClass() {
            return this.footerClass;
        }

        public String getHeaderClass() {
            return this.headerClass;
        }

        public String getSubHeaderClass() {
            return this.subheaderClass;
        }

        public String getDir() {
            return this.dir;
        }

        public String getMarkupType() {
            return this.markupType;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getSidebarClass() {
            return this.sidebarClass;
        }

        public String getSidebarPosition() {
            return this.sidebarPosition;
        }

        public String getSidebarWidth() {
            return this.sidebarWidth;
        }

        public String getStyle() {
            return this.style;
        }

        public String getStyleClass() {
            return this.styleClass;
        }

        public String getTheme() {
            return this.theme;
        }

        public String getWidth() {
            return this.width;
        }
    }
}

