/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFacesListTemplate
extends VpeAbstractTemplate {
    private static final String TYPE_DEFINITIONS = "definitions";
    private static final String TYPE_ORDERED = "ordered";

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        nsIDOMElement innerContainer;
        nsIDOMElement outerContainer;
        Element sourceElement = (Element)sourceNode;
        String firstRowClass = this.getFirstRowClass(sourceElement);
        VpeChildrenInfo termInfo = null;
        String type = sourceElement.getAttribute("type");
        if (TYPE_ORDERED.equals(type)) {
            outerContainer = visualDocument.createElement("ol");
            innerContainer = visualDocument.createElement("li");
        } else if (TYPE_DEFINITIONS.equals(type)) {
            outerContainer = visualDocument.createElement("dl");
            nsIDOMElement termContainer = visualDocument.createElement("dt");
            termContainer.setAttribute("class", firstRowClass);
            outerContainer.appendChild((nsIDOMNode)termContainer);
            Element termElement = SourceDomUtil.getFacetByName((VpePageContext)pageContext, (Element)sourceElement, (String)"term");
            termInfo = new VpeChildrenInfo(termContainer);
            termInfo.addSourceChild((Node)termElement);
            innerContainer = visualDocument.createElement("dd");
        } else {
            outerContainer = visualDocument.createElement("ul");
            innerContainer = visualDocument.createElement("li");
        }
        VisualDomUtil.copyAttribute((Element)sourceElement, (String)"style", (nsIDOMElement)outerContainer, (String)"style");
        VisualDomUtil.copyAttribute((Element)sourceElement, (String)"styleClass", (nsIDOMElement)outerContainer, (String)"class");
        innerContainer.setAttribute("class", firstRowClass);
        outerContainer.appendChild((nsIDOMNode)innerContainer);
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)outerContainer);
        if (termInfo != null) {
            creationData.addChildrenInfo(termInfo);
        }
        NodeList childNodes = sourceElement.getChildNodes();
        VpeChildrenInfo nonFacetChildrenInfo = new VpeChildrenInfo(innerContainer);
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (!SourceDomUtil.isFacetElement((VpePageContext)pageContext, (Node)childNode)) {
                nonFacetChildrenInfo.addSourceChild(childNode);
            }
            ++i;
        }
        creationData.addChildrenInfo(nonFacetChildrenInfo);
        return creationData;
    }

    private String getFirstRowClass(Element sourceElement) {
        StringBuilder firstRowClass = new StringBuilder();
        if (sourceElement.hasAttribute("rowClasses")) {
            String rowClasses = sourceElement.getAttribute("rowClasses");
            int commaIndex = rowClasses.indexOf(",");
            if (commaIndex >= 0) {
                firstRowClass.append(rowClasses.substring(0, commaIndex));
            } else {
                firstRowClass.append(rowClasses);
            }
            firstRowClass.append(" ");
        }
        if (sourceElement.hasAttribute("rowClass")) {
            firstRowClass.append(sourceElement.getAttribute("rowClass"));
        }
        return firstRowClass.toString();
    }
}

