/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFaces;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.util.VpeClassUtil;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;

public class RichFacesDataTableStyleClassesApplier {
    private final List<String> rowClasses;
    private final List<String> columnClasses;

    public RichFacesDataTableStyleClassesApplier(nsIDOMDocument visualDocument, VpePageContext pageContext, Node sourceNode) {
        VpeExpression exprRowClasses = RichFaces.getExprRowClasses();
        VpeExpression exprColumnClasses = RichFaces.getExprColumnClasses();
        try {
            this.rowClasses = VpeClassUtil.getClasses((VpeExpression)exprRowClasses, (Node)sourceNode, (VpePageContext)pageContext);
            this.columnClasses = VpeClassUtil.getClasses((VpeExpression)exprColumnClasses, (Node)sourceNode, (VpePageContext)pageContext);
        }
        catch (VpeExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public void applyClasses(nsIDOMElement targetTable) {
        nsIDOMNodeList tableChildren = targetTable.getChildNodes();
        int rowIndex = 0;
        int tableChildrenLength = (int)tableChildren.getLength();
        int i = 0;
        while (i < tableChildrenLength) {
            nsIDOMNode tableChild = tableChildren.item((long)i);
            if (tableChild.getNodeType() == 1 && "tr".equalsIgnoreCase(tableChild.getNodeName())) {
                nsIDOMElement row = (nsIDOMElement)XPCOM.queryInterface((nsISupports)tableChild, nsIDOMElement.class);
                RichFacesDataTableStyleClassesApplier.applyClass(this.rowClasses, row, rowIndex);
                this.applyClassesToCells(row);
                ++rowIndex;
            }
            ++i;
        }
    }

    private void applyClassesToCells(nsIDOMElement row) {
        int columnClassesSize = this.columnClasses.size();
        if (columnClassesSize > 0) {
            nsIDOMNodeList rowChildren = row.getChildNodes();
            int columnIndex = 0;
            int rowChildrenLength = (int)rowChildren.getLength();
            int j = 0;
            while (j < rowChildrenLength) {
                nsIDOMNode rowChild = rowChildren.item((long)j);
                if (rowChild.getNodeType() == 1 && "td".equalsIgnoreCase(rowChild.getNodeName())) {
                    nsIDOMElement cell = (nsIDOMElement)XPCOM.queryInterface((nsISupports)rowChild, nsIDOMElement.class);
                    RichFacesDataTableStyleClassesApplier.applyClass(this.columnClasses, cell, columnIndex);
                    ++columnIndex;
                }
                ++j;
            }
        }
    }

    private static void applyClass(List<String> classes, nsIDOMElement element, int elementIndex) {
        int classesSize = classes.size();
        if (classesSize > 0) {
            String clazz = classes.get(elementIndex % classesSize);
            String actualClass = element.hasAttribute("class") ? String.valueOf(element.getAttribute("class")) + " " + clazz : clazz;
            element.setAttribute("class", actualClass);
        }
    }
}

