/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractTemplate;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreationData;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RichFacesDataTableScrollerTemplate
extends VpeAbstractTemplate {
    private static final String COMPONENT_NAME = "richFacesDataTableScroller";
    private static final String STYLE_PATH = "dataTableScroller/dataTableScroller.css";
    private static final String RIGHT_DOUBLE_SCROLL_SYMBOL = "\u00bb\u00bb";
    private static final String RIGHT_SINGLE_SCROLL_SYMBOL = "\u00bb";
    private static final String LEFT_DOUBLE_SCROLL_SYMBOL = "\u00ab\u00ab";
    private static final String LEFT_SINGLE_SCROLL_SYMBOL = "\u00ab";
    private static final int DEFAULT_CELLS_NUMBER = 10;
    private static final int DEFAULT_PAGE_NUMBER = 1;
    private static final String CSS_RICH_DATASCR = "rich-datascr";
    private static final String CSS_RICH_DATASCROLLER_TABLE = "rich-dtascroller-table";
    private static final String CSS_RICH_DATASCR_BUTTON = "rich-datascr-button";
    private static final String CSS_RICH_DATASCR_CTRLS_SEPARATOR = "rich-datascr-ctrls-separator";
    private static final String CSS_RICH_DATASCR_ACT = "rich-datascr-act";
    private static final String CSS_RICH_DATASCR_INACT = "rich-datascr-inact";
    private static final String CSS_RICH_DATASCR_BUTTON_DSBLD = "rich-datascr-button-dsbld";
    private static final String ATTR_BOUNDARY_CONTROLS = "boundaryControls";
    private static final String ATTR_FAST_CONTROLS = "fastControls";
    private static final String ATTR_MAX_PAGES = "maxPages";
    private static final String ATTR_PAGE = "page";
    private static final String ATTR_STEP_CONTROLS = "stepControls";
    private static final String ATTR_INACTIVE_STYLE = "inactiveStyle";
    private static final String ATTR_INACTIVE_STYLE_CLASS = "inactiveStyleClass";
    private static final String ATTR_SELECTED_STYLE = "selectedStyle";
    private static final String ATTR_SELECTED_STYLE_CLASS = "selectedStyleClass";
    private static final String ATTR_TABLE_STYLE = "tableStyle";
    private static final String ATTR_TABLE_STYLE_CLASS = "tableStyleClass";
    private static final String ATTR_VALUE_SHOW = "show";
    private static final String FACET_FIRST = "first";
    private static final String FACET_LAST = "last";
    private static final String FACET_FAST_FORWARD = "fastforward";
    private static final String FACET_FAST_REWIND = "fastrewind";
    private static final String FACET_NEXT = "next";
    private static final String FACET_PREVIOUS = "previous";
    private boolean showBoundaryControls;
    private boolean showFastControls;
    private int maxPages;
    private int page;
    private boolean showStepControls;
    private String inactiveStyle;
    private String inactiveStyleClass;
    private String selectedStyle;
    private String selectedStyleClass;
    private String tableStyle;
    private String tableStyleClass;
    private String style;
    private String styleClass;

    public VpeCreationData create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument) {
        this.readAttributes(sourceNode);
        Element sourceElement = (Element)sourceNode;
        ComponentUtil.setCSSLink(pageContext, STYLE_PATH, COMPONENT_NAME);
        nsIDOMElement div = visualDocument.createElement("div");
        VpeCreationData creationData = new VpeCreationData((nsIDOMNode)div);
        creationData.addChildrenInfo(new VpeChildrenInfo(div));
        String align = "center";
        if (sourceElement.hasAttribute("align")) {
            align = sourceElement.getAttribute("align");
        }
        div.setAttribute("align", align);
        div.setAttribute("class", this.styleClass);
        if (ComponentUtil.isNotBlank(this.style)) {
            div.setAttribute("style", this.style);
        }
        nsIDOMElement table = visualDocument.createElement("table");
        nsIDOMElement tbody = visualDocument.createElement("tbody");
        nsIDOMElement tr = visualDocument.createElement("tr");
        tbody.appendChild((nsIDOMNode)tr);
        table.appendChild((nsIDOMNode)tbody);
        div.appendChild((nsIDOMNode)table);
        table.setAttribute("class", this.tableStyleClass);
        if (ComponentUtil.isNotBlank(this.tableStyle)) {
            table.setAttribute("style", this.tableStyle);
        }
        table.setAttribute("cellspacing", "1");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("border", "0");
        Object object = null;
        Element facetElement = null;
        if (this.showBoundaryControls) {
            object = LEFT_DOUBLE_SCROLL_SYMBOL;
            facetElement = ComponentUtil.getFacetElement(sourceElement, FACET_FIRST);
            if (facetElement != null) {
                object = facetElement;
            }
            this.createCell(visualDocument, creationData, tr, object, "rich-datascr-button rich-datascr-button-dsbld", "");
        }
        if (this.showFastControls) {
            object = LEFT_SINGLE_SCROLL_SYMBOL;
            facetElement = ComponentUtil.getFacetElement(sourceElement, FACET_FAST_REWIND);
            if (facetElement != null) {
                object = facetElement;
            }
            this.createCell(visualDocument, creationData, tr, object, "rich-datascr-button rich-datascr-button-dsbld", "");
        }
        if (this.showStepControls) {
            object = "";
            facetElement = ComponentUtil.getFacetElement(sourceElement, FACET_PREVIOUS);
            if (facetElement != null) {
                object = facetElement;
            }
            this.createCell(visualDocument, creationData, tr, object, "rich-datascr-button rich-datascr-button-dsbld", "");
        }
        int i = 1;
        while (i <= this.maxPages) {
            this.createCell(visualDocument, creationData, tr, String.valueOf(i), i == 1 ? this.selectedStyleClass : this.inactiveStyleClass, i == 1 ? this.selectedStyle : this.inactiveStyle);
            ++i;
        }
        if (this.showStepControls) {
            object = "";
            facetElement = ComponentUtil.getFacetElement(sourceElement, FACET_NEXT);
            if (facetElement != null) {
                object = facetElement;
            }
            this.createCell(visualDocument, creationData, tr, object, CSS_RICH_DATASCR_BUTTON, "");
        }
        if (this.showFastControls) {
            object = RIGHT_SINGLE_SCROLL_SYMBOL;
            facetElement = ComponentUtil.getFacetElement(sourceElement, FACET_FAST_FORWARD);
            if (facetElement != null) {
                object = facetElement;
            }
            this.createCell(visualDocument, creationData, tr, object, CSS_RICH_DATASCR_BUTTON, "");
        }
        if (this.showBoundaryControls) {
            object = RIGHT_DOUBLE_SCROLL_SYMBOL;
            facetElement = ComponentUtil.getFacetElement(sourceElement, FACET_LAST);
            if (facetElement != null) {
                object = facetElement;
            }
            this.createCell(visualDocument, creationData, tr, object, CSS_RICH_DATASCR_BUTTON, "");
        }
        return creationData;
    }

    private void createCell(nsIDOMDocument visualDocument, VpeCreationData creationData, nsIDOMElement tr, Object element, String styleClass, String style) {
        nsIDOMElement td = visualDocument.createElement("td");
        td.setAttribute("align", "center");
        if (ComponentUtil.isNotBlank(styleClass)) {
            td.setAttribute("class", styleClass);
        }
        if (ComponentUtil.isNotBlank(style)) {
            td.setAttribute("style", style);
        }
        if (element instanceof String) {
            nsIDOMText cellText = visualDocument.createTextNode((String)element);
            td.appendChild((nsIDOMNode)cellText);
        } else if (element instanceof Element) {
            VpeChildrenInfo facetInfo = new VpeChildrenInfo(td);
            facetInfo.addSourceChild((Node)((Element)element));
            creationData.addChildrenInfo(facetInfo);
        }
        tr.appendChild((nsIDOMNode)td);
    }

    private void readAttributes(Node sourceNode) {
        Element sourceElement = (Element)sourceNode;
        this.showBoundaryControls = !sourceElement.hasAttribute(ATTR_BOUNDARY_CONTROLS) || ATTR_VALUE_SHOW.equalsIgnoreCase(sourceElement.getAttribute(ATTR_BOUNDARY_CONTROLS));
        this.showFastControls = !sourceElement.hasAttribute(ATTR_FAST_CONTROLS) || ATTR_VALUE_SHOW.equalsIgnoreCase(sourceElement.getAttribute(ATTR_FAST_CONTROLS));
        this.maxPages = ComponentUtil.parseNumberAttribute(sourceElement, ATTR_MAX_PAGES, 10);
        this.page = ComponentUtil.parseNumberAttribute(sourceElement, ATTR_PAGE, 1);
        this.showStepControls = !sourceElement.hasAttribute(ATTR_STEP_CONTROLS) || ATTR_VALUE_SHOW.equalsIgnoreCase(sourceElement.getAttribute(ATTR_STEP_CONTROLS));
        this.inactiveStyle = sourceElement.getAttribute(ATTR_INACTIVE_STYLE);
        this.inactiveStyleClass = CSS_RICH_DATASCR_INACT;
        if (sourceElement.hasAttribute(ATTR_INACTIVE_STYLE_CLASS)) {
            this.inactiveStyleClass = String.valueOf(this.inactiveStyleClass) + " " + sourceElement.getAttribute(ATTR_INACTIVE_STYLE_CLASS);
        }
        this.selectedStyle = sourceElement.getAttribute(ATTR_SELECTED_STYLE);
        this.selectedStyleClass = CSS_RICH_DATASCR_ACT;
        if (sourceElement.hasAttribute(ATTR_SELECTED_STYLE_CLASS)) {
            this.selectedStyleClass = String.valueOf(this.selectedStyleClass) + " " + sourceElement.getAttribute(ATTR_SELECTED_STYLE_CLASS);
        }
        this.tableStyle = sourceElement.getAttribute(ATTR_TABLE_STYLE);
        this.tableStyleClass = CSS_RICH_DATASCROLLER_TABLE;
        if (sourceElement.hasAttribute(ATTR_TABLE_STYLE_CLASS)) {
            this.tableStyleClass = String.valueOf(this.tableStyleClass) + " " + sourceElement.getAttribute(ATTR_TABLE_STYLE_CLASS);
        }
        this.style = sourceElement.getAttribute("style");
        this.styleClass = CSS_RICH_DATASCR;
        if (sourceElement.hasAttribute("styleClass")) {
            this.styleClass = String.valueOf(this.styleClass) + " " + sourceElement.getAttribute("styleClass");
        }
    }

    public boolean recreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMElement visualNode, Object data, String name, String value) {
        return true;
    }
}

