/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jsf.vpe.richfaces.template;

import java.util.ArrayList;
import java.util.List;
import org.jboss.tools.jsf.vpe.richfaces.ComponentUtil;
import org.jboss.tools.jsf.vpe.richfaces.template.RichFacesColumnTemplate;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RichFaces {
    public static final String ATTR_ADD_CONTROL_LABEL = "addControlLabel";
    public static final String ATTR_ALIGN = "align";
    public static final String ATTR_BREAK_BEFORE = "breakBefore";
    public static final String ATTR_BREAK_ROW_BEFORE = "breakRowBefore";
    public static final String ATTR_CAPTION_CLASS = "captionClass";
    public static final String ATTR_CAPTION_STYLE = "captionStyle";
    public static final String ATTR_COLLAPSE_ICON = "collapseIcon";
    public static final String ATTR_COLLAPSE_LABEL = "collapseLabel";
    public static final String ATTR_COLUMN_CLASSES = "columnClasses";
    public static final String ATTR_COLUMNS = "columns";
    public static final String ATTR_COLUMNS_WIDTH = "columnsWidth";
    public static final String ATTR_BUTTON_ICON = "buttonIcon";
    public static final String ATTR_BUTTON_ICON_DISABLED = "buttonIconDisabled";
    public static final String ATTR_BUTTON_CLASS = "buttonClass";
    public static final String ATTR_SHOW_INPUT = "showInput";
    public static final String ATTR_LOCALE = "locale";
    public static final String ATTR_CONTROLS_TYPE = "controlsType";
    public static final String ATTR_DEFAULT_LABEL = "defaultLabel";
    public static final String ATTR_LABEL = "label";
    public static final String ATTR_DIRECTION = "direction";
    public static final String ATTR_JOINT_POINT = "jointPoint";
    public static final String ATTR_DISABLED = "disabled";
    public static final String ATTR_ELEMENTS = "elements";
    public static final String ATTR_HEADER_CLASS = "headerClass";
    public static final String ATTR_BODY_CLASS = "bodyClass";
    public static final String ATTR_FOOTER_CLASS = "footerClass";
    public static final String ATTR_INPUT_CLASS = "inputClass";
    public static final String ATTR_INPUT_SIZE = "inputSize";
    public static final String ATTR_INPUT_STYLE = "inputStyle";
    public static final String ATTR_LIST_HEIGHT = "listHeight";
    public static final String ATTR_LIST_WIDTH = "listWidth";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_POPUP = "popup";
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_ROW_CLASS = "rowClass";
    public static final String ATTR_ROW_CLASSES = "rowClasses";
    public static final String ATTR_SELECT_ITEM_LABEL = "itemLabel";
    public static final String ATTR_SELECT_ITEM_VALUE = "itemValue";
    public static final String ATTR_SHOW_BUTTON = "showButton";
    public static final String ATTR_SHOW_BUTTON_LABELS = "showButtonLabels";
    public static final String ATTR_SORT_BY = "sortBy";
    public static final String ATTR_SORT_ICON = "sortIcon";
    public static final String ATTR_SORTABLE = "sortable";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_STYLE_CLASS = "styleClass";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_VISIBLE = "visible";
    public static final String ATTR_WIDTH = "width";
    public static final String ATTR_HEIGHT = "height";
    public static final String ATTR_HORIZONTAL_OFFSET = "horizontalOffset";
    public static final String ATTR_VERTICAL_OFFSET = "verticalOffset";
    public static final String ATTR_ZINDEX = "zindex";
    public static final String ATTR_POSITION = "position";
    public static final String NAME_FACET_LABEL = "label";
    public static final String NAME_FACET_CAPTION = "caption";
    public static final String NAME_FACET_FOOTER = "footer";
    public static final String NAME_FACET_HEADER = "header";
    public static final String NAME_FACET_TERM = "term";
    public static final String NAME_FACET_CONTROLS = "controls";
    public static final String TAG_COLUMN = "column";
    public static final String TAG_COLUMN_GROUP = "columnGroup";
    public static final String TAG_COLUMNS = "columns";
    public static final String TAG_FACET = "facet";
    public static final String TAG_SUB_TABLE = "subTable";
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_LEFT = "left";
    public static final String VALUE_RIGHT = "right";
    public static final String VALUE_TOP = "top";
    public static final String VALUE_BOTTOM = "bottom";
    public static final String VALUE_CENTER = "center";
    public static final String COLLAPSED_STATE = "collapsedState";
    private static VpeExpression exprColumnClasses = null;
    private static VpeExpression exprRowClasses = null;

    private RichFaces() {
    }

    public static VpeExpression getExprColumnClasses() {
        if (exprColumnClasses == null) {
            try {
                exprColumnClasses = VpeExpressionBuilder.buildCompletedExpression((String)"{@columnClasses}", (boolean)true).getExpression();
            }
            catch (VpeExpressionBuilderException e) {
                throw new RuntimeException(e);
            }
        }
        return exprColumnClasses;
    }

    public static VpeExpression getExprRowClasses() {
        if (exprRowClasses == null) {
            try {
                exprRowClasses = VpeExpressionBuilder.buildCompletedExpression((String)"{@rowClasses}", (boolean)true).getExpression();
            }
            catch (VpeExpressionBuilderException e) {
                throw new RuntimeException(e);
            }
        }
        return exprRowClasses;
    }

    public static List<Element> findElementsById(Element root, String id, String tagName) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList nodeList = root.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node child = nodeList.item(i);
            if (child instanceof Element) {
                Element childElement = (Element)child;
                if (childElement.getNodeName().endsWith(tagName) && id.equals(childElement.getAttribute("id"))) {
                    list.add(childElement);
                }
                list.addAll(RichFaces.findElementsById(childElement, id, tagName));
            }
            ++i;
        }
        return list;
    }

    public static boolean readCollapsedStateFromSourceNode(Node sourceNode) {
        boolean isCollapsed = false;
        String collapsedState = (String)sourceNode.getUserData(COLLAPSED_STATE);
        if (collapsedState != null && VALUE_TRUE.equalsIgnoreCase(collapsedState)) {
            isCollapsed = true;
        }
        return isCollapsed;
    }

    public static ArrayList<Element> getColumns(Node parentSourceElement) {
        ArrayList<Element> columns = new ArrayList<Element>();
        NodeList children = parentSourceElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            String nodeName = child.getNodeName();
            if (child instanceof Element && (nodeName.endsWith(TAG_COLUMN) || nodeName.endsWith("columns"))) {
                columns.add((Element)child);
            }
            ++i;
        }
        return columns;
    }

    public static boolean hasColumnWithFacet(ArrayList<Element> columns, String facetName) {
        for (Element column : columns) {
            Node body = ComponentUtil.getFacet(column, facetName, true);
            if (body == null) continue;
            return true;
        }
        return false;
    }

    public static int getColumnsCount(Element sourceElement, ArrayList<Element> columns) {
        int count = 0;
        try {
            count = Integer.parseInt(sourceElement.getAttribute("columns"));
        }
        catch (NumberFormatException numberFormatException) {
            count = RichFaces.calculateRowColumns(sourceElement, columns);
        }
        return count;
    }

    public static int calculateRowColumns(Element sourceElement, ArrayList<Element> columns) {
        int count = 0;
        int currentLength = 0;
        for (Element column : columns) {
            if (!ComponentUtil.isRendered(column)) continue;
            String nodeName = column.getNodeName();
            if (nodeName.endsWith(TAG_COLUMN_GROUP)) {
                count = Math.max(currentLength, count);
                currentLength = RichFaces.calculateRowColumns(sourceElement, RichFaces.getColumns(column));
                count = Math.max(currentLength, count);
                currentLength = 0;
                continue;
            }
            if (nodeName.equals(String.valueOf(sourceElement.getPrefix()) + ":" + TAG_COLUMN) || nodeName.equals(String.valueOf(sourceElement.getPrefix()) + ":" + "columns")) {
                if (RichFacesColumnTemplate.isBreakBefore(column)) {
                    count = Math.max(currentLength, count);
                    currentLength = 0;
                }
                String colspanStr = column.getAttribute("colspan");
                try {
                    currentLength += Integer.parseInt(colspanStr);
                }
                catch (NumberFormatException numberFormatException) {
                    ++currentLength;
                }
                continue;
            }
            if (!nodeName.endsWith(TAG_COLUMN)) continue;
            ++currentLength;
        }
        return Math.max(currentLength, count);
    }
}

