/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.preview.editor.context;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.jboss.tools.common.resref.core.ResourceReference;
import org.jboss.tools.jst.web.tld.TaglibData;
import org.jboss.tools.jst.web.ui.internal.editor.bundle.BundleMap;
import org.jboss.tools.jst.web.ui.internal.editor.editor.IVisualContext;
import org.jboss.tools.jst.web.ui.internal.editor.preferences.VpePreference;
import org.jboss.tools.vpe.editor.context.AbstractPageContext;
import org.jboss.tools.vpe.preview.editor.VpvEditorPart;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;
import org.jboss.tools.vpe.resref.core.TaglibReferenceList;

public class VpvPageContext
extends AbstractPageContext
implements IVisualContext {
    private VpvEditorPart editPart;

    public VpvPageContext(BundleMap bundle, VpvEditorPart editPart) {
        this.bundle = bundle;
        this.editPart = editPart;
    }

    public static boolean isAbsolutePosition() {
        return "yes".equals(VpePreference.USE_ABSOLUTE_POSITION.getValue());
    }

    public void dispose() {
        this.bundle.dispose();
        this.bundle.clearAll();
        this.editPart = null;
    }

    public List<TaglibData> getIncludeTaglibs() {
        if (this.getEditPart() == null) {
            return new ArrayList<TaglibData>();
        }
        IEditorInput input = this.getEditPart().getEditorInput();
        IFile file = null;
        if (input instanceof IFileEditorInput) {
            file = ((IFileEditorInput)input).getFile();
        }
        ResourceReference[] resourceReferences = new ResourceReference[]{};
        if (file != null) {
            resourceReferences = TaglibReferenceList.getInstance().getAllResources(file);
        }
        ArrayList<TaglibData> taglibData = new ArrayList<TaglibData>();
        ResourceReference[] resourceReferenceArray = resourceReferences;
        int n = resourceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceReference resourceReference = resourceReferenceArray[n2];
            taglibData.add(new TaglibData(0, resourceReference.getLocation(), resourceReference.getProperties()));
            ++n2;
        }
        return taglibData;
    }

    public ResourceReference getRuntimeRelativeFolder(IFile file) {
        ResourceReference[] list = RelativeFolderReferenceList.getInstance().getAllResources(file);
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public ResourceReference getRuntimeAbsoluteFolder(IFile file) {
        ResourceReference[] list = AbsoluteFolderReferenceList.getInstance().getAllResources(file);
        if (list.length > 0) {
            return list[list.length - 1];
        }
        return null;
    }

    public static void processDisplayEvents() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        if (display != null) {
            while (display.readAndDispatch()) {
            }
        }
    }

    public void refreshBundleValues() {
    }

    public VpvEditorPart getEditPart() {
        return this.editPart;
    }
}

